/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.examples.simple;

import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.EventHeader;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.FixedEventHeader;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryHelper;
import org.omg.CosNotifyChannelAdmin.EventChannelHelper;
import org.omg.CosNotifyChannelAdmin.ProxyConsumer;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushConsumer;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushConsumerHelper;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.openorb.notify.examples.simple.ORBObjectRef;

public class SequencePushSupplier {
    private static int s_num_push = 2;
    private static int s_batch_size = 5;
    public static final String HDR = "[SequencePushSupplier] ";

    public static void main(String[] args) {
        if (args.length >= 1) {
            try {
                s_num_push = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException ex) {
                System.out.println("Unable to parse argument #" + args[0]);
            }
        }
        if (args.length >= 2) {
            try {
                s_batch_size = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ex) {
                System.out.println("Unable to parse argument #" + args[1]);
            }
        }
        try {
            System.out.println("[SequencePushSupplier] Start example: pushing " + s_batch_size + " events for " + s_num_push + " times");
            System.out.println("[SequencePushSupplier] Initialize the ORB");
            ORB orb = ORB.init((String[])args, null);
            System.out.println("[SequencePushSupplier] Get the event channel");
            EventChannel eventChannel = SequencePushSupplier.getEventChannel(orb);
            if (eventChannel == null) {
                System.err.println("[SequencePushSupplier] No event channel available");
                return;
            }
            System.out.println("[SequencePushSupplier] Obtain the channel's default Supplier Admin");
            SupplierAdmin supplierAdmin = eventChannel.default_supplier_admin();
            System.out.println("[SequencePushSupplier] Obtain a consumer proxy");
            IntHolder proxyId = new IntHolder();
            ProxyConsumer proxyConsumer = null;
            try {
                proxyConsumer = supplierAdmin.obtain_notification_push_consumer(ClientType.SEQUENCE_EVENT, proxyId);
            }
            catch (AdminLimitExceeded ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[SequencePushSupplier] Narrow to a proxy push consumer");
            SequenceProxyPushConsumer sequenceProxyPushConsumer = null;
            try {
                sequenceProxyPushConsumer = SequenceProxyPushConsumerHelper.narrow((Object)proxyConsumer);
            }
            catch (BAD_PARAM ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[SequencePushSupplier] Connect to the consumer proxy: null push supplier");
            try {
                sequenceProxyPushConsumer.connect_sequence_push_supplier(null);
            }
            catch (AlreadyConnected ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[SequencePushSupplier] Pushing events...");
            int cnt = 0;
            try {
                int i = 0;
                while (i < s_num_push) {
                    StructuredEvent[] events = new StructuredEvent[s_batch_size];
                    int jj = 0;
                    while (jj < s_batch_size) {
                        System.out.println("[SequencePushSupplier] Create event");
                        events[jj] = SequencePushSupplier.createEvent(orb, cnt);
                        ++cnt;
                        SequencePushSupplier.showEvent(events[jj]);
                        ++jj;
                    }
                    System.out.println("[SequencePushSupplier] Pushing " + s_num_push + "...");
                    sequenceProxyPushConsumer.push_structured_events(events);
                    ++i;
                }
            }
            catch (Disconnected ex) {
                ex.printStackTrace(System.err);
            }
            System.out.println("[SequencePushSupplier] Done sending events");
            System.out.println("[SequencePushSupplier] Disconnecting (removing) the consumer proxy");
            try {
                sequenceProxyPushConsumer.disconnect_sequence_push_consumer();
            }
            catch (TRANSIENT ex) {
                ex.printStackTrace(System.err);
                return;
            }
            catch (COMM_FAILURE ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[SequencePushSupplier] ORB Shutdown: pending=" + orb.work_pending());
            orb.shutdown(false);
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            return;
        }
        System.out.println("[SequencePushSupplier] Terminate application");
    }

    private static EventChannel getEventChannel(ORB orb) {
        System.out.println("[SequencePushSupplier] Resolve initial reference to the Notification Service EventChannelFactory");
        Object obj = null;
        try {
            obj = orb.resolve_initial_references("NotificationService");
        }
        catch (InvalidName ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[SequencePushSupplier] Narrow the CORBA Object reference to an EventChannelFactory");
        EventChannelFactory eventChannelFactory = null;
        try {
            eventChannelFactory = EventChannelFactoryHelper.narrow((Object)obj);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[SequencePushSupplier] Get a reference to an EventChannel from the file");
        ORBObjectRef objRef = new ORBObjectRef(orb, "channel.ref");
        EventChannel eventChannel = null;
        try {
            Object o = objRef.get();
            eventChannel = EventChannelHelper.narrow((Object)o);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        if (eventChannel == null) {
            System.out.println("[SequencePushSupplier] Event channel does not exist, creating a new one");
            Property[] initialQoS = new Property[]{};
            Property[] initialAdmin = new Property[]{};
            IntHolder channelId = new IntHolder();
            try {
                eventChannel = eventChannelFactory.create_channel(initialQoS, initialAdmin, channelId);
            }
            catch (UnsupportedQoS ex) {
                ex.printStackTrace(System.err);
                return null;
            }
            catch (UnsupportedAdmin ex) {
                ex.printStackTrace(System.err);
                return null;
            }
            System.out.println("[SequencePushSupplier] Storing the new channel reference");
            objRef.set((Object)eventChannel);
        }
        return eventChannel;
    }

    public static StructuredEvent createEvent(ORB orb, int i) {
        Property property1;
        Property property0;
        String eventName = "StructuredEvent" + i;
        EventType eventType = new EventType("OpenORB", "examples");
        FixedEventHeader fixedEventHeader = new FixedEventHeader(eventType, eventName.toString());
        Property[] variableHeader = new Property[2];
        variableHeader[0] = new Property("variable:counter", orb.create_any());
        variableHeader[0].value.insert_string("" + i);
        variableHeader[1] = new Property("variable:(counter*10)", orb.create_any());
        variableHeader[1].value.insert_string("" + i * 10);
        EventHeader eventHeader = new EventHeader(fixedEventHeader, variableHeader);
        Property[] filterableData = new Property[2];
        filterableData[0] = property0 = new Property("filter:counter", orb.create_any());
        filterableData[0].value.insert_string("" + i);
        filterableData[1] = property1 = new Property("filter:(counter*10)", orb.create_any());
        filterableData[1].value.insert_string("" + i * 10);
        Any msg = orb.create_any();
        if (i == s_num_push * s_batch_size - 1) {
            msg.insert_string("done");
        } else {
            msg.insert_string("continue");
        }
        StructuredEvent event = new StructuredEvent(eventHeader, filterableData, msg);
        return event;
    }

    public static void showEvent(StructuredEvent event) {
        System.out.println("[SequencePushSupplier] \tFixed header: " + event.header.fixed_header.event_type.domain_name + "." + event.header.fixed_header.event_type.type_name + "." + event.header.fixed_header.event_name);
        System.out.println("[SequencePushSupplier] \tFilterable data:");
        int i = 0;
        while (i < event.filterable_data.length) {
            try {
                String name = event.filterable_data[i].name;
                String val = event.filterable_data[i].value.extract_string();
                System.out.println("[SequencePushSupplier] \t\t" + name + " : " + val);
            }
            catch (BAD_OPERATION ex) {
                ex.printStackTrace(System.err);
                return;
            }
            ++i;
        }
        System.out.println("[SequencePushSupplier] \tVariable header:");
        int i2 = 0;
        while (i2 < event.header.variable_header.length) {
            try {
                String name = event.header.variable_header[i2].name;
                String val = event.header.variable_header[i2].value.extract_string();
                System.out.println("[SequencePushSupplier] \t\t" + name + " : " + val);
            }
            catch (BAD_OPERATION ex) {
                ex.printStackTrace(System.err);
                return;
            }
            ++i2;
        }
        System.out.print("[SequencePushSupplier] \tRemainder: ");
        String msg = event.remainder_of_body.extract_string();
        System.out.println(msg);
    }
}

