/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.examples.simple;

import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryHelper;
import org.omg.CosNotifyChannelAdmin.EventChannelHelper;
import org.omg.CosNotifyChannelAdmin.ProxySupplier;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplier;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierHelper;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.openorb.notify.examples.simple.ORBObjectRef;
import org.openorb.notify.examples.simple.StructuredPushConsumerImpl;

public class StructuredPushConsumer {
    public static final String HDR = "[StructuredPushConsumer] ";
    private static String s_filter_constraint_str = "$.header.fixed_header.event_name=='StructuredEvent5'";

    public static void main(String[] args) {
        int ii = 0;
        while (ii < args.length) {
            if (!args[ii].startsWith("-ORB")) {
                s_filter_constraint_str = args[ii];
                break;
            }
            ++ii;
        }
        try {
            System.out.println("[StructuredPushConsumer] Start example");
            System.out.println("[StructuredPushConsumer] Initialize the ORB");
            ORB orb = ORB.init((String[])args, null);
            System.out.println("[StructuredPushConsumer] Get the event channel");
            EventChannel eventChannel = StructuredPushConsumer.getEventChannel(orb);
            if (eventChannel == null) {
                System.err.println("[StructuredPushConsumer] No event channel available");
                return;
            }
            System.out.println("[StructuredPushConsumer] Obtain the channel's default Consumer Admin");
            ConsumerAdmin consumerAdmin = eventChannel.default_consumer_admin();
            System.out.println("[StructuredPushConsumer] Obtain a supplier proxy");
            IntHolder proxyId = new IntHolder();
            ProxySupplier proxySupplier = null;
            try {
                proxySupplier = consumerAdmin.obtain_notification_push_supplier(ClientType.STRUCTURED_EVENT, proxyId);
            }
            catch (AdminLimitExceeded ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[StructuredPushConsumer] Narrow to a proxy push supplier");
            StructuredProxyPushSupplier structuredProxyPushSupplier = null;
            try {
                structuredProxyPushSupplier = StructuredProxyPushSupplierHelper.narrow((Object)proxySupplier);
            }
            catch (BAD_PARAM ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[StructuredPushConsumer] Initialize RootPOA");
            Object objPOA = null;
            POA rootPOA = null;
            try {
                objPOA = orb.resolve_initial_references("RootPOA");
            }
            catch (InvalidName ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[StructuredPushConsumer] Narrow the CORBA Object reference to a POA");
            try {
                rootPOA = POAHelper.narrow((Object)objPOA);
            }
            catch (BAD_PARAM ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[StructuredPushConsumer] Create the push consumer and activate on root POA");
            StructuredPushConsumerImpl pushConsumer = new StructuredPushConsumerImpl(orb, rootPOA);
            System.out.println("[StructuredPushConsumer] Create a filter and attach it to the proxy");
            FilterFactory filterFactory = eventChannel.default_filter_factory();
            try {
                Filter myFilter = filterFactory.create_filter("EXTENDED_TCL");
                EventType[] types = new EventType[]{new EventType("OpenORB", "examples")};
                ConstraintExp[] constraints = new ConstraintExp[]{new ConstraintExp(types, s_filter_constraint_str)};
                myFilter.add_constraints(constraints);
                System.out.println("[StructuredPushConsumer] New filter created: " + s_filter_constraint_str);
                structuredProxyPushSupplier.add_filter(myFilter);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[StructuredPushConsumer] Connect to the consumer proxy: push consumer");
            try {
                structuredProxyPushSupplier.connect_structured_push_consumer(pushConsumer.structuredPushConsumer());
            }
            catch (AlreadyConnected ex) {
                ex.printStackTrace(System.err);
                return;
            }
            catch (TypeError ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[StructuredPushConsumer] The server is ready...");
            orb.run();
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            return;
        }
    }

    private static EventChannel getEventChannel(ORB orb) {
        System.out.println("[StructuredPushConsumer] Resolve initial reference to the Notification Service EventChannelFactory");
        Object obj = null;
        try {
            obj = orb.resolve_initial_references("NotificationService");
        }
        catch (InvalidName ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[StructuredPushConsumer] Narrow the CORBA Object reference to an EventChannelFactory");
        EventChannelFactory eventChannelFactory = null;
        try {
            eventChannelFactory = EventChannelFactoryHelper.narrow((Object)obj);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[StructuredPushConsumer] Get a reference to an EventChannel from the file");
        ORBObjectRef objRef = new ORBObjectRef(orb, "channel.ref");
        EventChannel eventChannel = null;
        try {
            Object o = objRef.get();
            eventChannel = EventChannelHelper.narrow((Object)o);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        if (eventChannel == null) {
            System.out.println("[StructuredPushConsumer] Event channel does not exist, creating a new one");
            Property[] initialQoS = new Property[]{};
            Property[] initialAdmin = new Property[]{};
            IntHolder channelId = new IntHolder();
            try {
                eventChannel = eventChannelFactory.create_channel(initialQoS, initialAdmin, channelId);
            }
            catch (UnsupportedQoS ex) {
                ex.printStackTrace(System.err);
                return null;
            }
            catch (UnsupportedAdmin ex) {
                ex.printStackTrace(System.err);
                return null;
            }
            System.out.println("[StructuredPushConsumer] Storing the new channel reference");
            objRef.set((Object)eventChannel);
        }
        return eventChannel;
    }
}

