/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.benchmark;

import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CosNotification.EventHeader;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.FixedEventHeader;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryHelper;
import org.omg.CosNotifyChannelAdmin.EventChannelHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.openorb.notify.benchmark.ORBObjectRef;

public class NotifyBenchmark {
    private static String s_hdr = "";
    protected static ORB s_orb;
    protected static POA s_root_poa;
    protected static EventChannelFactory s_ec_factory;
    private static int s_event_count;
    private static long s_start_time;
    private static long s_proc_time;
    private static int s_partial_event_num;

    protected NotifyBenchmark(String name) {
        s_hdr = name;
    }

    public static POA getRootPOA(ORB orb) {
        Object objPOA = null;
        POA rootPOA = null;
        try {
            objPOA = orb.resolve_initial_references("RootPOA");
        }
        catch (InvalidName ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        try {
            rootPOA = POAHelper.narrow((Object)objPOA);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        return rootPOA;
    }

    public static EventChannelFactory getEventChannelFactory(ORB orb) {
        Object obj = null;
        try {
            obj = orb.resolve_initial_references("NotificationService");
        }
        catch (InvalidName ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        EventChannelFactory eventChannelFactory = null;
        try {
            eventChannelFactory = EventChannelFactoryHelper.narrow((Object)obj);
            return eventChannelFactory;
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    public static EventChannel getEventChannel(ORB orb, EventChannelFactory eventChannelFactory) {
        ORBObjectRef objRef = new ORBObjectRef(orb, "channel.ref");
        EventChannel eventChannel = null;
        try {
            Object obj = objRef.get();
            eventChannel = EventChannelHelper.narrow((Object)obj);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        if (eventChannel == null) {
            System.out.println(s_hdr + "Event channel does not exist, creating a new one");
            Property[] initialQoS = new Property[]{};
            Property[] initialAdmin = new Property[]{};
            IntHolder channelId = new IntHolder();
            try {
                eventChannel = eventChannelFactory.create_channel(initialQoS, initialAdmin, channelId);
            }
            catch (UnsupportedQoS ex) {
                ex.printStackTrace(System.err);
                return null;
            }
            catch (UnsupportedAdmin ex) {
                ex.printStackTrace(System.err);
                return null;
            }
            System.out.println(s_hdr + "Storing the new channel reference");
            objRef.set((Object)eventChannel);
        }
        return eventChannel;
    }

    public static StructuredEvent createEvent(ORB orb, int i, boolean isDone) {
        Property property1;
        Property property0;
        String eventName = "StructuredEvent" + i;
        EventType eventType = new EventType("OpenORB", "benchmark");
        FixedEventHeader fixedEventHeader = new FixedEventHeader(eventType, eventName.toString());
        Property[] variableHeader = new Property[2];
        variableHeader[0] = new Property("variable:counter", orb.create_any());
        variableHeader[0].value.insert_string("" + i);
        variableHeader[1] = new Property("variable:(counter*10)", orb.create_any());
        variableHeader[1].value.insert_string("" + i * 10);
        EventHeader eventHeader = new EventHeader(fixedEventHeader, variableHeader);
        Property[] filterableData = new Property[2];
        filterableData[0] = property0 = new Property("filter:counter", orb.create_any());
        filterableData[0].value.insert_string("" + i);
        filterableData[1] = property1 = new Property("filter:(time)", orb.create_any());
        filterableData[1].value.insert_longlong(System.currentTimeMillis());
        Any msg = orb.create_any();
        if (isDone) {
            msg.insert_string("done");
        } else {
            msg.insert_string("continue");
        }
        StructuredEvent event = new StructuredEvent(eventHeader, filterableData, msg);
        return event;
    }

    public static boolean countEvent(StructuredEvent event) {
        String msg;
        boolean done = false;
        long currentTime = System.currentTimeMillis();
        if (s_start_time == 0L) {
            s_start_time = currentTime;
        }
        long sentTime = event.filterable_data[1].value.extract_longlong();
        long diffTime = currentTime - sentTime;
        s_proc_time += diffTime;
        if (++s_event_count % s_partial_event_num == 0) {
            System.out.println("Received event " + s_event_count + " time=" + event.filterable_data[0].value.extract_string() + " Process time " + diffTime + "...");
            NotifyBenchmark.displayStats();
        }
        if ((msg = event.remainder_of_body.extract_string()).toLowerCase().equals("done")) {
            long stopTime = System.currentTimeMillis();
            long totalTime = stopTime - s_start_time;
            long avgTime = (long)(s_event_count * 1000) / totalTime;
            long avgMillisPerEvent = s_proc_time / (long)s_event_count;
            long eventsPerSec = 1000L / avgMillisPerEvent;
            System.out.println("Number of events: " + s_event_count);
            System.out.println("Total Time (ms): " + totalTime);
            System.out.println("Avg Time (events/sec): " + avgTime);
            System.out.println("Avg Process Time Per Event: " + avgMillisPerEvent);
            System.out.println("Process Rate (events/sec): " + eventsPerSec);
            done = true;
        }
        return done;
    }

    public static void displayStats() {
        long stopTime = System.currentTimeMillis();
        long totalTime = stopTime - s_start_time;
        long avgTime = (long)(s_event_count * 1000) / totalTime;
        System.out.println("Number of events: " + s_event_count);
        System.out.println("Total Time (ms): " + totalTime);
        System.out.println("Avg Time (events/sec): " + avgTime);
    }

    static {
        s_event_count = 0;
        s_start_time = 0L;
        s_proc_time = 0L;
        s_partial_event_num = 20;
    }
}

