/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.benchmark;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class ORBObjectRef {
    private String m_ref_file;
    private ORB m_orb;
    private Object m_ref;

    public ORBObjectRef(ORB orb, String refFile) {
        this.m_orb = orb;
        this.m_ref_file = refFile;
        this.m_ref = null;
        try {
            FileInputStream file = new FileInputStream(this.m_ref_file);
            BufferedReader in = new BufferedReader(new InputStreamReader(file));
            String s = in.readLine();
            if (!s.startsWith("IOR:")) {
                return;
            }
            this.m_ref = this.m_orb.string_to_object(s);
            if (this.m_ref._non_existent()) {
                this.m_ref = null;
            }
            file.close();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public Object get() {
        return this.m_ref;
    }

    public void set(Object ref) {
        this.m_ref = ref;
        try {
            FileOutputStream file = new FileOutputStream(this.m_ref_file);
            PrintWriter out = new PrintWriter(file);
            String ior = this.m_orb.object_to_string(this.m_ref);
            out.println(ior);
            out.flush();
            file.close();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }
}

