/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector;

import java.util.Hashtable;
import org.omg.CORBA.LocalObject;
import org.omg.CosPersistentState.Connector;
import org.omg.CosPersistentState.EndOfAssociationCallback;
import org.omg.CosPersistentState.Parameter;
import org.omg.CosPersistentState.Session;
import org.omg.CosPersistentState.SessionPool;
import org.omg.CosPersistentState.TransactionalSession;
import org.omg.CosTransactions.Coordinator;

public abstract class ConnectorBase
extends LocalObject
implements Connector {
    protected String _id;
    protected Hashtable _object_factories;
    protected Hashtable _home_factories;
    protected Hashtable _session_factories;
    protected Hashtable _session_pool_factories;

    public ConnectorBase(String id) {
        this._id = id;
        this._object_factories = new Hashtable();
        this._home_factories = new Hashtable();
        this._session_factories = new Hashtable();
        this._session_pool_factories = new Hashtable();
    }

    public String implementation_id() {
        return this._id;
    }

    public abstract byte[] get_pid(Object var1);

    public abstract byte[] get_short_pid(Object var1);

    public abstract Session create_basic_session(short var1, String var2, Parameter[] var3);

    public abstract TransactionalSession create_transactional_session(short var1, short var2, EndOfAssociationCallback var3, String var4, Parameter[] var5);

    public abstract SessionPool create_session_pool(short var1, short var2, String var3, Parameter[] var4);

    public abstract TransactionalSession current_session();

    public abstract TransactionalSession[] sessions(Coordinator var1);

    public Class register_storage_object_factory(String storage_type_name, Class factory) {
        Class previous = (Class)this._object_factories.get(storage_type_name);
        if (previous != null) {
            this._home_factories.remove(storage_type_name);
        }
        this._object_factories.put(storage_type_name, factory);
        return previous;
    }

    public Class register_storage_home_factory(String storage_home_type_name, Class factory) {
        Class previous = (Class)this._home_factories.get(storage_home_type_name);
        if (previous != null) {
            this._home_factories.remove(storage_home_type_name);
        }
        this._home_factories.put(storage_home_type_name, factory);
        return previous;
    }

    public Class register_session_factory(String catalog_type_name, Class factory) {
        Class previous = (Class)this._session_factories.get(catalog_type_name);
        if (previous != null) {
            this._session_factories.remove(catalog_type_name);
        }
        this._session_factories.put(catalog_type_name, factory);
        return previous;
    }

    public Class register_session_pool_factory(String catalog_type_name, Class factory) {
        Class previous = (Class)this._session_pool_factories.get(catalog_type_name);
        if (previous != null) {
            this._session_pool_factories.remove(catalog_type_name);
        }
        this._session_pool_factories.put(catalog_type_name, factory);
        return previous;
    }

    public Class get_storage_home_factory(String home_type_name) {
        return (Class)this._home_factories.get(home_type_name);
    }

    public Class get_storage_type_factory(String type_name) {
        return (Class)this._object_factories.get(type_name);
    }

    public Class get_session_type_factory(String type_name) {
        return (Class)this._session_factories.get(type_name);
    }

    public Class get_session_pool_type_factory(String type_name) {
        return (Class)this._session_pool_factories.get(type_name);
    }
}

