/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.database;

import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CosPersistentState.EndOfAssociationCallback;
import org.omg.CosPersistentState.Parameter;
import org.omg.CosPersistentState.Session;
import org.omg.CosPersistentState.SessionPool;
import org.omg.CosPersistentState.TransactionalSession;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.CurrentHelper;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.openorb.orb.pi.OpenORBInitInfo;
import org.openorb.ots.Verbose;
import org.openorb.pss.connector.ConnectorBase;
import org.openorb.pss.connector.database.DatabaseCatalog;
import org.openorb.pss.connector.database.DatabaseCatalogBase;
import org.openorb.pss.connector.database.DatabaseSession;
import org.openorb.pss.connector.database.DatabaseSessionPool;
import org.openorb.pss.connector.database.FlushManager;
import org.openorb.pss.connector.database.PersistentObject;
import org.openorb.pss.connector.database.TransactionalDatabaseSession;

public class DatabaseConnector
extends ConnectorBase {
    private Vector _sessions;
    public static FlushManager manager;
    private ORBInitInfo _info;

    public DatabaseConnector(ORBInitInfo info) {
        super("org.openorb.pss.Database");
        this._info = info;
        manager = new FlushManager((ORB)((OpenORBInitInfo)info).orb());
        manager.setDaemon(true);
        manager.start();
        this._sessions = new Vector();
    }

    public byte[] get_pid(java.lang.Object obj) {
        try {
            PersistentObject pobj = (PersistentObject)obj;
            return pobj.getPID().value();
        }
        catch (Exception ex) {
            throw new PERSIST_STORE(1, CompletionStatus.COMPLETED_NO);
        }
    }

    public byte[] get_short_pid(java.lang.Object obj) {
        try {
            PersistentObject pobj = (PersistentObject)obj;
            return pobj.getPID().short_value();
        }
        catch (Exception ex) {
            throw new PERSIST_STORE(1, CompletionStatus.COMPLETED_NO);
        }
    }

    public Session create_basic_session(short access_mode, String catalog_type_name, Parameter[] additional_parameters) {
        Session session = null;
        if (catalog_type_name.equals("")) {
            session = new DatabaseSession(this._info);
            ((DatabaseCatalogBase)((java.lang.Object)session)).setBaseInfo(this, access_mode, additional_parameters);
            manager.addManager("", (DatabaseCatalog)((java.lang.Object)session));
            return session;
        }
        try {
            Class factory = this.get_session_type_factory(catalog_type_name);
            session = (Session)factory.newInstance();
            if (session != null) {
                ((DatabaseCatalogBase)((java.lang.Object)session)).setBaseInfo(this, access_mode, additional_parameters);
                manager.addManager(catalog_type_name, (DatabaseCatalog)((java.lang.Object)session));
                return session;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        throw new PERSIST_STORE(6, CompletionStatus.COMPLETED_NO);
    }

    public TransactionalSession create_transactional_session(short access_mode, short default_isolation_level, EndOfAssociationCallback callback, String catalog_type_name, Parameter[] additional_parameters) {
        Verbose.print((String)"DatabaseConnector", (String)("create_transactional_session: catalog is " + catalog_type_name));
        TransactionalSession session = null;
        if (catalog_type_name.equals("")) {
            session = new TransactionalDatabaseSession(this._info);
            ((TransactionalDatabaseSession)session).setBaseInfo(this, default_isolation_level, callback, access_mode, additional_parameters);
            this._sessions.addElement(session);
            manager.addManager("", (DatabaseCatalog)((java.lang.Object)session));
            return session;
        }
        try {
            Class factory = this.get_session_type_factory(catalog_type_name);
            session = (TransactionalSession)factory.newInstance();
            if (!(session instanceof TransactionalSession)) {
                throw new PERSIST_STORE(12, CompletionStatus.COMPLETED_NO);
            }
            if (session != null) {
                ((TransactionalDatabaseSession)session).setBaseInfo(this, default_isolation_level, callback, access_mode, additional_parameters);
                this._sessions.addElement(session);
                manager.addManager("", (DatabaseCatalog)((java.lang.Object)session));
                return session;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        throw new PERSIST_STORE(6, CompletionStatus.COMPLETED_NO);
    }

    public SessionPool create_session_pool(short access_mode, short tx_policy, String catalog_type_name, Parameter[] additional_parameters) {
        SessionPool session = null;
        if (catalog_type_name.equals("")) {
            session = new DatabaseSessionPool(this._info);
            ((DatabaseSessionPool)session).setBaseInfo(this, catalog_type_name, tx_policy, access_mode, additional_parameters);
            return session;
        }
        try {
            Class factory = this.get_session_pool_type_factory(catalog_type_name);
            session = factory == null ? new DatabaseSessionPool(this._info) : (SessionPool)factory.newInstance();
            if (session != null) {
                ((DatabaseSessionPool)session).setBaseInfo(this, catalog_type_name, tx_policy, access_mode, additional_parameters);
                return session;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        throw new PERSIST_STORE(6, CompletionStatus.COMPLETED_NO);
    }

    public TransactionalSession current_session() {
        Verbose.print((String)"DatabaseConnector", (String)"current_session called.");
        try {
            Object obj = this._info.resolve_initial_references("TransactionCurrent");
            Current current = CurrentHelper.narrow((Object)obj);
            Verbose.print((String)"DatabaseConnector", (String)("current_session: current status is " + current.get_status().value()));
            switch (current.get_status().value()) {
                case 0: {
                    Coordinator coordinator = current.get_control().get_coordinator();
                    TransactionalSession[] sessions = this.sessions(coordinator);
                    Verbose.print((String)"DatabaseConnector", (String)("current_session: exists " + sessions.length + " opened sessions."));
                    if (sessions.length == 0) {
                        return null;
                    }
                    if (sessions.length > 1) {
                        throw new PERSIST_STORE(4, CompletionStatus.COMPLETED_MAYBE);
                    }
                    return sessions[0];
                }
            }
            throw new PERSIST_STORE();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new PERSIST_STORE();
        }
    }

    public TransactionalSession[] sessions(Coordinator transaction) {
        TransactionalDatabaseSession td = null;
        Vector<TransactionalDatabaseSession> found = new Vector<TransactionalDatabaseSession>();
        Verbose.print((String)"DatabaseConnector", (String)("sessions: _sessions count " + this._sessions.size()));
        int i = 0;
        while (i < this._sessions.size()) {
            td = (TransactionalDatabaseSession)this._sessions.elementAt(i);
            if (td.is_associated_to(transaction)) {
                found.addElement(td);
            }
            ++i;
        }
        TransactionalSession[] sessions = new TransactionalSession[found.size()];
        int i2 = 0;
        while (i2 < found.size()) {
            sessions[i2] = (TransactionalSession)found.elementAt(i2);
            ++i2;
        }
        Verbose.print((String)"DatabaseConnector", (String)("sessions: associated sessions count " + sessions.length));
        return sessions;
    }
}

