/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.database;

import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.openorb.pss.connector.Iterator;
import org.openorb.pss.connector.database.DatabaseCatalog;
import org.openorb.pss.connector.database.PIDFactory;
import org.openorb.pss.connector.database.PersistentObject;
import org.openorb.pss.connector.database.PersistentObjectHome;

public class DatabaseIterator
implements Iterator {
    private StorageObject _object;
    private StorageHomeBase _home;
    private DatabaseCatalog _catalog;
    private int _index;
    private byte[][] _pids;

    public DatabaseIterator(StorageHomeBase home, DatabaseCatalog catalog) {
        this._home = home;
        this._catalog = catalog;
        this.createObject();
        this._index = 0;
        this._pids = catalog.find_all(home);
    }

    public boolean hasMoreElements() {
        return this._index < this._pids.length;
    }

    public void next() {
        ++this._index;
    }

    public StorageObject element() {
        this.loadObject();
        return this._object;
    }

    public StorageObject detach() {
        StorageObject obj = this._object;
        this.createObject();
        return obj;
    }

    public void reset() {
        this._index = 0;
    }

    public void fetch(byte[] pid) {
        int i = 0;
        while (i < this._pids.length) {
            if (new String(pid).equals(new String(this._pids[i]))) {
                this._index = i;
            }
            ++i;
        }
    }

    public void set(int position) {
        this._index = position;
    }

    private void loadObject() {
        ((PersistentObject)((Object)this._object)).setPersistentLinks(PIDFactory.pid_byte_to_pid(this._pids[this._index]), this._home);
        ((PersistentObject)((Object)this._object)).refreshIncarnation();
    }

    private void createObject() {
        this._object = ((PersistentObjectHome)((Object)this._home)).create_object();
    }
}

