/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.database;

import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.openorb.pss.connector.PID;

public class DatabasePID
implements PID {
    private byte[] _catalog_value;
    private byte[] _index_value;
    private byte[] _value;
    private String _catalog_value_str;
    private String _index_value_str;
    private String _value_str;

    public DatabasePID(long catalog, long index, ORBInitInfo info) {
        Codec codec = this.getCodec(info);
        if (codec == null) {
            throw new RuntimeException("failed to resolve Codec value");
        }
        try {
            Any any = ORB.init().create_any();
            any.insert_longlong(catalog);
            this._catalog_value = codec.encode_value(any);
            any.insert_longlong(index);
            this._index_value = codec.encode_value(any);
            byte[] encode = new byte[this._catalog_value.length + this._index_value.length];
            int k = 0;
            while (k < this._index_value.length) {
                encode[k] = this._catalog_value[k];
                ++k;
            }
            int i = 0;
            while (i < this._catalog_value.length) {
                encode[this._catalog_value.length + i] = this._index_value[i];
                ++i;
            }
            this._value = encode;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DatabasePID(byte[] catalog, long index, ORBInitInfo info) {
        this._catalog_value = catalog;
        try {
            Codec codec = this.getCodec(info);
            Any any = ORB.init().create_any();
            any.insert_longlong(index);
            this._index_value = codec.encode_value(any);
            byte[] encode = new byte[this._catalog_value.length + this._index_value.length];
            int k = 0;
            while (k < this._index_value.length) {
                encode[k] = this._catalog_value[k];
                ++k;
            }
            int i = 0;
            while (i < this._catalog_value.length) {
                encode[this._catalog_value.length + i] = this._index_value[i];
                ++i;
            }
            this._value = encode;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DatabasePID(byte[] catalog, byte[] index) {
        this._catalog_value = catalog;
        this._index_value = index;
        try {
            byte[] encode = new byte[this._catalog_value.length + this._index_value.length];
            int k = 0;
            while (k < this._index_value.length) {
                encode[k] = this._catalog_value[k];
                ++k;
            }
            int i = 0;
            while (i < this._catalog_value.length) {
                encode[this._catalog_value.length + i] = this._index_value[i];
                ++i;
            }
            this._value = encode;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DatabasePID(byte[] pid, ORBInitInfo info) {
        this._value = pid;
        this._catalog_value = new byte[this._value.length / 2];
        this._index_value = new byte[this._value.length / 2];
        int k = 0;
        while (k < this._value.length / 2) {
            this._catalog_value[k] = this._value[k];
            this._index_value[k] = this._value[this._value.length / 2 + k];
            ++k;
        }
    }

    public byte[] value() {
        return this._value;
    }

    public byte[] short_value() {
        return this._index_value;
    }

    public byte[] catalog_value() {
        return this._catalog_value;
    }

    public boolean is_same(byte[] value) {
        if (value.length != this._value.length) {
            return false;
        }
        int i = 0;
        while (i < this._value.length) {
            if (value[i] != this._value[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean is_same_short(byte[] value) {
        if (value == null) {
            return false;
        }
        if (value.length != this._index_value.length) {
            return false;
        }
        int i = 0;
        while (i < this._index_value.length) {
            if (value[i] != this._index_value[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean is_same_catalog(byte[] value) {
        if (value.length != this._catalog_value.length) {
            return false;
        }
        int i = 0;
        while (i < this._catalog_value.length) {
            if (value[i] != this._catalog_value[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String value_str() {
        if (this._value_str == null) {
            this._value_str = new String(this._value);
        }
        return this._value_str;
    }

    public String short_value_str() {
        if (this._index_value_str == null) {
            this._index_value_str = new String(this._index_value);
        }
        return this._index_value_str;
    }

    public String catalog_value_str() {
        if (this._catalog_value_str == null) {
            this._catalog_value_str = new String(this._catalog_value);
        }
        return this._catalog_value_str;
    }

    public boolean is_same(PID pid) {
        return this.is_same(pid.value());
    }

    private Codec getCodec(ORBInitInfo info) {
        try {
            CodecFactory codecFactory = (CodecFactory)info.resolve_initial_references("CodecFactory");
            Encoding encoding = new Encoding(0, new Integer(1).byteValue(), new Integer(2).byteValue());
            return codecFactory.create_codec(encoding);
        }
        catch (InvalidName ex) {
            System.out.println("InvalidName");
            return null;
        }
        catch (UnknownEncoding ex) {
            System.out.println("UnknownEncoding");
            return null;
        }
    }
}

