/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.database;

import org.omg.CosPersistentState.TransactionalSession;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.ResourcePOA;
import org.omg.CosTransactions.Vote;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.openorb.pss.connector.database.TransactionalDatabaseSession;
import org.openorb.pss.util.debug;

public class DatabaseResource
extends ResourcePOA {
    private TransactionalSession _session;
    private Coordinator _coordinator;

    public DatabaseResource(TransactionalSession session, Coordinator coordinator) {
        this._session = session;
        this._coordinator = coordinator;
    }

    public Vote prepare() throws HeuristicMixed, HeuristicHazard {
        this._session.end(this._coordinator, true);
        return Vote.VoteCommit;
    }

    public void rollback() throws HeuristicCommit, HeuristicMixed, HeuristicHazard {
        debug.print("Database Resource : Roolback");
        this._session.end(this._coordinator, false);
        this.removeItself();
    }

    public void commit() throws NotPrepared, HeuristicRollback, HeuristicMixed, HeuristicHazard {
        debug.print("Database Resource : Commit");
        this.removeItself();
    }

    public void commit_one_phase() throws HeuristicHazard {
        debug.print("Database Resource : Commit one phase");
        try {
            this.prepare();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.removeItself();
    }

    public void forget() {
        debug.print("Database Resource : Forget");
        this.removeItself();
    }

    public void removeItself() {
        try {
            ((TransactionalDatabaseSession)this._session).remove_database_resource();
            this._poa().deactivate_object(this._object_id());
        }
        catch (ObjectNotActive ex) {
        }
        catch (WrongPolicy wrongPolicy) {
            // empty catch block
        }
    }
}

