/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosPersistentState.Parameter;
import org.omg.CosPersistentState.Session;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.config.PropertyNotFoundException;
import org.openorb.orb.iiop.CDRInputStream;
import org.openorb.orb.iiop.CDROutputStream;
import org.openorb.orb.pi.OpenORBInitInfo;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.database.DatabaseCatalog;
import org.openorb.pss.connector.database.DatabaseCatalogBase;
import org.openorb.pss.connector.database.DatabaseConnector;
import org.openorb.pss.connector.database.DatabaseEntry;
import org.openorb.pss.connector.database.DatabasePID;
import org.openorb.pss.connector.database.DatabaseUtil;
import org.openorb.pss.connector.database.KeyBag;
import org.openorb.pss.connector.database.NotFoundException;
import org.openorb.pss.connector.database.PIDFactory;
import org.openorb.pss.connector.database.PersistentObject;
import org.openorb.pss.connector.database.PersistentObjectHome;
import org.openorb.pss.util.debug;

public class DatabaseSession
extends DatabaseCatalog
implements Session,
DatabaseCatalogBase {
    private static final long CHECK_CONNECTION_RETRY_TIME = 5000L;
    private Hashtable _tables;
    protected String _extension;
    protected String _binary_type = "binary";
    protected Hashtable _cache;
    protected Connection _datastore;
    private ORBInitInfo _info;

    public DatabaseSession() {
        this._info = PIDFactory.info;
        this._tables = new Hashtable();
        this._cache = new Hashtable();
    }

    public DatabaseSession(ORBInitInfo info) {
        this._tables = new Hashtable();
        this._cache = new Hashtable();
        this._info = info;
    }

    public void setBaseInfo(DatabaseConnector connector, short access, Parameter[] parameters) {
        if (parameters == null) {
            throw new NullPointerException("Null parameters argument");
        }
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i] == null) {
                throw new NullPointerException("Parameter " + i + " is a null value.");
            }
            if (parameters[i].name.equals("HomeExtension")) {
                this._extension = parameters[i].val.extract_string();
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < parameters.length) {
            if (parameters[i2].name.equals("HomeExtension")) {
                this._extension = parameters[i2].val.extract_string();
            }
            ++i2;
        }
        this.setCatalogInfo(connector, access, parameters);
        try {
            String sql_type = this.getParameter("sql_type");
            debug.print("sql_type in configuration is " + sql_type);
            if (sql_type != null) {
                this._binary_type = sql_type;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this._datastore = this.connectToDatabase();
    }

    public synchronized PID createHomePID(String storage_home_name) {
        int high = storage_home_name.hashCode();
        return new DatabasePID(high, 0L, this._info);
    }

    public synchronized PID createPID(PID home_pid, long index) {
        return new DatabasePID(home_pid.catalog_value(), index, this._info);
    }

    protected synchronized void register_home_incarnation(Object obj, String storage_home_name) {
        debug.print("Register a new home [ " + storage_home_name + " ]");
        PersistentObjectHome home = (PersistentObjectHome)obj;
        PID pid = this.createHomePID(storage_home_name);
        home.setPersistentLinks(this, pid);
        this._home_from_storage_home_name.put(storage_home_name, obj);
        this._home_from_pid.put(pid.catalog_value_str(), obj);
        if (!this.tableExist(this.tableName(storage_home_name))) {
            this.createTable(this.tableName(storage_home_name), home);
        }
        this._tables.put(pid.catalog_value_str(), this.tableName(storage_home_name));
        debug.print("Home is now ready [ " + storage_home_name + " ]");
    }

    public synchronized void flush() {
        Enumeration enumeration = null;
        DatabaseEntry entry = null;
        if (this._cache.size() != 0) {
            debug.print("Flush data into the database...");
            enumeration = this._cache.elements();
            while (enumeration.hasMoreElements()) {
                entry = (DatabaseEntry)enumeration.nextElement();
                this.write_entry_into_database(entry);
            }
            this._cache.clear();
        }
    }

    public synchronized void refresh() {
        Enumeration enumeration = this._home_from_pid.elements();
        PersistentObjectHome home = null;
        while (enumeration.hasMoreElements()) {
            this._cache.clear();
            home = (PersistentObjectHome)enumeration.nextElement();
            home.refreshAll();
        }
    }

    public synchronized void free_all() {
        this._cache.clear();
    }

    public synchronized void close() {
        try {
            this._datastore.close();
        }
        catch (SQLException ex) {
            System.out.println("openORB CosPSS error : Unable to close database !");
        }
    }

    public StorageHomeBase find_home_base(PID pid) {
        return (StorageHomeBase)this._home_from_pid.get(pid.catalog_value_str());
    }

    protected Connection connectToDatabase() {
        debug.print("Open a connection to the database...");
        Connection connection = null;
        String user = this.getParameter("User");
        String password = this.getParameter("Password");
        String jdbc_driver = this.getParameter("JDBC Driver");
        String jdbc_url = this.getParameter("JDBC URL");
        if (jdbc_driver != null) {
            try {
                Thread.currentThread().getContextClassLoader().loadClass(jdbc_driver).newInstance();
            }
            catch (Exception e) {
                throw new MissingResourceException("Cannot load JDBC driver - cause: " + e.toString(), jdbc_driver, "");
            }
        }
        if (jdbc_url == null) {
            throw new IllegalArgumentException("Missing JDBC URL");
        }
        try {
            connection = user == null || password == null ? DriverManager.getConnection(jdbc_url) : DriverManager.getConnection(jdbc_url, user, password);
        }
        catch (SQLException ex) {
            throw new RuntimeException("Cannot create SQL connection due to: " + ex.toString());
        }
        return connection;
    }

    public String getParameter(String parameter_name) {
        Parameter[] params = this.parameters();
        if (null != params) {
            int i = 0;
            while (i < params.length) {
                if (params[i].name.equalsIgnoreCase(parameter_name)) {
                    return params[i].val.extract_string();
                }
                ++i;
            }
        } else {
            debug.print("Params is null.");
        }
        ORBLoader cfg = ((OpenORBInitInfo)this._info).orb().getLoader();
        try {
            return cfg.getStringProperty("pss.Database." + parameter_name);
        }
        catch (PropertyNotFoundException ex) {
            return null;
        }
    }

    private boolean tableExist(String table_name) {
        debug.print("Check if a table exist [ " + table_name + " ]");
        ResultSet result = null;
        boolean returnValue = false;
        try {
            try {
                DatabaseMetaData meta_data = this._datastore.getMetaData();
                result = meta_data.getTables(null, null, table_name, null);
                returnValue = result.next();
            }
            catch (SQLException ex) {
                System.out.println("OpenORB CosPSS error : Unable to get information about tables... : " + ex.toString());
                this.checkConnection();
                Object var6_7 = null;
                this.closeResources(result, null);
            }
            Object var6_6 = null;
            this.closeResources(result, null);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.closeResources(result, null);
            throw throwable;
        }
        return returnValue;
    }

    protected String tableName(String storage_home_name) {
        String footer = storage_home_name.substring(storage_home_name.indexOf(":") + 1) + this._extension;
        footer = footer.substring(0, footer.lastIndexOf(":"));
        footer = footer.replace('/', '_');
        footer = footer.replace('.', '_');
        return footer;
    }

    private void createTable(String table_name, PersistentObjectHome home) {
        debug.print("Create a new table [ " + table_name + " ]");
        Statement stmt = null;
        try {
            try {
                stmt = this._datastore.createStatement();
                String[] members = home.getHomeMembers();
                String order = "CREATE TABLE " + table_name + " ( pid " + this._binary_type + " PRIMARY KEY";
                int i = 0;
                while (i < members.length) {
                    order = order + ", " + members[i] + " " + this._binary_type;
                    ++i;
                }
                order = order + " )";
                stmt.executeUpdate(order);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                System.out.println("openORB CosPSS error : Unable to create a table...");
                this.checkConnection();
                Object var8_9 = null;
                this.closeResources(null, stmt);
            }
            Object var8_8 = null;
            this.closeResources(null, stmt);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.closeResources(null, stmt);
            throw throwable;
        }
    }

    public void destroy(StorageHomeBase home) {
        this.flush();
        PID pid = ((PersistentObjectHome)((Object)home)).getPID();
        String table_name = (String)this._tables.get(pid.catalog_value_str());
        debug.print("Remove a table [ " + table_name + " ]");
        Statement stmt = null;
        try {
            try {
                stmt = this._datastore.createStatement();
                String order = "DROP TABLE " + table_name;
                stmt.executeUpdate(order);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                System.out.println("OpenORB CosPSS error : Unable to delete a table...");
                this.checkConnection();
                Object var7_8 = null;
                this.closeResources(null, stmt);
            }
            Object var7_7 = null;
            this.closeResources(null, stmt);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.closeResources(null, stmt);
            throw throwable;
        }
    }

    public boolean stored(PID home_pid, PID type_pid) {
        debug.print("stored [ " + home_pid + ", " + type_pid + " ]");
        String table = (String)this._tables.get(home_pid.catalog_value_str());
        ResultSet res = this.getLine(table, type_pid);
        boolean returnValue = false;
        try {
            try {
                returnValue = res.next();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                this.checkConnection();
                Object var8_7 = null;
                this.closeResources(res, null);
            }
            Object var8_6 = null;
            this.closeResources(res, null);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.closeResources(res, null);
            throw throwable;
        }
        return returnValue;
    }

    public InputStream[] read(PID home_pid, PID type_pid, int nb_members) throws NotFoundException {
        debug.print("read [ " + home_pid + ", " + type_pid + " ]");
        InputStream[] input = null;
        DatabaseEntry e = (DatabaseEntry)this._cache.get(type_pid.value_str());
        if (e != null) {
            int i = 0;
            while (i < e.output.length) {
                CDROutputStream output_stream = (CDROutputStream)e.output[i];
                input[i] = DatabaseUtil.getCDRInputStream(DatabaseUtil.getBuffer(output_stream));
                ++i;
            }
            return input;
        }
        String table = (String)this._tables.get(home_pid.catalog_value_str());
        ResultSet res = this.getLine(table, type_pid);
        try {
            if (!res.next()) {
                System.out.println("openORB CosPSS error : Unable to read a storage object !");
                return null;
            }
            CDROutputStream output = null;
            input = new InputStream[nb_members];
            byte[] buffer = null;
            int i = 0;
            while (i < nb_members) {
                buffer = res.getBytes(i + 2);
                output = DatabaseUtil.getCDROutputStream();
                output.write_octet_array(buffer, 0, buffer.length);
                buffer = DatabaseUtil.getBuffer(output);
                input[i] = DatabaseUtil.getCDRInputStream(buffer);
                ++i;
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        return input;
    }

    public void write(PID home_pid, PID type_pid, OutputStream[] output) {
        debug.print("write [ " + home_pid + ", " + type_pid + " ]");
        DatabaseEntry e = (DatabaseEntry)this._cache.get(type_pid.value_str());
        if (e != null) {
            this._cache.remove(type_pid.value_str());
        }
        e = new DatabaseEntry();
        e.home_pid = home_pid;
        e.type_pid = type_pid;
        e.output = output;
        this._cache.put(type_pid.value_str(), e);
        if (this._cache.size() > 10) {
            this.flush();
        }
    }

    public void write_entry_into_database(DatabaseEntry entry) {
        int begin;
        int index;
        int i;
        debug.print("write entry into database");
        String table = (String)this._tables.get(entry.home_pid.catalog_value_str());
        PersistentObjectHome home = (PersistentObjectHome)this._home_from_pid.get(entry.home_pid.catalog_value_str());
        String[] members = home.getHomeMembers();
        String order = "";
        PreparedStatement pstmt = null;
        if (this.stored(entry.home_pid, entry.type_pid)) {
            i = 0;
            while (i < members.length) {
                order = order + members[i] + "=?";
                if (i + 1 < members.length) {
                    order = order + ",";
                }
                ++i;
            }
            order = "UPDATE " + table + " SET " + order + " WHERE pid=?";
            index = members.length;
            begin = 0;
        } else {
            i = 0;
            while (i < members.length) {
                order = order + "?";
                if (i + 1 < members.length) {
                    order = order + ",";
                }
                ++i;
            }
            order = "INSERT INTO " + table + " VALUES ( ?, " + order + " )";
            index = 0;
            begin = 1;
        }
        debug.print("Statement is:" + order);
        try {
            pstmt = this._datastore.prepareStatement(order);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        byte[] buffer = null;
        CDRInputStream input = null;
        int i2 = 0;
        while (i2 < members.length) {
            try {
                CDROutputStream output_stream = (CDROutputStream)entry.output[i2];
                buffer = DatabaseUtil.getBuffer(output_stream);
                input = DatabaseUtil.getCDRInputStream(buffer);
                pstmt.setBytes(1 + i2 + begin, buffer);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i2;
        }
        try {
            try {
                pstmt.setBytes(1 + index, entry.type_pid.value());
                pstmt.executeUpdate();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                this.checkConnection();
                Object var14_18 = null;
                this.closeResources(null, pstmt);
            }
            Object var14_17 = null;
            this.closeResources(null, pstmt);
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            this.closeResources(null, pstmt);
            throw throwable;
        }
    }

    public void remove(PID home_pid, PID type_pid) {
        debug.print("remove [ " + home_pid + ", " + type_pid + " ]");
        DatabaseEntry e = (DatabaseEntry)this._cache.get(type_pid.value_str());
        if (e != null) {
            this._cache.remove(type_pid.value_str());
        }
        String table = (String)this._tables.get(home_pid.catalog_value_str());
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = this._datastore.prepareStatement("DELETE FROM " + table + " WHERE pid=?");
                pstmt.setBytes(1, type_pid.value());
                pstmt.executeUpdate();
            }
            catch (SQLException ex) {
                this.checkConnection();
                Object var10_7 = null;
                this.closeResources(null, pstmt);
            }
            Object var10_6 = null;
            this.closeResources(null, pstmt);
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            this.closeResources(null, pstmt);
            throw throwable;
        }
    }

    public PID find(PID home_pid, KeyBag[] keys) throws NotFoundException {
        debug.print("find [ " + home_pid + " ]");
        this.flush();
        String table = (String)this._tables.get(home_pid.catalog_value_str());
        PreparedStatement pstmt = null;
        ResultSet res = null;
        PID _pid = null;
        try {
            try {
                String order = "";
                int i = 0;
                while (i < keys.length) {
                    order = order + keys[i].name + "=?";
                    if (i + 1 < keys.length) {
                        order = order + " AND ";
                    }
                    ++i;
                }
                pstmt = this._datastore.prepareStatement("SELECT pid FROM " + table + " WHERE " + order);
                CDRInputStream input = null;
                byte[] buffer = null;
                int i2 = 0;
                while (i2 < keys.length) {
                    CDROutputStream output_stream = (CDROutputStream)keys[i2].value;
                    buffer = DatabaseUtil.getBuffer(output_stream);
                    input = DatabaseUtil.getCDRInputStream(buffer);
                    pstmt.setBytes(1 + i2, buffer);
                    ++i2;
                }
                res = pstmt.executeQuery();
                if (!res.next()) {
                    this.closeResources(res, pstmt);
                    throw new NotFoundException();
                }
                byte[] pid = res.getBytes(1);
                _pid = PIDFactory.pid_byte_to_pid(pid);
            }
            catch (Exception ex) {
                this.checkConnection();
                Object var14_15 = null;
                this.closeResources(res, pstmt);
            }
            Object var14_14 = null;
            this.closeResources(res, pstmt);
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.closeResources(res, pstmt);
            throw throwable;
        }
        if (_pid == null) {
            throw new NotFoundException();
        }
        return _pid;
    }

    public PID[] find_pids(PID home_pid) {
        debug.print("find pids [ " + home_pid + " ]");
        this.flush();
        String table = (String)this._tables.get(home_pid.catalog_value_str());
        Vector<PID> list = new Vector<PID>();
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            Object var8_8;
            try {
                pstmt = this._datastore.prepareStatement("SELECT pid FROM " + table);
                res = pstmt.executeQuery();
                while (res.next()) {
                    byte[] pid = res.getBytes(1);
                    list.addElement(PIDFactory.pid_byte_to_pid(pid));
                }
            }
            catch (Exception ex) {
                this.checkConnection();
                var8_8 = null;
                this.closeResources(res, pstmt);
            }
            var8_8 = null;
            this.closeResources(res, pstmt);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.closeResources(res, pstmt);
            throw throwable;
        }
        PID[] pids = new PID[list.size()];
        int i = 0;
        while (i < pids.length) {
            pids[i] = (PID)list.elementAt(i);
            ++i;
        }
        return pids;
    }

    public StorageObject incarnate(StorageHomeBase home_base, byte[] storage_type_pid, String storage_type_id) throws NotFoundException {
        Class clz = this._connector.get_storage_type_factory(storage_type_id);
        if (clz == null) {
            throw new NotFoundException();
        }
        try {
            Object obj = clz.newInstance();
            PID pid = PIDFactory.short_pid_to_pid(storage_type_pid, ((PersistentObjectHome)((Object)home_base)).getPID());
            ((PersistentObject)obj).setPersistentLinks(pid, home_base);
            ((PersistentObject)obj).embeddedBuilder();
            ((PersistentObjectHome)((Object)home_base)).refresh((PersistentObject)obj);
            return (StorageObject)obj;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new PERSIST_STORE(11, CompletionStatus.COMPLETED_NO);
        }
    }

    public StorageObject create_object(StorageHomeBase home_base, String storage_type_id) {
        debug.print("create_object " + storage_type_id);
        Class clz = this._connector.get_storage_type_factory(storage_type_id);
        if (clz == null) {
            throw new PERSIST_STORE();
        }
        try {
            long uuid = this.create_uuid();
            Object obj = clz.newInstance();
            PID pid = this.createPID(((PersistentObjectHome)((Object)home_base)).getPID(), uuid);
            ((PersistentObject)obj).setPersistentLinks(pid, home_base);
            ((PersistentObject)obj).embeddedBuilder();
            return (StorageObject)obj;
        }
        catch (Exception ex) {
            throw new PERSIST_STORE(11, CompletionStatus.COMPLETED_NO);
        }
    }

    public StorageObject create_empty_object(StorageHomeBase home_base, String storage_type_id) {
        debug.print("create_empty_object " + storage_type_id);
        Class clz = this._connector.get_storage_type_factory(storage_type_id);
        if (clz == null) {
            throw new PERSIST_STORE();
        }
        try {
            Object obj = clz.newInstance();
            ((PersistentObject)obj).embeddedBuilder();
            return (StorageObject)obj;
        }
        catch (Exception ex) {
            throw new PERSIST_STORE(11, CompletionStatus.COMPLETED_NO);
        }
    }

    public StorageObject create_embedded_object(StorageHomeBase home_base, String storage_type_id) {
        Class clz = this._connector.get_storage_type_factory(storage_type_id);
        if (clz == null) {
            throw new PERSIST_STORE();
        }
        try {
            Object obj = clz.newInstance();
            ((PersistentObject)obj).setPersistentLinks(null, home_base);
            ((PersistentObject)obj).embeddedBuilder();
            return (StorageObject)obj;
        }
        catch (Exception ex) {
            throw new PERSIST_STORE(11, CompletionStatus.COMPLETED_NO);
        }
    }

    private ResultSet getLine(String table_name, PID pid) {
        ResultSet res = null;
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = this._datastore.prepareStatement("SELECT * from " + table_name + " WHERE pid=?");
                pstmt.setBytes(1, pid.value());
                res = pstmt.executeQuery();
            }
            catch (SQLException ex) {
                System.out.println("openORB CosPSS error : Unable to get a table entry !");
                this.checkConnection();
                Object var7_6 = null;
                this.closeResources(res, pstmt);
            }
            Object var7_5 = null;
            this.closeResources(res, pstmt);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.closeResources(res, pstmt);
            throw throwable;
        }
        return res;
    }

    private long create_uuid() {
        return System.currentTimeMillis() * 32L;
    }

    private void closeResources(ResultSet result, Statement statement) {
        if (result != null) {
            try {
                result.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                System.out.println("Error while closing SQL result.");
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                System.out.println("Error while closing SQL statement.");
            }
        }
    }

    private void checkConnection() {
        while (!this.executeCheckQuery()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean executeCheckQuery() {
        debug.print("Checking database connection");
        String testStatement = this.getParameter("ConnectionTestSQL");
        if (testStatement == null) {
            testStatement = "SELECT 1 + 1";
        }
        Statement stmt = null;
        boolean isOK = false;
        try {
            try {
                stmt = this._datastore.createStatement();
                stmt.execute(testStatement);
                isOK = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Database connection is broken. Try to create a new connection...");
                try {
                    this._datastore = this.connectToDatabase();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    System.out.println("Error while creating a new database connection.");
                }
                Object var7_5 = null;
                this.closeResources(null, stmt);
            }
            Object var7_4 = null;
            this.closeResources(null, stmt);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.closeResources(null, stmt);
            throw throwable;
        }
        return isOK;
    }
}

