/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.file;

import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.openorb.pss.connector.PID;

public class FilePID
implements PID {
    private byte[] _catalog_value;
    private byte[] _index_value;
    private byte[] _value;
    private String _catalog_value_str;
    private String _index_value_str;
    private String _value_str;

    public FilePID(long catalog, long index, ORBInitInfo info) {
        try {
            Codec codec = this.getCodec(info);
            Any pany = ORB.init().create_any();
            pany.insert_longlong(catalog);
            byte[] encode_catalog = codec.encode_value(pany);
            this._catalog_value = encode_catalog;
            pany.insert_longlong(index);
            byte[] encode_index = codec.encode_value(pany);
            this._index_value = encode_index;
            byte[] encode = new byte[encode_catalog.length + encode_index.length];
            int k = 0;
            while (k < encode_catalog.length) {
                encode[k] = encode_catalog[k];
                ++k;
            }
            int k2 = 0;
            while (k2 < encode_index.length) {
                encode[encode_catalog.length + k2] = encode_index[k2];
                ++k2;
            }
            this._value = encode;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public FilePID(byte[] catalog, long index, ORBInitInfo info) {
        try {
            Codec codec = this.getCodec(info);
            Any pany = ORB.init().create_any();
            this._catalog_value = catalog;
            pany.insert_longlong(index);
            byte[] encode_index = codec.encode_value(pany);
            this._index_value = encode_index;
            byte[] encode = new byte[this._catalog_value.length + encode_index.length];
            int k = 0;
            while (k < this._catalog_value.length) {
                encode[k] = this._catalog_value[k];
                ++k;
            }
            int k2 = 0;
            while (k2 < encode_index.length) {
                encode[this._catalog_value.length + k2] = encode_index[k2];
                ++k2;
            }
            this._value = encode;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public FilePID(byte[] catalog, byte[] index) {
        try {
            this._catalog_value = catalog;
            this._index_value = index;
            byte[] encode = new byte[this._catalog_value.length + this._index_value.length];
            int k = 0;
            while (k < this._catalog_value.length) {
                encode[k] = this._catalog_value[k];
                ++k;
            }
            int k2 = 0;
            while (k2 < this._index_value.length) {
                encode[this._catalog_value.length + k2] = this._index_value[k2];
                ++k2;
            }
            this._value = encode;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public FilePID(byte[] pid, ORBInitInfo info) {
        this._value = pid;
        this._catalog_value = new byte[this._value.length / 2];
        this._index_value = new byte[this._value.length / 2];
        int k = 0;
        while (k < this._value.length / 2) {
            this._catalog_value[k] = this._value[k];
            this._index_value[k] = this._value[this._value.length / 2 + k];
            ++k;
        }
    }

    public byte[] value() {
        return this._value;
    }

    public byte[] short_value() {
        return this._index_value;
    }

    public byte[] catalog_value() {
        return this._catalog_value;
    }

    public boolean is_same(byte[] value) {
        if (value.length != this._value.length) {
            return false;
        }
        int i = 0;
        while (i < this._value.length) {
            if (value[i] != this._value[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean is_same_short(byte[] value) {
        if (value.length != this._index_value.length) {
            return false;
        }
        int i = 0;
        while (i < this._index_value.length) {
            if (value[i] != this._index_value[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean is_same_catalog(byte[] value) {
        if (value.length != this._catalog_value.length) {
            return false;
        }
        int i = 0;
        while (i < this._catalog_value.length) {
            if (value[i] != this._catalog_value[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String value_str() {
        if (this._value_str == null) {
            this._value_str = new String(this._value);
        }
        return this._value_str;
    }

    public String short_value_str() {
        if (this._index_value_str == null) {
            this._index_value_str = new String(this._index_value);
        }
        return this._index_value_str;
    }

    public String catalog_value_str() {
        if (this._catalog_value_str == null) {
            this._catalog_value_str = new String(this._catalog_value);
        }
        return this._catalog_value_str;
    }

    public boolean is_same(PID pid) {
        return this.is_same(pid.value());
    }

    private Codec getCodec(ORBInitInfo info) {
        if (info == null) {
            throw new NullPointerException("Illegal null info argument.");
        }
        try {
            CodecFactory codecFactory = (CodecFactory)info.resolve_initial_references("CodecFactory");
            Encoding encoding = new Encoding(0, new Integer(1).byteValue(), new Integer(2).byteValue());
            return codecFactory.create_codec(encoding);
        }
        catch (InvalidName ex) {
            System.out.println("InvalidName");
            return null;
        }
        catch (UnknownEncoding ex) {
            System.out.println("UnknownEncoding");
            return null;
        }
    }
}

