/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.file;

import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.ResourcePOA;
import org.omg.CosTransactions.Vote;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.openorb.pss.connector.file.TransactionalDataManager;
import org.openorb.pss.connector.file.TransactionalFileSession;

public class FileResource
extends ResourcePOA {
    private TransactionalFileSession _tfs;
    private Coordinator _coordinator;

    public FileResource(TransactionalFileSession tfs, Coordinator coordinator) {
        this._tfs = tfs;
        this._coordinator = coordinator;
    }

    public Vote prepare() throws HeuristicMixed, HeuristicHazard {
        this._tfs.end(this._coordinator, true);
        if (this._tfs.access_mode() == 0) {
            try {
                this.forget();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Vote.VoteReadOnly;
        }
        return Vote.VoteCommit;
    }

    public void rollback() throws HeuristicCommit, HeuristicMixed, HeuristicHazard {
        TransactionalDataManager[] managers = this._tfs.get_data_managers();
        int i = 0;
        while (i < managers.length) {
            managers[i].rollback();
            ++i;
        }
        this.removeItself();
    }

    public void commit() throws NotPrepared, HeuristicRollback, HeuristicMixed, HeuristicHazard {
        TransactionalDataManager[] managers = this._tfs.get_data_managers();
        int i = 0;
        while (i < managers.length) {
            managers[i].commit();
            ++i;
        }
        this.removeItself();
    }

    public void commit_one_phase() throws HeuristicHazard {
        try {
            this.prepare();
            this.commit();
        }
        catch (HeuristicHazard ex) {
            throw ex;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void forget() {
        TransactionalDataManager[] managers = this._tfs.get_data_managers();
        int i = 0;
        while (i < managers.length) {
            managers[i].forget();
            ++i;
        }
        this.removeItself();
    }

    public void removeItself() {
        try {
            this._tfs.remove_file_resource();
            this._poa().deactivate_object(this._object_id());
        }
        catch (ObjectNotActive ex) {
        }
        catch (WrongPolicy wrongPolicy) {
            // empty catch block
        }
    }
}

