/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.memory;

import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.Connector;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.Parameter;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObjectRef;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.openorb.pss.connector.ExtendedCatalog;
import org.openorb.pss.connector.Iterator;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.memory.MemoryConnector;
import org.openorb.pss.connector.memory.MemoryIterator;
import org.openorb.pss.connector.memory.PIDFactory;
import org.openorb.pss.connector.memory.PersistentObject;
import org.openorb.pss.connector.memory.PersistentObjectHome;

public abstract class MemoryCatalog
extends LocalObject
implements CatalogBase,
ExtendedCatalog {
    protected MemoryConnector _connector;
    protected Hashtable _home_incarnations;
    protected Hashtable _home_pid = new Hashtable();
    private short _access;
    private Parameter[] _parameters;
    private ORBInitInfo _info;

    public MemoryCatalog() {
        this._home_incarnations = new Hashtable();
        this._info = PIDFactory.info;
    }

    public MemoryCatalog(ORBInitInfo info) {
        this._home_incarnations = new Hashtable();
        this._info = info;
    }

    public Connector connector() {
        return this._connector;
    }

    public void setCatalogInfo(MemoryConnector connector, short access, Parameter[] parameters) {
        this._connector = connector;
        this._access = access;
        this._parameters = parameters;
    }

    public short access_mode() {
        return this._access;
    }

    public Parameter[] parameters() {
        return this._parameters;
    }

    public StorageHomeBase find_storage_home(String storage_home_id) throws NotFound {
        PID pid = (PID)this._home_pid.get(storage_home_id);
        StorageHomeBase home = null;
        if (pid != null) {
            home = (StorageHomeBase)this._home_incarnations.get(pid);
        }
        if (home == null) {
            Class clz = this._connector.get_storage_home_factory(storage_home_id);
            if (clz == null) {
                throw new NotFound();
            }
            try {
                Object obj = clz.newInstance();
                this.register_home_incarnation(obj, storage_home_id);
                return (StorageHomeBase)obj;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new PERSIST_STORE(11, CompletionStatus.COMPLETED_NO);
            }
        }
        return home;
    }

    public Object find_by_pid(byte[] the_pid) throws NotFound {
        Enumeration enumeration = this._home_incarnations.elements();
        PersistentObjectHome object_home = null;
        StorageHomeBase home = null;
        byte[] catalog_pid = PIDFactory.pid_to_catalog_pid(the_pid, this._info);
        byte[] short_pid = PIDFactory.pid_to_short_pid(the_pid);
        while (enumeration.hasMoreElements()) {
            object_home = (PersistentObjectHome)enumeration.nextElement();
            PID home_pid = object_home.getPID();
            if (!home_pid.is_same_catalog(catalog_pid)) continue;
            home = (StorageHomeBase)((Object)object_home);
            Object object = home.find_by_short_pid(short_pid);
            if (object == null) {
                throw new NotFound();
            }
            return object;
        }
        throw new NotFound();
    }

    public StorageObjectRef find_ref_by_pid(byte[] the_pid) throws NotFound {
        Enumeration enumeration = this._home_incarnations.elements();
        PersistentObjectHome object_home = null;
        Object home = null;
        byte[] catalog_pid = PIDFactory.pid_to_catalog_pid(the_pid, this._info);
        byte[] short_pid = PIDFactory.pid_to_short_pid(the_pid);
        while (enumeration.hasMoreElements()) {
            object_home = (PersistentObjectHome)enumeration.nextElement();
            PID home_pid = object_home.getPID();
            if (!home_pid.is_same_catalog(catalog_pid)) continue;
            return object_home.create_reference(the_pid);
        }
        throw new NotFound();
    }

    public byte[][] find_all(StorageHomeBase home) {
        PID home_pid = ((PersistentObjectHome)((Object)home)).getPID();
        Object[] incarnations = ((PersistentObjectHome)((Object)home)).get_incarnations();
        byte[][] all = new byte[incarnations.length][];
        int i = 0;
        while (i < incarnations.length) {
            all[i] = ((PersistentObject)incarnations[i]).getPID().value();
            ++i;
        }
        return all;
    }

    public Iterator iterator(StorageHomeBase home) {
        return new MemoryIterator(home, this);
    }

    public void clean(StorageHomeBase home) {
    }

    public void destroy(StorageHomeBase home) {
    }

    protected abstract void register_home_incarnation(Object var1, String var2);

    public abstract StorageHomeBase find_home_base(PID var1);

    public abstract void close();

    public abstract void free_all();

    public abstract void refresh();

    public abstract void flush();
}

