/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.memory;

import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CosPersistentState.EndOfAssociationCallback;
import org.omg.CosPersistentState.Parameter;
import org.omg.CosPersistentState.Session;
import org.omg.CosPersistentState.SessionPool;
import org.omg.CosPersistentState.TransactionalSession;
import org.omg.CosTransactions.Coordinator;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.openorb.pss.connector.ConnectorBase;
import org.openorb.pss.connector.memory.MemoryCatalogBase;
import org.openorb.pss.connector.memory.MemorySession;
import org.openorb.pss.connector.memory.MemorySessionPool;
import org.openorb.pss.connector.memory.PersistentObject;
import org.openorb.pss.connector.memory.TransactionalMemorySession;

public class MemoryConnector
extends ConnectorBase {
    private ORBInitInfo _info;
    private TransactionalMemorySession pseudo_transactional_session;

    public MemoryConnector(ORBInitInfo info) {
        super("org.openorb.pss.Memory");
        this._info = info;
    }

    public byte[] get_pid(Object obj) {
        try {
            PersistentObject pobj = (PersistentObject)obj;
            return pobj.getPID().value();
        }
        catch (Exception ex) {
            throw new PERSIST_STORE(1, CompletionStatus.COMPLETED_NO);
        }
    }

    public byte[] get_short_pid(Object obj) {
        try {
            PersistentObject pobj = (PersistentObject)obj;
            return pobj.getPID().short_value();
        }
        catch (Exception ex) {
            throw new PERSIST_STORE(1, CompletionStatus.COMPLETED_NO);
        }
    }

    public Session create_basic_session(short access_mode, String catalog_type_name, Parameter[] additional_parameters) {
        Session session = null;
        if (catalog_type_name.equals("")) {
            session = new MemorySession(this._info);
            ((MemoryCatalogBase)((Object)session)).setBaseInfo(this, access_mode, additional_parameters);
            return session;
        }
        try {
            Class factory = this.get_session_type_factory(catalog_type_name);
            session = (Session)factory.newInstance();
            if (session != null) {
                ((MemoryCatalogBase)((Object)session)).setBaseInfo(this, access_mode, additional_parameters);
                return session;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        throw new PERSIST_STORE(6, CompletionStatus.COMPLETED_NO);
    }

    public TransactionalSession create_transactional_session(short access_mode, short default_isolation_level, EndOfAssociationCallback callback, String catalog_type_name, Parameter[] additional_parameters) {
        TransactionalSession session = null;
        if (catalog_type_name.equals("")) {
            session = new TransactionalMemorySession(this._info);
            ((MemorySession)((Object)session)).setBaseInfo(this, access_mode, additional_parameters);
            return session;
        }
        try {
            Class factory = this.get_session_type_factory(catalog_type_name);
            session = (TransactionalSession)factory.newInstance();
            if (!(session instanceof TransactionalSession)) {
                throw new PERSIST_STORE(12, CompletionStatus.COMPLETED_NO);
            }
            if (session != null) {
                ((MemorySession)((Object)session)).setBaseInfo(this, access_mode, additional_parameters);
                return session;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        throw new PERSIST_STORE(6, CompletionStatus.COMPLETED_NO);
    }

    public SessionPool create_session_pool(short access_mode, short tx_policy, String catalog_type_name, Parameter[] additional_parameters) {
        SessionPool session = null;
        this.pseudo_transactional_session = (TransactionalMemorySession)this.create_transactional_session(access_mode, (short)0, null, catalog_type_name, additional_parameters);
        if (catalog_type_name.equals("")) {
            session = new MemorySessionPool(this._info);
            ((MemorySession)((Object)session)).setBaseInfo(this, access_mode, additional_parameters);
            return session;
        }
        try {
            Class factory = this.get_session_pool_type_factory(catalog_type_name);
            session = factory == null ? new MemorySessionPool(this._info) : (SessionPool)factory.newInstance();
            if (session != null) {
                ((MemorySession)((Object)session)).setBaseInfo(this, access_mode, additional_parameters);
                return session;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        throw new PERSIST_STORE(6, CompletionStatus.COMPLETED_NO);
    }

    public TransactionalSession current_session() {
        return this.pseudo_transactional_session;
    }

    public TransactionalSession[] sessions(Coordinator transaction) {
        throw new NO_IMPLEMENT();
    }
}

