/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.memory;

import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.openorb.pss.connector.Iterator;
import org.openorb.pss.connector.memory.MemoryCatalog;
import org.openorb.pss.connector.memory.PersistentObjectHome;

public class MemoryIterator
implements Iterator {
    private StorageObject _object;
    private StorageHomeBase _home;
    private MemoryCatalog _catalog;
    private int _index;
    private Object[] _incarnations;

    public MemoryIterator(StorageHomeBase home, MemoryCatalog catalog) {
        this._home = home;
        this._catalog = catalog;
        this._index = 0;
        this._incarnations = ((PersistentObjectHome)((Object)this._home)).get_incarnations();
    }

    public boolean hasMoreElements() {
        return this._index < this._incarnations.length;
    }

    public void next() {
        ++this._index;
    }

    public StorageObject element() {
        return (StorageObject)this._incarnations[this._index];
    }

    public StorageObject detach() {
        if (this._index < this._incarnations.length) {
            return (StorageObject)this._incarnations[this._index];
        }
        return null;
    }

    public void reset() {
        this._index = 0;
    }

    public void fetch(byte[] pid) {
        int i = 0;
        while (i < this._incarnations.length) {
            byte[] _pid = ((StorageObject)this._incarnations[i]).get_pid();
            if (new String(pid).equals(new String(_pid))) {
                this._index = i;
            }
            ++i;
        }
    }

    public void set(int position) {
        this._index = position;
    }
}

