/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.connector.memory;

import java.io.File;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.openorb.compiler.CompilerProperties;
import org.openorb.compiler.idl.reflect.idlIdentifier;
import org.openorb.compiler.idl.reflect.idlObject;
import org.openorb.compiler.idl.reflect.idlState;
import org.openorb.compiler.idl.reflect.idlStruct;
import org.openorb.compiler.idl.reflect.idlStructMember;
import org.openorb.compiler.idl.reflect.idlTypeDef;
import org.openorb.compiler.idl.reflect.idlValue;
import org.openorb.compiler.idl.util.tools;
import org.openorb.pss.compiler.PsdlCompilerProperties;
import org.openorb.pss.compiler.reflect.psdlAbstractStorageHome;
import org.openorb.pss.compiler.reflect.psdlAbstractStorageType;
import org.openorb.pss.compiler.reflect.psdlCatalog;
import org.openorb.pss.compiler.reflect.psdlFactory;
import org.openorb.pss.compiler.reflect.psdlKey;
import org.openorb.pss.compiler.reflect.psdlRef;
import org.openorb.pss.compiler.reflect.psdlState;
import org.openorb.pss.compiler.reflect.psdlStorageHome;
import org.openorb.pss.compiler.reflect.psdlStorageType;
import org.openorb.pss.compiler.reflect.psdlStore;
import org.openorb.pss.wrapper.PsdlWrapper;

public class MemoryWrapper
implements PsdlWrapper {
    private final PsdlCompilerProperties m_pcp;

    public MemoryWrapper(PsdlCompilerProperties pcp) {
        this.m_pcp = pcp;
    }

    public void map_storagetype(File into, psdlStorageType st) {
        PrintWriter file = tools.createNewFile((File)into, (String)st.idlName());
        this.map_header(file);
        tools.writePackageName((CompilerProperties)this.m_pcp, (PrintWriter)file, (idlObject)st);
        file.println();
        file.print("public");
        if (this.contains_local_op(st)) {
            file.print(" abstract");
        }
        file.print(" class " + st.idlName());
        file.print(" implements ");
        psdlAbstractStorageType[] implem = st.implemented();
        int i = 0;
        while (i < implem.length) {
            file.print(org.openorb.pss.compiler.util.tools.javaName(this.m_pcp, implem[i]));
            file.print(", ");
            ++i;
        }
        file.println("org.openorb.pss.connector.memory.PersistentObject");
        file.println("{");
        this.map_states(st, file);
        file.println("    private org.openorb.pss.connector.PID _pid;");
        file.println();
        file.println("    private org.omg.CosPersistentState.StorageHomeBase _home_base;");
        file.println();
        file.println("    private org.openorb.pss.connector.memory.PersistentObject _container = null;");
        file.println();
        this.map_embedded_builder(st, file);
        file.println("    // StorageObject methods");
        file.println("    public void destroy_object()");
        file.println("    { ");
        this.map_strong_ref(st, file);
        file.println("        if ( _container != null )");
        file.println("           return;");
        file.println("        try");
        file.println("        {");
        file.println("            ((org.openorb.pss.connector.memory.PersistentObjectHome)_home_base).remove_storage_type( _pid );");
        file.println("        }");
        file.println("        catch ( org.openorb.pss.connector.memory.NotFoundException ex )");
        file.println("        { }");
        file.println("    }");
        file.println();
        file.println("    public boolean object_exists()");
        file.println("    {");
        file.println("        if ( _container != null )");
        file.println("           return true;");
        file.println("        return ((org.openorb.pss.connector.memory.PersistentObjectHome)_home_base).is_stored( _pid );");
        file.println("    }");
        file.println();
        file.println("    public byte[] get_pid()");
        file.println("    {");
        file.println("        if ( _container != null )");
        file.println("           throw new org.omg.CORBA.PERSIST_STORE( 10, org.omg.CORBA.CompletionStatus.COMPLETED_NO );");
        file.println("        return _pid.value();");
        file.println("    }");
        file.println();
        file.println("    public byte[] get_short_pid()");
        file.println("    { ");
        file.println("        if ( _container != null )");
        file.println("           throw new org.omg.CORBA.PERSIST_STORE( 10, org.omg.CORBA.CompletionStatus.COMPLETED_NO );");
        file.println("        return _pid.short_value();");
        file.println("    }");
        file.println();
        file.println("    public org.omg.CosPersistentState.StorageHomeBase get_storage_home()");
        file.println("    { ");
        file.println("        return _home_base;");
        file.println("    }");
        file.println();
        file.println("    // State member accessors");
        this.map_states_accessors(st, file);
        file.println("    // PersistentObject methods");
        file.println("    public org.openorb.pss.connector.PID getPID()");
        file.println("    {");
        file.println("        return _pid;");
        file.println("    }");
        file.println();
        file.println("    public void setPersistentLinks( ");
        file.println("                org.openorb.pss.connector.PID pid,");
        file.println("                org.omg.CosPersistentState.StorageHomeBase home_base )");
        file.println("    { ");
        file.println("        _pid = pid;");
        file.println("        _home_base = home_base;");
        file.println("    }");
        file.println();
        file.println("    public void markAsEmbedded( org.openorb.pss.connector.memory.PersistentObject container )");
        file.println("    {");
        file.println("        _container = container;");
        file.println("    }");
        file.println();
        file.println("}");
        file.close();
        this.map_storagetype_ref(into, st);
    }

    private boolean contains_local_op(psdlStorageType st) {
        if (st.containsObject(105)) {
            return true;
        }
        psdlStorageType base = st.inheritance();
        if (base != null && this.contains_local_op(base)) {
            return true;
        }
        psdlAbstractStorageType[] ast = st.implemented();
        int i = 0;
        while (i < ast.length) {
            if (this.abstract_contains_local_op(ast[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean abstract_contains_local_op(psdlAbstractStorageType ast) {
        psdlAbstractStorageType[] base = ast.inheritance();
        int i = 0;
        while (i < base.length) {
            if (this.abstract_contains_local_op(base[i])) {
                return true;
            }
            ++i;
        }
        return ast.containsObject(105);
    }

    private void map_header(PrintWriter file) {
        file.println("/*************************************************************************");
        file.println(" OpenORB Persistent State Service                                         ");
        file.println();
        file.println("                       Generated file for Memory Persistence              ");
        file.println();
        file.println(" (c) 2002 The Community OpenORB");
        file.println("*************************************************************************/");
        file.println();
    }

    private psdlState[] mappable_states(psdlStorageType st, boolean inherited) {
        psdlState[] states = null;
        Vector v = new Vector();
        Vector excluded = new Vector();
        this.get_states(st, v, excluded, inherited);
        states = new psdlState[v.size()];
        int i = 0;
        while (i < v.size()) {
            states[i] = (psdlState)v.elementAt(i);
            ++i;
        }
        return states;
    }

    private void get_states(psdlStorageType st, Vector v, Vector ex, boolean inherited) {
        psdlState state = null;
        psdlStorageType base = st.inheritance();
        if (base != null) {
            if (inherited) {
                this.get_states(base, v, ex, true);
            } else {
                this.get_states(base, ex, ex, true);
            }
        }
        psdlAbstractStorageType[] ast = st.implemented();
        int i = 0;
        while (i < ast.length) {
            this.get_states_with_inheritance_for(ast[i], v, ex);
            ++i;
        }
        Enumeration list = st.filter(109);
        while (list.hasMoreElements()) {
            state = (psdlState)list.nextElement();
            if (v.contains(state)) continue;
            v.addElement(state);
        }
    }

    private void get_states_with_inheritance_for(psdlAbstractStorageType ast, Vector v, Vector ex) {
        psdlAbstractStorageType[] inheritance = ast.inheritance();
        psdlState state = null;
        int i = 0;
        while (i < inheritance.length) {
            this.get_states_with_inheritance_for(inheritance[i], v, ex);
            ++i;
        }
        Enumeration list = ast.filter(109);
        while (list.hasMoreElements()) {
            state = (psdlState)list.nextElement();
            if (v.contains(state) || ex.contains(state)) continue;
            v.addElement(state);
        }
    }

    private void map_embedded_builder(psdlStorageType st, PrintWriter file) {
        psdlState[] states = this.mappable_states(st, true);
        file.println("    // Embedded builder");
        file.println("    public void embeddedBuilder()");
        file.println("    {");
        int i = 0;
        while (i < states.length) {
            if (states[i].stateType().idlConcreteType() == 100) {
                file.print("        _" + states[i].idlName() + "_state = ( ");
                psdlStore store = org.openorb.pss.compiler.util.tools.get_store_for(st, states[i]);
                org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, store.as(), file);
                file.println(" ) ((org.openorb.pss.connector.memory.MemoryCatalogBase)_home_base.get_catalog()).create_embedded_object(_home_base, \"" + store.as().idlID() + "\");");
                file.println("        ((org.openorb.pss.connector.memory.PersistentObject)_" + states[i].idlName() + "_state).markAsEmbedded( this );");
            }
            ++i;
        }
        file.println("    }");
        file.println();
    }

    private void map_strong_ref(psdlStorageType st, PrintWriter file) {
        psdlState[] states = this.mappable_states(st, false);
        int i = 0;
        while (i < states.length) {
            psdlRef ref;
            if (states[i].stateType().idlType() == 108 && (ref = (psdlRef)states[i].stateType()).strong()) {
                file.println("        if ( _" + states[i].idlName() + "_state != null )");
                file.println("           _" + states[i].idlName() + "_state.destroy_object();");
            }
            ++i;
        }
    }

    private void map_states(psdlStorageType st, PrintWriter file) {
        psdlState[] states = this.mappable_states(st, true);
        this.map_states_for(states, file);
    }

    private void map_states_for(psdlState[] list, PrintWriter file) {
        int i = 0;
        while (i < list.length) {
            file.print("    protected ");
            org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, list[i].stateType(), file);
            file.println(" _" + list[i].idlName() + "_state;");
            file.println();
            ++i;
        }
    }

    private void map_states_accessors(psdlStorageType st, PrintWriter file) {
        psdlState[] states = this.mappable_states(st, true);
        this.map_states_accessors_for(states, file);
    }

    private void map_states_accessors_for(psdlState[] list, PrintWriter file) {
        int i = 0;
        while (i < list.length) {
            if (list[i].isImmutable()) {
                file.print("    public final ");
                org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, list[i].stateType(), file);
                file.println(" " + list[i].idlName() + "()");
                file.println("    {");
                file.println("        return _" + list[i].idlName() + "_state;");
                file.println("    }");
                file.println();
                if (!list[i].isReadOnly()) {
                    file.print("    public final void " + list[i].idlName() + "( ");
                    org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, list[i].stateType(), file);
                    file.println(" _arg )");
                    file.println("    {");
                    file.println("        _" + list[i].idlName() + "_state = _arg;");
                    file.println("    }");
                    file.println();
                } else {
                    file.print("    final void " + list[i].idlName() + "( ");
                    org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, list[i].stateType(), file);
                    file.println(" _arg )");
                    file.println("    {");
                    file.println("        _" + list[i].idlName() + "_state = _arg;");
                    file.println("    }");
                    file.println();
                }
            } else if (list[i].isRef()) {
                psdlRef ref = (psdlRef)this.finalType(list[i].stateType());
                file.print("    public final ");
                org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, list[i].stateType(), file);
                file.println(" " + list[i].idlName() + "( org.omg.CosPersistentState.YieldRef yr )");
                file.println("    {");
                file.println("        return _" + list[i].idlName() + "_state;");
                file.println("    }");
                file.println();
                file.print("    public final ");
                org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, ref.referenceType(), file);
                file.println(" " + list[i].idlName() + "()");
                file.println("    {");
                file.println("        if ( _" + list[i].idlName() + "_state != null )");
                file.print("            return ( ");
                file.print(org.openorb.pss.compiler.util.tools.javaName(this.m_pcp, ref.referenceType()));
                file.println(" )_" + list[i].idlName() + "_state.deref();");
                file.println("        return null;");
                file.println("    }");
                file.println();
                if (!list[i].isReadOnly()) {
                    file.print("    public final void " + list[i].idlName() + "( ");
                    org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, list[i].stateType(), file);
                    file.println(" _arg )");
                    file.println("    {");
                    file.println("        _" + list[i].idlName() + "_state = _arg;");
                    file.println("    }");
                    file.println();
                    file.print("    public final void " + list[i].idlName() + "( ");
                    org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, ref.referenceType(), file);
                    file.println(" _arg )");
                    file.println("    {");
                    file.println("        ((org.openorb.pss.connector.memory.PersistentRef)_" + list[i].idlName() + "_state ).update( _arg.get_pid() );");
                    file.println("    }");
                    file.println();
                } else {
                    file.print("    final void " + list[i].idlName() + "( ");
                    org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, list[i].stateType(), file);
                    file.println(" _arg )");
                    file.println("    {");
                    file.println("        _" + list[i].idlName() + "_state = _arg;");
                    file.println("    }");
                    file.println();
                    file.print("    public final void " + list[i].idlName() + "( ");
                    org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, ref.referenceType(), file);
                    file.println(" _arg )");
                    file.println("    {");
                    file.println("        ((org.openorb.pss.connector.memory.PersistentRef)_" + list[i].idlName() + "_state ).update( _arg.get_pid() );");
                    file.println("    }");
                    file.println();
                }
            } else {
                file.print("    public final ");
                org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, list[i].stateType(), file);
                file.println(" " + list[i].idlName() + "()");
                file.println("    {");
                file.println("        return _" + list[i].idlName() + "_state;");
                file.println("    }");
                file.println();
                file.print("    public final ");
                org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, list[i].stateType(), file);
                file.println(" " + list[i].idlName() + "( org.omg.CosPersistentState.ForUpdate fu  )");
                file.println("    {");
                file.println("        return _" + list[i].idlName() + "_state;");
                file.println("    }");
                file.println();
                if (!list[i].isReadOnly()) {
                    file.print("    public final void " + list[i].idlName() + "( ");
                    org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, list[i].stateType(), file);
                    file.println(" _arg )");
                    file.println("    {");
                    file.println("        _" + list[i].idlName() + "_state = _arg;");
                    file.println("    }");
                    file.println();
                } else {
                    file.print("    final void " + list[i].idlName() + "( ");
                    org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, list[i].stateType(), file);
                    file.println(" _arg )");
                    file.println("    {");
                    file.println("        _" + list[i].idlName() + "_state = _arg;");
                    file.println("    }");
                    file.println();
                }
            }
            ++i;
        }
    }

    private void map_states_marshalling(psdlStorageType st, PrintWriter file) {
        psdlState[] states = this.mappable_states(st, true);
        this.map_states_marshalling_for(states, file);
    }

    private void map_states_marshalling_for(psdlState[] list, PrintWriter file) {
        int i = 0;
        while (i < list.length) {
            if (list[i].stateType().idlType() == 108) {
                org.openorb.pss.compiler.util.tools.marshal(this.m_pcp, list[i].stateType(), file, "output", list[i].idlName() + "( org.omg.CosPersistentState.YieldRef.YIELD_REF )", null, null);
            } else {
                org.openorb.pss.compiler.util.tools.marshal(this.m_pcp, list[i].stateType(), file, "output", list[i].idlName() + "()", null, null);
            }
            ++i;
        }
    }

    private void map_states_unmarshalling(psdlStorageType st, PrintWriter file) {
        psdlState[] states = this.mappable_states(st, true);
        this.map_states_unmarshalling_for(st, states, file);
    }

    private void map_states_unmarshalling_for(psdlStorageType st, psdlState[] list, PrintWriter file) {
        int i = 0;
        while (i < list.length) {
            org.openorb.pss.compiler.util.tools.unmarshal(this.m_pcp, list[i].stateType(), file, "input", "_" + list[i].idlName() + "_state", st, list[i], false);
            ++i;
        }
    }

    private void map_storagetype_ref(File into, psdlStorageType st) {
        PrintWriter file = tools.createNewFile((File)into, (String)(st.idlName() + "Ref"));
        this.map_header(file);
        tools.writePackageName((CompilerProperties)this.m_pcp, (PrintWriter)file, (idlObject)st);
        file.println();
        file.print("public class " + st.idlName() + "Ref");
        file.print(" implements ");
        psdlAbstractStorageType[] implem = st.implemented();
        int i = 0;
        while (i < implem.length) {
            file.print(org.openorb.pss.compiler.util.tools.javaName(this.m_pcp, implem[i]) + "Ref");
            file.print(", ");
            ++i;
        }
        file.println("org.openorb.pss.connector.memory.PersistentRef");
        file.println("{");
        file.println("    private org.openorb.pss.connector.PID _pid;");
        file.println();
        file.println("    private org.omg.CosPersistentState.StorageHomeBase _home_base;");
        file.println();
        file.println("    public " + st.idlName() + "Ref()");
        file.println("    {");
        file.println("    }");
        file.println();
        file.println("    public " + st.idlName() + "Ref( byte [] pid, org.omg.CosPersistentState.CatalogBase c )");
        file.println("    {");
        file.println("        _pid = org.openorb.pss.connector.memory.PIDFactory.pid_byte_to_pid( pid );");
        file.println("        _home_base = ((org.openorb.pss.connector.memory.MemoryCatalog)c).find_home_base( _pid );");
        file.println("    }");
        file.println();
        file.println("    public " + st.idlName() + "Ref( byte [] short_pid, org.omg.CosPersistentState.StorageHomeBase h )");
        file.println("    {");
        file.println("        _home_base = h;");
        file.println("        _pid = org.openorb.pss.connector.memory.PIDFactory.short_pid_to_pid( short_pid, ((org.openorb.pss.connector.memory.PersistentObjectHome)_home_base).getPID() );");
        file.println("    }");
        file.println();
        file.println("    public org.omg.CosPersistentState.StorageObject deref()");
        file.println("    {");
        file.println("        return ((org.openorb.pss.connector.memory.PersistentObjectHome)_home_base).deref( _pid );");
        file.println("    }");
        file.println();
        file.println("    public void destroy_object()");
        file.println("    {");
        file.println("        try");
        file.println("        {");
        file.println("            ((org.openorb.pss.connector.memory.PersistentObjectHome)_home_base).remove_storage_type( _pid );");
        file.println("        }");
        file.println("        catch ( org.openorb.pss.connector.memory.NotFoundException ex )");
        file.println("        { }");
        file.println("    }");
        file.println();
        file.println("    public boolean object_exists()");
        file.println("    {");
        file.println("        return ((org.openorb.pss.connector.memory.PersistentObjectHome)_home_base).is_stored( _pid );");
        file.println("    }");
        file.println("    public byte[] get_pid()");
        file.println("    {");
        file.println("        return _pid.value();");
        file.println("    }");
        file.println();
        file.println("    public byte[] get_short_pid()");
        file.println("    {");
        file.println("        return _pid.short_value();");
        file.println("    }");
        file.println();
        file.println("    public org.omg.CosPersistentState.StorageHomeBase get_storage_home()");
        file.println("    {");
        file.println("        return _home_base;");
        file.println("    }");
        file.println();
        file.println("    public void setPersistentLinks( org.omg.CosPersistentState.StorageHomeBase home_base,");
        file.println("                                    org.openorb.pss.connector.PID pid )");
        file.println("    {");
        file.println("        _home_base = home_base;");
        file.println("        _pid = pid;");
        file.println("    }");
        file.println();
        file.println("    public void update( byte [] pid )");
        file.println("    {");
        file.println("        _pid = org.openorb.pss.connector.memory.PIDFactory.pid_byte_to_pid( pid );");
        file.println("    }");
        file.println();
        file.println("}");
        file.close();
    }

    public void map_storagehome(File into, psdlStorageHome sh) {
        PrintWriter file = tools.createNewFile((File)into, (String)sh.idlName());
        psdlStorageType st = sh.homeFor();
        this.map_header(file);
        tools.writePackageName((CompilerProperties)this.m_pcp, (PrintWriter)file, (idlObject)sh);
        file.println();
        file.print("public");
        if (this.home_contains_local_op(sh)) {
            file.print(" abstract");
        }
        file.print(" class " + sh.idlName());
        if (sh.inheritance() != null) {
            file.print(" extends " + org.openorb.pss.compiler.util.tools.javaName(this.m_pcp, sh.inheritance()));
        } else {
            file.print(" extends org.omg.CORBA.LocalObject");
        }
        file.print(" implements ");
        psdlAbstractStorageHome[] implem = sh.implemented();
        int i = 0;
        while (i < implem.length) {
            file.print(org.openorb.pss.compiler.util.tools.javaName(this.m_pcp, implem[i]));
            file.print(", ");
            ++i;
        }
        file.println("org.openorb.pss.connector.memory.PersistentObjectHome");
        file.println("{");
        file.println("    private final java.util.ArrayList _incarnations = new java.util.ArrayList();");
        file.println();
        file.println("    private org.omg.CosPersistentState.CatalogBase _catalog;");
        file.println();
        file.println("    private org.openorb.pss.connector.PID _pid;");
        file.println();
        file.println("    // PSDL StorageHomeBase description");
        file.println("    public java.lang.Object find_by_short_pid( final byte[] short_pid )");
        file.println("        throws org.omg.CosPersistentState.NotFound");
        file.println("    {");
        file.println("        synchronized ( _incarnations )");
        file.println("        {");
        file.println("            final java.util.Iterator it = _incarnations.iterator();");
        file.println("            while ( it.hasNext() )");
        file.println("            {");
        file.println("                final org.openorb.pss.connector.memory.PersistentObject obj");
        file.println("                         = ( org.openorb.pss.connector.memory.PersistentObject ) it.next();");
        file.println("                if ( obj.getPID().is_same_short( short_pid ) )");
        file.println("                {");
        file.println("                    return obj;");
        file.println("                }");
        file.println("            }");
        file.println("            throw new org.omg.CosPersistentState.NotFound();");
        file.println("        }");
        file.println("    }");
        file.println();
        file.println("    public org.omg.CosPersistentState.CatalogBase get_catalog()");
        file.println("    {");
        file.println("        return _catalog;");
        file.println("    }");
        file.println();
        file.println("    // Create operations");
        file.print("    public " + st.idlName() + " _create( ");
        psdlState[] states = this.mappable_states(st, true);
        boolean first = true;
        int i2 = 0;
        while (i2 < states.length) {
            if (!states[i2].isRef()) {
                if (!first) {
                    file.print(", ");
                }
                org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, states[i2].stateType(), file);
                file.print(" " + states[i2].idlName());
                first = false;
            }
            ++i2;
        }
        file.println(" )");
        file.println("    {");
        file.println("        " + st.idlName() + " obj = ( " + st.idlName() + " ) ((org.openorb.pss.connector.memory.MemoryCatalogBase)_catalog).create_object( this, \"" + st.idlID() + "\" );");
        file.println("        register_type_incarnation( obj );");
        int i3 = 0;
        while (i3 < states.length) {
            if (!states[i3].isRef()) {
                file.println("        obj." + states[i3].idlName() + "(" + states[i3].idlName() + ");");
            }
            ++i3;
        }
        file.println("        return obj;");
        file.println("    }");
        file.println();
        file.print("    public " + st.idlName() + " _create( ");
        first = true;
        int i4 = 0;
        while (i4 < states.length) {
            if (states[i4].isRef()) {
                if (!first) {
                    file.print(", ");
                }
                org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, states[i4].stateType(), file);
                file.print(" " + states[i4].idlName());
                first = false;
            }
            ++i4;
        }
        file.println(" )");
        file.println("    {");
        file.println("        " + st.idlName() + " obj = ( " + st.idlName() + " ) ((org.openorb.pss.connector.memory.MemoryCatalogBase)_catalog).create_object( this, \"" + st.idlID() + "\" );");
        file.println("        register_type_incarnation( obj );");
        int i5 = 0;
        while (i5 < states.length) {
            if (states[i5].isRef()) {
                file.println("        obj." + states[i5].idlName() + "(" + states[i5].idlName() + ");");
            }
            ++i5;
        }
        file.println("        return obj;");
        file.println("    }");
        file.println();
        file.print("    public " + st.idlName() + "Ref _create( ");
        int i6 = 0;
        while (i6 < states.length) {
            if (!states[i6].isRef()) {
                org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, states[i6].stateType(), file);
                file.print(" " + states[i6].idlName());
                file.print(", ");
            }
            ++i6;
        }
        file.println("org.omg.CosPersistentState.YieldRef yr )");
        file.println("    {");
        file.print("        " + st.idlName() + " obj = _create(");
        first = true;
        int i7 = 0;
        while (i7 < states.length) {
            if (!states[i7].isRef()) {
                if (!first) {
                    file.print(", ");
                }
                file.print(states[i7].idlName());
                first = false;
            }
            ++i7;
        }
        file.println(");");
        file.println("        return new " + st.idlName() + "Ref( obj.get_pid(), _catalog );");
        file.println("    }");
        file.println();
        file.print("    public " + st.idlName() + "Ref _create( ");
        int i8 = 0;
        while (i8 < states.length) {
            if (states[i8].isRef()) {
                org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, states[i8].stateType(), file);
                file.print(" " + states[i8].idlName());
                file.print(", ");
            }
            ++i8;
        }
        file.println("org.omg.CosPersistentState.YieldRef yr )");
        file.println("    {");
        file.print("        " + st.idlName() + " obj = _create(");
        first = true;
        int i9 = 0;
        while (i9 < states.length) {
            if (states[i9].isRef()) {
                if (!first) {
                    file.print(", ");
                }
                file.print(states[i9].idlName());
                first = false;
            }
            ++i9;
        }
        file.println(");");
        file.println("        return new " + st.idlName() + "Ref( obj.get_pid(), _catalog );");
        file.println("    }");
        file.println();
        this.map_factories(sh, file);
        this.map_keys(sh, file);
        file.println("    // PersistentObjectHome implementation");
        file.println("    public java.lang.Object [] get_incarnations()");
        file.println("    {");
        file.println("        return _incarnations.toArray();");
        file.println("    }");
        file.println();
        file.println("    public void setPersistentLinks( org.omg.CosPersistentState.CatalogBase catalog, org.openorb.pss.connector.PID pid )");
        file.println("    {");
        file.println("        _catalog = catalog;");
        file.println("        _pid = pid;");
        file.println("    }");
        file.println();
        file.println("    public org.omg.CosPersistentState.StorageObjectRef create_reference( byte [] pid )");
        file.println("    {");
        file.println("        return new " + st.idlName() + "Ref( pid, _catalog );");
        file.println("    }");
        file.println();
        file.println("    public org.openorb.pss.connector.PID getPID()");
        file.println("    {");
        file.println("        return _pid;");
        file.println("    }");
        file.println();
        file.println("    public void remove_storage_type( org.openorb.pss.connector.PID pid )");
        file.println("        throws org.openorb.pss.connector.memory.NotFoundException");
        file.println("    {");
        file.println("        unregister_type_incarnation( pid );");
        file.println("        ((org.openorb.pss.connector.memory.MemoryCatalogBase)_catalog).delete( _pid, pid );");
        file.println("    }");
        file.println();
        file.println("    public boolean is_stored( org.openorb.pss.connector.PID pid )");
        file.println("    {");
        file.println("        return ((org.openorb.pss.connector.memory.MemoryCatalogBase)_catalog).stored( _pid, pid );");
        file.println("    }");
        file.println();
        file.println("    public org.omg.CosPersistentState.StorageObject deref( org.openorb.pss.connector.PID pid )");
        file.println("    {");
        file.println("        try");
        file.println("        {");
        file.println("            return ( org.omg.CosPersistentState.StorageObject ) find_by_short_pid( pid.short_value() );");
        file.println("        }");
        file.println("        catch ( org.omg.CosPersistentState.NotFound ex )");
        file.println("        { }");
        file.println("        return null;");
        file.println("    }");
        file.println();
        file.println("    private void register_type_incarnation( final java.lang.Object type )");
        file.println("    {");
        file.println("        synchronized ( _incarnations )");
        file.println("        {");
        file.println("            _incarnations.add( type );");
        file.println("        }");
        file.println("    }");
        file.println();
        file.println("    private void unregister_type_incarnation( org.openorb.pss.connector.PID pid )");
        file.println("    {");
        file.println("        synchronized ( _incarnations )");
        file.println("        {");
        file.println("            final java.util.Iterator it = _incarnations.iterator();");
        file.println("            while ( it.hasNext() )");
        file.println("            {");
        file.println("                final org.openorb.pss.connector.memory.PersistentObject obj");
        file.println("                         = ( org.openorb.pss.connector.memory.PersistentObject ) it.next();");
        file.println("                if ( obj.getPID().is_same( pid ) )");
        file.println("                {");
        file.println("                    it.remove();");
        file.println("                }");
        file.println("            }");
        file.println("            _incarnations.trimToSize();");
        file.println("        }");
        file.println("    }");
        file.println();
        file.println("}");
        file.close();
    }

    private boolean home_contains_local_op(psdlStorageHome sh) {
        if (sh.containsObject(105)) {
            return true;
        }
        psdlStorageHome base = sh.inheritance();
        if (base != null && this.home_contains_local_op(base)) {
            return true;
        }
        psdlAbstractStorageHome[] ash = sh.implemented();
        int i = 0;
        while (i < ash.length) {
            if (this.home_abstract_contains_local_op(ash[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean home_abstract_contains_local_op(psdlAbstractStorageHome ash) {
        psdlAbstractStorageHome[] base = ash.inheritance();
        int i = 0;
        while (i < base.length) {
            if (this.home_abstract_contains_local_op(base[i])) {
                return true;
            }
            ++i;
        }
        return ash.containsObject(105);
    }

    private boolean isNullEnable(idlObject obj) {
        switch (obj.idlType()) {
            case 12: {
                return this.isNullEnable(((idlIdentifier)obj).original());
            }
            case 13: {
                return this.isNullEnable(((idlTypeDef)obj).original());
            }
            case 10: 
            case 22: 
            case 23: 
            case 108: {
                return true;
            }
        }
        return false;
    }

    private void map_factories(psdlStorageHome sh, PrintWriter file) {
        psdlFactory[] factories = this.mappable_factories(sh);
        Enumeration enumeration = null;
        psdlState state = null;
        if (factories.length != 0) {
            file.println("    // Factories");
        }
        int i = 0;
        while (i < factories.length) {
            file.print("    public ");
            org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, ((psdlAbstractStorageHome)factories[i].idlDefinedIn()).managed(), file);
            file.print(" " + factories[i].idlName() + "( ");
            boolean first = true;
            enumeration = factories[i].content();
            while (enumeration.hasMoreElements()) {
                state = (psdlState)enumeration.nextElement();
                if (!first) {
                    file.print(", ");
                }
                org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, state.stateType(), file);
                file.print(" " + state.idlName());
                first = false;
            }
            file.println(" )");
            file.println("    {");
            file.print("        ");
            org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, sh.managed(), file);
            file.print(" obj = ( ");
            org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, sh.managed(), file);
            file.println(" ) ((org.openorb.pss.connector.memory.MemoryCatalogBase)_catalog).create_object( this, \"" + sh.managed().idlID() + "\" );");
            file.println("        register_type_incarnation( obj );");
            enumeration = factories[i].content();
            while (enumeration.hasMoreElements()) {
                state = (psdlState)enumeration.nextElement();
                file.println("        obj." + state.idlName() + "( " + state.idlName() + " );");
            }
            file.println("        return obj;");
            file.println("    }");
            file.println();
            ++i;
        }
    }

    private psdlFactory[] mappable_factories(psdlStorageHome sh) {
        psdlFactory[] factories = null;
        Vector v = new Vector();
        this.get_factories(sh, v);
        factories = new psdlFactory[v.size()];
        int i = 0;
        while (i < v.size()) {
            factories[i] = (psdlFactory)v.elementAt(i);
            ++i;
        }
        return factories;
    }

    private void get_factories(psdlStorageHome sh, Vector v) {
        psdlFactory factory = null;
        psdlStorageHome base = sh.inheritance();
        if (base != null) {
            this.get_factories(base, v);
        }
        psdlAbstractStorageHome[] ash = sh.implemented();
        int i = 0;
        while (i < ash.length) {
            this.get_factories_with_inheritance_for(ash[i], v);
            ++i;
        }
        Enumeration list = sh.filter(103);
        while (list.hasMoreElements()) {
            factory = (psdlFactory)list.nextElement();
            if (v.contains(factory)) continue;
            v.addElement(factory);
        }
    }

    private void get_factories_with_inheritance_for(psdlAbstractStorageHome ash, Vector v) {
        psdlAbstractStorageHome[] inheritance = ash.inheritance();
        psdlFactory factory = null;
        int i = 0;
        while (i < inheritance.length) {
            this.get_factories_with_inheritance_for(inheritance[i], v);
            ++i;
        }
        Enumeration list = ash.filter(103);
        while (list.hasMoreElements()) {
            factory = (psdlFactory)list.nextElement();
            if (v.contains(factory)) continue;
            v.addElement(factory);
        }
    }

    private idlObject finalType(idlObject obj) {
        switch (obj.idlType()) {
            case 12: {
                return this.finalType(((idlIdentifier)obj).original());
            }
            case 13: {
                return this.finalType(((idlTypeDef)obj).original());
            }
        }
        return obj;
    }

    private void map_keys(psdlStorageHome sh, PrintWriter file) {
        psdlKey[] keys = this.mappable_keys(sh);
        Enumeration enumeration = null;
        psdlState state = null;
        if (keys.length != 0) {
            file.println("    // Keys");
        }
        int i = 0;
        while (i < keys.length) {
            file.print("    public ");
            org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, ((psdlAbstractStorageHome)keys[i].idlDefinedIn()).managed(), file);
            file.print(" find_by_" + keys[i].idlName() + "( ");
            enumeration = keys[i].content();
            while (enumeration.hasMoreElements()) {
                state = (psdlState)enumeration.nextElement();
                org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, state.stateType(), file);
                file.print(" " + state.idlName());
                if (!enumeration.hasMoreElements()) continue;
                file.print(", ");
            }
            file.println(" )");
            file.println("        throws org.omg.CosPersistentState.NotFound");
            file.println("    {");
            file.println("        synchronized ( _incarnations )");
            file.println("        {");
            file.println("            final java.util.Iterator it = _incarnations.iterator();");
            file.println("            while ( it.hasNext() )");
            file.println("            {");
            file.print("                ");
            org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, ((psdlAbstractStorageHome)keys[i].idlDefinedIn()).managed(), file);
            file.print(" obj = ( ");
            org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, ((psdlAbstractStorageHome)keys[i].idlDefinedIn()).managed(), file);
            file.println(" ) it.next();");
            enumeration = keys[i].content();
            while (enumeration.hasMoreElements()) {
                state = (psdlState)enumeration.nextElement();
                file.print("                ");
                org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, state.stateType(), file);
                file.println(" _tmp_" + state.idlName() + " = obj." + state.idlName() + "();");
            }
            this.map_conditions(keys[i], file);
            file.println("                    return obj; ");
            file.println("            }");
            file.println("        }");
            file.println("        throw new org.omg.CosPersistentState.NotFound();");
            file.println("    }");
            file.println();
            file.print("    public ");
            org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, ((psdlAbstractStorageHome)keys[i].idlDefinedIn()).managed(), file);
            file.print("Ref find_ref_by_" + keys[i].idlName() + "( ");
            enumeration = keys[i].content();
            while (enumeration.hasMoreElements()) {
                state = (psdlState)enumeration.nextElement();
                org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, state.stateType(), file);
                file.print(" " + state.idlName());
                if (!enumeration.hasMoreElements()) continue;
                file.print(", ");
            }
            file.println(" )");
            file.println("    {");
            file.println("        synchronized ( _incarnations )");
            file.println("        {");
            file.println("            final java.util.Iterator it = _incarnations.iterator();");
            file.println("            while ( it.hasNext() )");
            file.println("            {");
            file.print("                ");
            org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, ((psdlAbstractStorageHome)keys[i].idlDefinedIn()).managed(), file);
            file.print(" obj = ( ");
            org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, ((psdlAbstractStorageHome)keys[i].idlDefinedIn()).managed(), file);
            file.println(" ) it.next();");
            enumeration = keys[i].content();
            while (enumeration.hasMoreElements()) {
                state = (psdlState)enumeration.nextElement();
                file.print("                ");
                org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, state.stateType(), file);
                file.println(" _tmp_" + state.idlName() + " = obj." + state.idlName() + "();");
            }
            psdlStorageType st = sh.homeFor();
            this.map_conditions(keys[i], file);
            file.print("                    return ( ");
            org.openorb.pss.compiler.util.tools.javaType(this.m_pcp, ((psdlAbstractStorageHome)keys[i].idlDefinedIn()).managed(), file);
            file.print("Ref ) new ");
            file.print(st.idlName());
            file.println("Ref ( obj.get_short_pid(), this );");
            file.println("            }");
            file.println("        }");
            file.println("        return null;");
            file.println("    }");
            file.println();
            ++i;
        }
    }

    private psdlKey[] mappable_keys(psdlStorageHome sh) {
        psdlKey[] keys = null;
        Vector v = new Vector();
        this.get_keys(sh, v);
        keys = new psdlKey[v.size()];
        int i = 0;
        while (i < v.size()) {
            keys[i] = (psdlKey)v.elementAt(i);
            ++i;
        }
        return keys;
    }

    private void get_keys(psdlStorageHome sh, Vector v) {
        psdlKey key = null;
        psdlStorageHome base = sh.inheritance();
        if (base != null) {
            this.get_keys(base, v);
        }
        psdlAbstractStorageHome[] ash = sh.implemented();
        int i = 0;
        while (i < ash.length) {
            this.get_keys_with_inheritance_for(ash[i], v);
            ++i;
        }
        Enumeration list = sh.filter(104);
        while (list.hasMoreElements()) {
            key = (psdlKey)list.nextElement();
            if (v.contains(key)) continue;
            v.addElement(key);
        }
    }

    private void get_keys_with_inheritance_for(psdlAbstractStorageHome ash, Vector v) {
        psdlAbstractStorageHome[] inheritance = ash.inheritance();
        psdlKey key = null;
        int i = 0;
        while (i < inheritance.length) {
            this.get_keys_with_inheritance_for(inheritance[i], v);
            ++i;
        }
        Enumeration list = ash.filter(104);
        while (list.hasMoreElements()) {
            key = (psdlKey)list.nextElement();
            if (v.contains(key)) continue;
            v.addElement(key);
        }
    }

    private void map_conditions(psdlKey key, PrintWriter file) {
        psdlState state = null;
        file.print("            if ( ");
        Enumeration enumeration = key.content();
        while (enumeration.hasMoreElements()) {
            state = (psdlState)enumeration.nextElement();
            file.print(" ( " + this.map_condition(state.stateType(), "_tmp_" + state.idlName(), state.idlName()) + " ) ");
            if (!enumeration.hasMoreElements()) continue;
            file.print("&& ");
        }
        file.println(" )");
    }

    private String map_condition(idlObject item, String tmp_name, String state_name) {
        String condition = "";
        Enumeration enumeration = null;
        switch (item.idlType()) {
            case 2: {
                return tmp_name + ".value() == " + state_name + ".value()";
            }
            case 11: {
                return "org.openorb.pss.util.measure.compare(" + tmp_name + "," + state_name + ")";
            }
            case 3: {
                idlStruct st = (idlStruct)item;
                enumeration = st.members();
                while (enumeration.hasMoreElements()) {
                    idlStructMember member = (idlStructMember)enumeration.nextElement();
                    condition = condition + "(" + this.map_condition(member.internal(), tmp_name + "." + member.idlName(), state_name + "." + member.idlName()) + " )";
                    if (!enumeration.hasMoreElements()) continue;
                    condition = condition + " && ";
                }
                return condition;
            }
            case 23: {
                idlValue val = (idlValue)item;
                enumeration = val.filter(24);
                boolean first = true;
                while (enumeration.hasMoreElements()) {
                    idlState state = (idlState)enumeration.nextElement();
                    if (!state.isPublic()) continue;
                    if (!first) {
                        condition = condition + " && ";
                    }
                    first = false;
                    condition = condition + "(" + this.map_condition(state.stateType(), tmp_name + "." + state.idlName(), state_name + "." + state.idlName()) + " )";
                }
                return condition;
            }
            case 10: {
                return state_name + " == " + tmp_name;
            }
            case 7: 
            case 8: {
                return state_name + ".equals( " + tmp_name + " )";
            }
            case 12: {
                return this.map_condition(((idlIdentifier)item).original(), tmp_name, state_name);
            }
            case 13: {
                return this.map_condition(((idlTypeDef)item).original(), tmp_name, state_name);
            }
        }
        return null;
    }

    public void map_catalog(File into, psdlCatalog cat) {
        this.map_catalog_for_session(into, cat);
        this.map_catalog_for_transactional_session(into, cat);
        this.map_catalog_for_session_pool(into, cat);
    }

    public void map_catalog_for_session(File into, psdlCatalog cat) {
        PrintWriter file = tools.createNewFile((File)into, (String)(cat.idlName() + "SessionBase"));
        this.map_header(file);
        tools.writePackageName((CompilerProperties)this.m_pcp, (PrintWriter)file, (idlObject)cat);
        file.println();
        file.println("public abstract class " + cat.idlName() + "SessionBase extends org.openorb.pss.connector.memory.MemorySession implements " + cat.idlName());
        file.println("{");
        file.println("    public " + cat.idlName() + "SessionBase()");
        file.println("    {}");
        file.println();
        file.println("}");
        file.close();
    }

    public void map_catalog_for_transactional_session(File into, psdlCatalog cat) {
        PrintWriter file = tools.createNewFile((File)into, (String)(cat.idlName() + "TransactionalSessionBase"));
        this.map_header(file);
        tools.writePackageName((CompilerProperties)this.m_pcp, (PrintWriter)file, (idlObject)cat);
        file.println();
        file.println("public abstract class " + cat.idlName() + "TransactionalSessionBase extends org.openorb.pss.connector.memory.TransactionalMemorySession implements " + cat.idlName());
        file.println("{");
        file.println();
        file.println("    public " + cat.idlName() + "TransactionalSessionBase()");
        file.println("    {}");
        file.println();
        file.println("}");
        file.close();
    }

    public void map_catalog_for_session_pool(File into, psdlCatalog cat) {
        PrintWriter file = tools.createNewFile((File)into, (String)(cat.idlName() + "SessionPoolBase"));
        this.map_header(file);
        tools.writePackageName((CompilerProperties)this.m_pcp, (PrintWriter)file, (idlObject)cat);
        file.println();
        file.println("public abstract class " + cat.idlName() + "SessionPoolBase extends org.openorb.pss.connector.memory.MemorySessionPool implements " + cat.idlName());
        file.println("{");
        file.println();
        file.println("    public " + cat.idlName() + "SessionPoolBase()");
        file.println("    {}");
        file.println();
        file.println("}");
        file.close();
    }
}

