/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.examples.database.basic.first;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.openorb.pss.examples.database.basic.first.Form;
import org.openorb.pss.examples.database.basic.first.FormHelper;

public class Client {
    private static Form s_form = null;

    public static void main(String[] args) {
        ORB orb = ORB.init((String[])args, null);
        Object obj = null;
        try {
            FileInputStream file = new FileInputStream("ObjectId");
            InputStreamReader input = new InputStreamReader(file);
            BufferedReader reader = new BufferedReader(input);
            String stringTarget = reader.readLine();
            obj = orb.string_to_object(stringTarget);
        }
        catch (IOException ex) {
            System.out.println("File error");
            System.exit(0);
        }
        s_form = FormHelper.narrow(obj);
        int option = 0;
        boolean stop = false;
        while (!stop) {
            option = Client.menu();
            switch (option) {
                case 0: {
                    stop = true;
                    break;
                }
                case 1: {
                    Client.createPerson();
                    break;
                }
                case 2: {
                    Client.removePerson();
                    break;
                }
                case 3: {
                    Client.displayPerson();
                }
            }
        }
    }

    public static void createPerson() {
        try {
            System.out.println("[ Create a new person ]");
            System.out.print("Name : ");
            String name = Client.input();
            System.out.print("Address : ");
            String address = Client.input();
            System.out.print("Age : ");
            String age = Client.input();
            int ageValue = new Integer(age);
            System.out.println("");
            s_form.createPerson(name, address, ageValue);
        }
        catch (SystemException ex) {
            System.out.println("A CORBA System exception has been intercepted");
            ex.printStackTrace();
        }
    }

    public static void removePerson() {
        try {
            System.out.println("[ Remove a person ]");
            System.out.print("Name : ");
            String name = Client.input();
            System.out.println("");
            s_form.removePerson(name);
        }
        catch (SystemException ex) {
            System.out.println("A CORBA System exception has been intercepted");
            ex.printStackTrace();
        }
    }

    public static void displayPerson() {
        try {
            System.out.println("[ Display a person ]");
            System.out.print("Name : ");
            String name = Client.input();
            System.out.println("");
            s_form.showPerson(name);
        }
        catch (SystemException ex) {
            System.out.println("A CORBA System exception has been intercepted");
            ex.printStackTrace();
        }
    }

    public static String input() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            return reader.readLine();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int menu() {
        System.out.println("Select a choice : ");
        System.out.println("\t0. Quit");
        System.out.println("\t1. Create a new person");
        System.out.println("\t2. Remove a person");
        System.out.println("\t3. Display all person's data");
        String choice = Client.input();
        return new Integer(choice);
    }
}

