/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.examples.database.basic.third;

import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosPersistentState.ForUpdate;
import org.omg.CosPersistentState.StorageHomeBase;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.database.DatabaseCatalogBase;
import org.openorb.pss.connector.database.DatabaseUtil;
import org.openorb.pss.connector.database.NotFoundException;
import org.openorb.pss.connector.database.PersistentObject;
import org.openorb.pss.connector.database.PersistentObjectHome;
import org.openorb.pss.examples.database.basic.third.Car;
import org.openorb.pss.examples.database.basic.third.CarBase;
import org.openorb.pss.examples.database.basic.third.Person;

public abstract class PersonBase
implements Person,
PersistentObject {
    protected String _name_state;
    protected Car _car_state;
    private PID _pid;
    private StorageHomeBase _home_base;
    private PersistentObject _container = null;

    public void embeddedBuilder() {
        this._car_state = (CarBase)((DatabaseCatalogBase)this._home_base.get_catalog()).create_embedded_object(this._home_base, "PSDL:org/openorb/pss/examples/database/basic/third/CarBase:1.0");
        ((PersistentObject)this._car_state).markAsEmbedded((PersistentObject)this);
    }

    public void destroy_object() {
        if (this._container != null) {
            return;
        }
        try {
            ((PersistentObjectHome)this._home_base).remove_storage_type(this._pid);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public boolean object_exists() {
        if (this._container != null) {
            return true;
        }
        return ((PersistentObjectHome)this._home_base).is_stored(this._pid);
    }

    public byte[] get_pid() {
        if (this._container != null) {
            throw new PERSIST_STORE(10, CompletionStatus.COMPLETED_NO);
        }
        return this._pid.value();
    }

    public byte[] get_short_pid() {
        if (this._container != null) {
            throw new PERSIST_STORE(10, CompletionStatus.COMPLETED_NO);
        }
        return this._pid.short_value();
    }

    public StorageHomeBase get_storage_home() {
        return this._home_base;
    }

    public final String name() {
        return this._name_state;
    }

    public final void name(String _arg) {
        this._name_state = _arg;
        this.flushIncarnation();
    }

    public final Car car() {
        return this._car_state;
    }

    public final Car car(ForUpdate fu) {
        this.refreshIncarnation();
        return this._car_state;
    }

    public final void car(Car _arg) {
        this._car_state = _arg;
        this.flushIncarnation();
    }

    public PID getPID() {
        return this._pid;
    }

    public void setPersistentLinks(PID pid, StorageHomeBase home_base) {
        this._pid = pid;
        this._home_base = home_base;
    }

    public void write(OutputStream[] output) {
        output[0].write_string(this.name());
        OutputStream[] output_car = DatabaseUtil.outputArray((int)2);
        ((PersistentObject)this.car()).write(output_car);
        DatabaseUtil.flatOutput((OutputStream)output[1], (OutputStream[])output_car);
    }

    public void read(InputStream[] input) {
        this._name_state = input[0].read_string();
        InputStream[] input__car_state = DatabaseUtil.multipleInput((InputStream)input[1], (int)2);
        ((PersistentObject)this._car_state).read(input__car_state);
    }

    public void markAsEmbedded(PersistentObject container) {
        this._container = container;
    }

    public void refreshIncarnation() {
        if (this._container != null) {
            this._container.refreshIncarnation();
            return;
        }
        ((PersistentObjectHome)this._home_base).refresh((PersistentObject)this);
    }

    public boolean checkForFlush() {
        boolean _res_car;
        if (this._name_state == null) {
            return false;
        }
        if (this._car_state == null) {
            return false;
        }
        return this._car_state == null || (_res_car = ((PersistentObject)this._car_state).checkForFlush());
    }

    public void flushIncarnation() {
        if (this._container != null) {
            this._container.flushIncarnation();
            return;
        }
        if (!this.checkForFlush()) {
            return;
        }
        ((PersistentObjectHome)this._home_base).flush((PersistentObject)this);
    }

    public abstract void print();
}

