/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.Impl;

import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.ControlHelper;
import org.omg.CosTransactions.CoordinatorHelper;
import org.omg.CosTransactions.CoordinatorPOA;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.RecoveryCoordinatorHelper;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionAwareResourceHelper;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.Unavailable;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.openorb.ots.Admin.Manager;
import org.openorb.ots.Impl.Control;
import org.openorb.ots.Impl.SubTransListener;
import org.openorb.ots.Impl.XID;
import org.openorb.ots.log.Writer;

public class Coordinator
extends CoordinatorPOA {
    private Status m_status;
    private XID m_xid;
    private PropagationContext m_propagation_ctx;
    private Vector m_resources;
    private Vector m_synchronizations;
    private Control m_control;
    private POA m_poa;
    private POA m_recovery_poa;
    private Vector m_subTransListeners;
    private Vector m_sub_to_remove;
    private int m_time_out;
    private Manager m_manager;
    private Logger m_logger;

    public XID getXID() {
        return this.m_xid;
    }

    public Coordinator(Manager manager, XID xid, int time_out, POA poa, POA recovery_poa, Logger logger) {
        this.m_manager = manager;
        this.m_logger = logger;
        this.m_resources = new Vector();
        this.m_synchronizations = new Vector();
        this.m_subTransListeners = new Vector();
        this.m_sub_to_remove = new Vector();
        this.m_status = Status.StatusActive;
        this.m_propagation_ctx = this.create_propagation_context(xid, time_out, new TransIdentity[0]);
        this.m_xid = xid;
        this.m_poa = poa;
        this.m_time_out = time_out;
        this.m_recovery_poa = recovery_poa;
    }

    protected Coordinator(Manager manager, XID xid, int time_out, POA poa, TransIdentity[] parents, Logger logger) {
        this.m_manager = manager;
        this.m_logger = logger;
        this.m_resources = new Vector();
        this.m_synchronizations = new Vector();
        this.m_subTransListeners = new Vector();
        this.m_sub_to_remove = new Vector();
        this.m_status = Status.StatusActive;
        this.m_propagation_ctx = this.create_propagation_context(xid, time_out, parents);
        this.m_xid = xid;
        this.m_poa = poa;
        this.m_time_out = time_out;
    }

    public Status get_status() {
        return this.m_status;
    }

    public Status get_parent_status() {
        return this.m_status;
    }

    public Status get_top_level_status() {
        return this.m_status;
    }

    public boolean is_same_transaction(org.omg.CosTransactions.Coordinator tc) {
        return this.m_xid.hash_id() == tc.hash_transaction();
    }

    public boolean is_related_transaction(org.omg.CosTransactions.Coordinator tc) {
        return this.is_same_transaction(tc);
    }

    public boolean is_ancestor_transaction(org.omg.CosTransactions.Coordinator tc) {
        return this.is_same_transaction(tc);
    }

    public boolean is_descendant_transaction(org.omg.CosTransactions.Coordinator tc) {
        return tc.is_ancestor_transaction(this._this());
    }

    public boolean is_top_level_transaction() {
        return true;
    }

    public int hash_transaction() {
        return this.m_xid.hash_id();
    }

    public int hash_top_level_tran() {
        return this.hash_transaction();
    }

    public RecoveryCoordinator register_resource(Resource r) throws Inactive {
        switch (this.m_status.value()) {
            case 0: {
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                throw new TRANSACTION_ROLLEDBACK();
            }
            default: {
                throw new Inactive();
            }
        }
        this.m_resources.addElement(r);
        try {
            Object recovery_ref = this.m_recovery_poa.create_reference_with_id(this.m_xid.toString().getBytes(), "IDL:omg.org/CosTransactions/RecoveryCoordinator:1.0");
            RecoveryCoordinator recovery = RecoveryCoordinatorHelper.narrow(recovery_ref);
            Writer.getOut().register_resource(this.m_xid, r);
            return recovery;
        }
        catch (Exception ex) {
            this.getLogger().error("Cannot register resource: " + ex.toString(), (Throwable)ex);
            return null;
        }
    }

    public void register_synchronization(Synchronization sync) throws Inactive, SynchronizationUnavailable {
        switch (this.m_status.value()) {
            case 0: {
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                throw new TRANSACTION_ROLLEDBACK();
            }
            default: {
                throw new Inactive();
            }
        }
        this.m_synchronizations.addElement(sync);
    }

    public void register_subtran_aware(SubtransactionAwareResource r) throws Inactive, NotSubtransaction {
        throw new NotSubtransaction();
    }

    public void rollback_only() throws Inactive {
        switch (this.m_status.value()) {
            case 0: {
                this.m_status = Status.StatusMarkedRollback;
                Writer.getOut().rollback_only(this.m_xid);
                break;
            }
            default: {
                throw new Inactive();
            }
        }
    }

    public String get_transaction_name() {
        String transaction_name = "[ TOP OpenORB : " + this.m_xid.get_gtrid() + " / " + this.m_xid.get_bqual() + "]";
        return transaction_name;
    }

    public org.omg.CosTransactions.Control create_subtransaction() throws SubtransactionsUnavailable, Inactive {
        switch (this.m_status.value()) {
            case 1: 
            case 6: {
                throw new Inactive();
            }
        }
        TransIdentity[] parents = new TransIdentity[]{this.m_propagation_ctx.current};
        Control ctrl = new Control(this.m_time_out, this.m_manager, this.m_xid, this.m_poa, parents, this.getLogger());
        try {
            byte[] id = this.m_poa.activate_object((Servant)ctrl);
            ctrl.update();
            org.omg.CosTransactions.Control control = ControlHelper.narrow(this.m_poa.id_to_reference(id));
            SubTransListener subtran_listener = new SubTransListener(this, ctrl, this.m_poa);
            this.addSubTransListener(subtran_listener);
            id = this.m_poa.activate_object((Servant)subtran_listener);
            SubtransactionAwareResource subres = SubtransactionAwareResourceHelper.narrow(this.m_poa.id_to_reference(id));
            control.get_coordinator().register_subtran_aware(subres);
            return control;
        }
        catch (Exception ex) {
            this.getLogger().error("Cannot create subtransaction: " + ex.toString(), (Throwable)ex);
            return null;
        }
    }

    public PropagationContext get_txcontext() throws Unavailable {
        if (this.m_propagation_ctx == null) {
            throw new Unavailable();
        }
        return this.m_propagation_ctx;
    }

    protected Manager getManager() {
        return this.m_manager;
    }

    public void setTerminator(Terminator terminator) {
        this.m_propagation_ctx.current.term = terminator;
        try {
            this.m_propagation_ctx.current.coord = CoordinatorHelper.narrow(this.m_poa.id_to_reference(this.m_poa.servant_to_id((Servant)this)));
        }
        catch (Exception ex) {
            this.getLogger().error("Unable to set the coordinator reference", (Throwable)ex);
        }
    }

    public void synchronize() {
        Synchronization sync = null;
        int i = 0;
        while (i < this.m_synchronizations.size()) {
            sync = (Synchronization)this.m_synchronizations.elementAt(i);
            sync.before_completion();
            ++i;
        }
    }

    public void desynchronize() {
        Synchronization sync = null;
        int i = 0;
        while (i < this.m_synchronizations.size()) {
            sync = (Synchronization)this.m_synchronizations.elementAt(i);
            sync.after_completion(this.m_status);
            ++i;
        }
    }

    public Resource[] resources() {
        Resource[] r = new Resource[this.m_resources.size()];
        int i = 0;
        while (i < this.m_resources.size()) {
            r[i] = (Resource)this.m_resources.elementAt(i);
            ++i;
        }
        return r;
    }

    public SubtransactionAwareResource[] subtran_resources() {
        throw new INTERNAL();
    }

    public void commit_sub_transactions() {
        SubTransListener listener = null;
        int i = 0;
        while (i < this.m_subTransListeners.size()) {
            listener = (SubTransListener)this.m_subTransListeners.elementAt(i);
            listener.commit_pending();
            ++i;
        }
    }

    public void rollback_sub_transactions() {
        SubTransListener listener = null;
        int i = 0;
        while (i < this.m_subTransListeners.size()) {
            listener = (SubTransListener)this.m_subTransListeners.elementAt(i);
            listener.rollback_pending();
            ++i;
        }
    }

    public void remove_subtran_listener(SubTransListener listener) {
        SubTransListener l = null;
        int i = 0;
        while (i < this.m_subTransListeners.size()) {
            l = (SubTransListener)this.m_subTransListeners.elementAt(i);
            if (listener.equals(l)) {
                this.m_subTransListeners.removeElementAt(i);
                this.m_sub_to_remove.addElement(l);
                return;
            }
            ++i;
        }
    }

    public void setStatus(Status status) {
        this.m_status = status;
    }

    public void updatePropagationContext(Control ctrl) {
        this.m_control = ctrl;
    }

    private PropagationContext create_propagation_context(XID xid, int time_out, TransIdentity[] parents) {
        PropagationContext pctx = new PropagationContext();
        pctx.current = new TransIdentity();
        pctx.current.coord = null;
        pctx.current.term = null;
        pctx.current.otid = xid.otid();
        pctx.timeout = time_out;
        pctx.parents = parents;
        pctx.implementation_specific_data = ORB.init().create_any();
        return pctx;
    }

    public void removeItself() {
        SubTransListener l = null;
        int i = 0;
        while (i < this.m_sub_to_remove.size()) {
            l = (SubTransListener)this.m_sub_to_remove.elementAt(i);
            l.remove();
            ++i;
        }
        try {
            this.m_poa.deactivate_object(this.m_poa.servant_to_id((Servant)this));
            this.m_control.removeItself();
        }
        catch (ServantNotActive ex) {
        }
        catch (ObjectNotActive ex) {
        }
        catch (WrongPolicy ex) {
            // empty catch block
        }
    }

    protected final int getTimeOut() {
        return this.m_time_out;
    }

    protected final void addSubTransListener(SubTransListener listener) {
        this.m_subTransListeners.add(listener);
    }

    protected final POA getPoa() {
        return this.m_poa;
    }

    protected final PropagationContext getPropagationCtx() {
        return this.m_propagation_ctx;
    }

    protected void addResource(SubtransactionAwareResource r) {
        this.m_resources.addElement(r);
    }

    protected final Logger getLogger() {
        return this.m_logger;
    }
}

