/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.Impl;

import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Vote;
import org.openorb.ots.Impl.XID;
import org.openorb.ots.log.LogMonitor;
import org.openorb.ots.log.Writer;

public class RecoveryManager {
    private LogMonitor m_monitor;
    private Logger m_logger;

    public RecoveryManager(ORB orb, Logger logger) {
        this.m_monitor = new LogMonitor(orb, logger);
        this.m_logger = logger;
    }

    public void recover_transactions() {
        this.getLogger().debug("Begin transaction recovery");
        XID[] xids = this.m_monitor.uncompleted_transactions();
        int i = 0;
        while (i < xids.length) {
            this.recover_this_transaction(xids[i]);
            ++i;
        }
        Writer.getOut().recovery();
        Writer.getOut().recovery_completed();
    }

    private void recover_this_transaction(XID xid) {
        this.getLogger().debug("Recover transaction : " + xid.toString());
        Status status = this.m_monitor.transaction_status(xid);
        switch (status.value()) {
            case 0: {
                this.getLogger().debug("transaction not active");
                Resource[] resources = this.m_monitor.registered_resources(xid);
                this.rollback_resources(xid, resources);
                Writer.getOut().rollback_end(xid, Status.StatusRolledBack);
                Writer.getOut().completed(xid);
                break;
            }
            case 7: {
                this.getLogger().debug("transaction is preparing");
                Resource[] prepared_resources = this.m_monitor.prepared_resources(xid);
                this.rollback_resources(xid, prepared_resources);
                Resource[] free_resources = this.m_monitor.free_resources(xid);
                this.rollback_resources(xid, free_resources);
                Writer.getOut().rollback_end(xid, Status.StatusRolledBack);
                Writer.getOut().completed(xid);
                break;
            }
            case 2: {
                this.getLogger().debug("transaction is prepared");
                Vote vote = this.m_monitor.prepare_vote(xid);
                switch (vote.value()) {
                    case 0: {
                        this.getLogger().debug("Commit is voted");
                        if (this.m_monitor.is_any_rollback(xid)) {
                            this.getLogger().debug("Must be rolledback");
                            Resource[] prepared_resources = this.m_monitor.prepared_resources(xid);
                            this.rollback_resources(xid, prepared_resources);
                            Writer.getOut().rollback_end(xid, Status.StatusRolledBack);
                            Writer.getOut().completed(xid);
                            break;
                        }
                        this.getLogger().debug("Continue commit");
                        Resource[] prepared_resources = this.m_monitor.prepared_resources(xid);
                        Resource[] registered_resources = this.m_monitor.registered_resources(xid);
                        if (prepared_resources.length == 1 && registered_resources.length == 1) {
                            this.continue_commit_one_phase(xid, prepared_resources[0]);
                            break;
                        }
                        this.continue_commit(xid, prepared_resources);
                        break;
                    }
                    case 2: {
                        this.getLogger().debug("ReadOnly is voted");
                        Writer.getOut().commit_end(xid, Status.StatusCommitted);
                        Writer.getOut().completed(xid);
                        break;
                    }
                    case 1: {
                        this.getLogger().debug("Rollback is voted");
                        Resource[] prepared_resources = this.m_monitor.prepared_resources(xid);
                        this.rollback_resources(xid, prepared_resources);
                        Writer.getOut().rollback_end(xid, Status.StatusRolledBack);
                        Writer.getOut().completed(xid);
                    }
                }
                break;
            }
            case 8: {
                this.getLogger().debug("transaction is committing");
                if (this.m_monitor.is_any_rollback(xid)) {
                    this.getLogger().debug("Must be rolledback");
                    Resource[] prepared_resources = this.m_monitor.prepared_resources(xid);
                    this.rollback_resources(xid, prepared_resources);
                    Writer.getOut().rollback_end(xid, Status.StatusRolledBack);
                    Writer.getOut().completed(xid);
                    break;
                }
                this.getLogger().debug("Continue commit");
                Resource[] prepared_resources = this.m_monitor.prepared_resources(xid);
                Resource[] registered_resources = this.m_monitor.registered_resources(xid);
                if (prepared_resources.length == 1 && registered_resources.length == 1) {
                    this.continue_commit_one_phase(xid, prepared_resources[0]);
                    break;
                }
                this.continue_commit(xid, prepared_resources);
                break;
            }
            case 9: {
                this.getLogger().debug("transaction is rolling back");
                Resource[] free_resources = this.m_monitor.free_resources(xid);
                this.rollback_resources(xid, free_resources);
                Writer.getOut().rollback_end(xid, Status.StatusRolledBack);
                Writer.getOut().completed(xid);
                break;
            }
            default: {
                this.getLogger().debug("transaction state not expected, just to be completed : " + status.value());
                Writer.getOut().completed(xid);
            }
        }
    }

    private void rollback_resources(XID xid, Resource[] resources) {
        int i = 0;
        while (i < resources.length) {
            try {
                resources[i].rollback();
                Writer.getOut().rollback_resource(xid, resources[i]);
            }
            catch (HeuristicCommit ex) {
            }
            catch (HeuristicMixed ex) {
            }
            catch (HeuristicHazard ex) {
            }
            catch (COMM_FAILURE ex) {
            }
            catch (OBJECT_NOT_EXIST ex) {
                // empty catch block
            }
            ++i;
        }
    }

    private void continue_commit(XID xid, Resource[] resources) {
        boolean error = false;
        boolean committed = false;
        boolean rollbacked = false;
        Vector<Resource> heuristic = new Vector<Resource>();
        int i = 0;
        while (i < resources.length) {
            if (error && !committed) {
                try {
                    resources[i].rollback();
                    rollbacked = true;
                    Writer.getOut().rollback_resource(xid, resources[i]);
                }
                catch (HeuristicCommit ex) {
                    if (!rollbacked) {
                        committed = true;
                    }
                    heuristic.addElement(resources[i]);
                }
                catch (HeuristicHazard ex) {
                    heuristic.addElement(resources[i]);
                }
                catch (HeuristicMixed ex) {
                    heuristic.addElement(resources[i]);
                }
                catch (COMM_FAILURE ex) {
                }
                catch (OBJECT_NOT_EXIST ex) {}
            } else {
                try {
                    resources[i].commit();
                    committed = true;
                    Writer.getOut().commit_resource(xid, resources[i]);
                }
                catch (NotPrepared ex) {
                    error = true;
                }
                catch (HeuristicRollback ex) {
                    error = true;
                    heuristic.addElement(resources[i]);
                }
                catch (HeuristicMixed ex) {
                    error = true;
                    heuristic.addElement(resources[i]);
                }
                catch (HeuristicHazard ex) {
                    error = true;
                    heuristic.addElement(resources[i]);
                }
                catch (COMM_FAILURE ex) {
                    error = true;
                }
                catch (OBJECT_NOT_EXIST ex) {
                    error = true;
                }
            }
            ++i;
        }
        if (!error) {
            Writer.getOut().commit_end(xid, Status.StatusCommitted);
        } else {
            Writer.getOut().rollback_end(xid, Status.StatusRolledBack);
        }
        Resource res = null;
        int i2 = 0;
        while (i2 < heuristic.size()) {
            res = (Resource)heuristic.elementAt(i2);
            try {
                res.forget();
            }
            catch (COMM_FAILURE ex) {
            }
            catch (OBJECT_NOT_EXIST ex) {
                // empty catch block
            }
            ++i2;
        }
        Writer.getOut().completed(xid);
    }

    private void continue_commit_one_phase(XID xid, Resource resource) {
        try {
            resource.commit_one_phase();
            Writer.getOut().commit_resource(xid, resource);
        }
        catch (HeuristicHazard ex) {
            resource.forget();
        }
        catch (COMM_FAILURE ex) {
        }
        catch (OBJECT_NOT_EXIST ex) {
            // empty catch block
        }
        Writer.getOut().completed(xid);
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

