/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.Impl;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.ControlHelper;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionAwareResourceHelper;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.TransIdentity;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.openorb.ots.Admin.Manager;
import org.openorb.ots.Impl.Control;
import org.openorb.ots.Impl.Coordinator;
import org.openorb.ots.Impl.SubTransListener;
import org.openorb.ots.Impl.XID;

public class SubTransCoordinator
extends Coordinator {
    private TransIdentity[] m_parents;

    public TransIdentity[] getParents() {
        return this.m_parents;
    }

    public SubTransCoordinator(Manager manager, int time_out, XID xid, TransIdentity[] parents, POA poa, Logger logger) {
        super(manager, xid, time_out, poa, parents, logger);
        this.m_parents = parents;
    }

    public Status get_parent_status() {
        return this.m_parents[this.m_parents.length - 1].coord.get_status();
    }

    public Status get_top_level_status() {
        return this.m_parents[0].coord.get_top_level_status();
    }

    public boolean is_related_transaction(org.omg.CosTransactions.Coordinator tc) {
        try {
            TransIdentity[] identities = tc.get_txcontext().parents;
            if (identities.length == 0) {
                return false;
            }
            return identities[0].coord.equals(this.m_parents[0].coord);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean is_ancestor_transaction(org.omg.CosTransactions.Coordinator tc) {
        try {
            TransIdentity[] identities = tc.get_txcontext().parents;
            if (identities.length < this.m_parents.length + 1) {
                return false;
            }
            return identities[this.m_parents.length].coord.equals(this._this());
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean is_top_level_transaction() {
        return false;
    }

    public int hash_top_level_tran() {
        return this.m_parents[0].coord.hash_top_level_tran();
    }

    public String get_transaction_name() {
        XID xid = this.getXID();
        String transaction_name = "[ SUB OpenORB : " + xid.get_gtrid() + " / " + xid.get_bqual() + "]";
        return transaction_name;
    }

    public RecoveryCoordinator register_resource(Resource r) throws Inactive {
        switch (this.get_status().value()) {
            case 0: {
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                throw new TRANSACTION_ROLLEDBACK();
            }
            default: {
                throw new Inactive();
            }
        }
        return this.m_parents[0].coord.register_resource(r);
    }

    public void register_subtran_aware(SubtransactionAwareResource r) throws Inactive, NotSubtransaction {
        switch (this.get_status().value()) {
            case 0: {
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                throw new TRANSACTION_ROLLEDBACK();
            }
            default: {
                throw new Inactive();
            }
        }
        this.addResource(r);
    }

    public org.omg.CosTransactions.Control create_subtransaction() throws SubtransactionsUnavailable, Inactive {
        switch (this.get_status().value()) {
            case 1: 
            case 6: {
                throw new Inactive();
            }
        }
        TransIdentity[] parents = new TransIdentity[this.m_parents.length + 1];
        System.arraycopy(this.m_parents, 0, parents, 0, this.m_parents.length);
        parents[this.m_parents.length] = this.getPropagationCtx().current;
        Control ctrl = new Control(this.getTimeOut(), this.getManager(), this.getXID(), this.getPoa(), parents, this.getLogger());
        try {
            byte[] id = this.getPoa().activate_object((Servant)ctrl);
            ctrl.update();
            org.omg.CosTransactions.Control control = ControlHelper.narrow(this.getPoa().id_to_reference(id));
            SubTransListener subtran_listener = new SubTransListener(this, ctrl, this.getPoa());
            this.addSubTransListener(subtran_listener);
            id = this.getPoa().activate_object((Servant)subtran_listener);
            SubtransactionAwareResource subres = SubtransactionAwareResourceHelper.narrow(this.getPoa().id_to_reference(id));
            control.get_coordinator().register_subtran_aware(subres);
            return control;
        }
        catch (Exception ex) {
            this.getLogger().error("Problem creating subtransaction: " + ex.toString(), (Throwable)ex);
            return null;
        }
    }

    public SubtransactionAwareResource[] subtran_resources() {
        Resource[] resources = this.resources();
        SubtransactionAwareResource[] r = new SubtransactionAwareResource[resources.length];
        int i = 0;
        while (i < resources.length) {
            r[i] = (SubtransactionAwareResource)resources[i];
            ++i;
        }
        return r;
    }
}

