/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.Impl;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CosTransactions.ControlHelper;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.TransactionFactoryPOA;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.openorb.ots.Admin.Manager;
import org.openorb.ots.Impl.Control;
import org.openorb.ots.log.Writer;

public class TransactionFactory
extends TransactionFactoryPOA {
    private POA m_poa;
    private POA m_recovery_poa;
    private Manager m_manager;
    private Logger m_logger;

    public TransactionFactory(Manager manager, POA poa, POA recovery_poa, Logger logger) {
        this.m_poa = poa;
        this.m_recovery_poa = recovery_poa;
        this.m_logger = logger;
        this.m_manager = manager;
    }

    public org.omg.CosTransactions.Control create(int time_out) {
        Control ctrl = new Control(time_out, this.m_manager, null, this, this.m_poa, this.m_recovery_poa, this.getLogger());
        try {
            byte[] id = this.m_poa.activate_object((Servant)ctrl);
            ctrl.update();
            org.omg.CosTransactions.Control control = ControlHelper.narrow(this.m_poa.id_to_reference(id));
            Writer.getOut().begin_transaction(ctrl);
            this.m_manager.notifyNewTransaction(ctrl, ctrl.getCoordinator().getXID());
            return control;
        }
        catch (ObjectNotActive ex) {
            this.getLogger().error("OpenORB OTS Warning", (Throwable)ex);
        }
        catch (ServantAlreadyActive ex) {
            this.getLogger().error("OpenORB OTS Warning", (Throwable)ex);
        }
        catch (WrongPolicy ex) {
            this.getLogger().error("OpenORB OTS Warning", (Throwable)ex);
        }
        return null;
    }

    public org.omg.CosTransactions.Control recreate(PropagationContext ctx) {
        Control ctrl = new Control(ctx.timeout, this.m_manager, ctx, this, this.m_poa, this.m_recovery_poa, this.getLogger());
        try {
            byte[] id = this.m_poa.activate_object((Servant)ctrl);
            ctrl.update();
            org.omg.CosTransactions.Control control = ControlHelper.narrow(this.m_poa.id_to_reference(id));
            Writer.getOut().begin_transaction_sub(ctrl);
            return control;
        }
        catch (ObjectNotActive ex) {
            this.getLogger().error("OpenORB OTS Warning", (Throwable)ex);
        }
        catch (ServantAlreadyActive ex) {
            this.getLogger().error("OpenORB OTS Warning", (Throwable)ex);
        }
        catch (WrongPolicy ex) {
            this.getLogger().error("OpenORB OTS Warning", (Throwable)ex);
        }
        return null;
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

