/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots;

import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.openorb.ots.Impl.Current;
import org.openorb.ots.ORB.TransactionalClientInterceptor;
import org.openorb.ots.ORB.TransactionalServerInterceptor;
import org.openorb.ots.xa.SessionManager;

public class Initializer
extends LocalObject
implements ORBInitializer,
LogEnabled {
    private int m_slot;
    private Logger m_logger = null;

    public void pre_init(ORBInitInfo info) {
        this.getLogger().debug("pre_init");
        Logger clientInterceptorLogger = this.getLogger().getChildLogger("TxnCltInt");
        Logger serverInterceptorLogger = this.getLogger().getChildLogger("TxnSrvInt");
        this.m_slot = info.allocate_slot_id();
        TransactionalClientInterceptor clientInterceptor = new TransactionalClientInterceptor(info, this.m_slot);
        ContainerUtil.enableLogging((java.lang.Object)((java.lang.Object)clientInterceptor), (Logger)clientInterceptorLogger);
        TransactionalServerInterceptor serverInterceptor = new TransactionalServerInterceptor(info, this.m_slot);
        ContainerUtil.enableLogging((java.lang.Object)((java.lang.Object)serverInterceptor), (Logger)serverInterceptorLogger);
        try {
            info.add_client_request_interceptor((ClientRequestInterceptor)clientInterceptor);
            info.add_server_request_interceptor((ServerRequestInterceptor)serverInterceptor);
        }
        catch (DuplicateName dn) {
            this.getLogger().error("Duplicate name when adding the intercptor", (Throwable)dn);
        }
    }

    public void post_init(ORBInitInfo info) {
        this.getLogger().debug("post_init");
        try {
            Current current = new Current(info, this.m_slot);
            info.register_initial_reference("TransactionCurrent", (Object)current);
            SessionManager manager = new SessionManager(info);
            info.register_initial_reference("TransactionSessionManager", (Object)manager);
        }
        catch (InvalidName ex) {
            this.getLogger().error("Unable to resolve TransactionService", (Throwable)ex);
            throw new INTERNAL();
        }
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public Logger getLogger() {
        if (this.m_logger == null) {
            this.m_logger = new ConsoleLogger(1);
        }
        return this.m_logger;
    }
}

