/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots;

import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.openorb.ots.Admin.Manager;
import org.openorb.ots.Impl.RecoveryCoordinator;
import org.openorb.ots.Impl.RecoveryManager;
import org.openorb.ots.Impl.TransactionFactory;
import org.openorb.ots.log.Writer;
import org.openorb.util.service.ServiceBase;

public class Service
extends ServiceBase {
    public static final String OPT_RECOVER = "r";
    public static final String OPT_RECOVER_LONG = "recover";
    public static final String OPT_RECOVER_DESCRIP = "after a failure ( internal or external ), this option can be used to recover all not completed transactions from the logs";
    private POA m_root_poa = null;
    private POA m_recovery_poa = null;
    private RecoveryCoordinator m_recovery_coordinator = null;
    private Object m_trx_factory = null;

    public java.lang.Object createRecoveryPOA() {
        POA poa = POAHelper.narrow((Object)((Object)this.createPOA()));
        POA result = null;
        try {
            Policy[] policies = new Policy[]{poa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), poa.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), poa.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID), poa.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT), poa.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN)};
            result = poa.create_POA("OTSrecoveryPOA", poa.the_POAManager(), policies);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void initializeService() {
        try {
            ORB orb = (ORB)this.getContext().get((java.lang.Object)"ORB");
            if (orb != null) {
                boolean bRecover = this.getParameters().getParameterAsBoolean(OPT_RECOVER, false);
                Writer.newWriter(orb, bRecover, this.getLogger());
                this.m_root_poa = POAHelper.narrow((Object)((POA)this.createPOA()));
                this.m_recovery_poa = POAHelper.narrow((Object)((POA)this.createRecoveryPOA()));
                RecoveryCoordinator recoveryCoordinator = new RecoveryCoordinator(orb, this.getLogger());
                this.m_recovery_poa.set_servant((Servant)recoveryCoordinator);
                Manager manager = new Manager(this.m_root_poa);
                this.m_root_poa.activate_object((Servant)manager);
                TransactionFactory trxfactory = new TransactionFactory(manager, this.m_root_poa, this.m_recovery_poa, this.getLogger());
                byte[] servantId = this.m_root_poa.activate_object((Servant)trxfactory);
                this.m_trx_factory = this.m_root_poa.id_to_reference(servantId);
                this.registerObject("TransactionFactory", this.m_trx_factory);
            }
        }
        catch (Exception ex) {
            this.getLogger().fatalError("Exception occured while initializing the service", (Throwable)ex);
            throw new CascadingRuntimeException("Problem while initializing the service", (Throwable)ex);
        }
    }

    public void startService() {
        try {
            if (this.m_root_poa != null) {
                this.m_root_poa.the_POAManager().activate();
            }
        }
        catch (AdapterInactive ex) {
            this.getLogger().fatalError("The POAManager is inactive!", (Throwable)ex);
            throw new CascadingRuntimeException("The POAManager is inactive!", (Throwable)ex);
        }
        try {
            boolean bRecover;
            ORB orb = (ORB)this.getContext().get((java.lang.Object)"ORB");
            if (orb != null && (bRecover = this.getParameters().getParameterAsBoolean(OPT_RECOVER, false))) {
                Logger recoveryLogger = this.getLogger().getChildLogger("recovery");
                RecoveryManager recovery_mgr = new RecoveryManager(orb, recoveryLogger);
                recovery_mgr.recover_transactions();
            }
        }
        catch (Exception ex) {
            this.getLogger().fatalError("Exception occured while starting the service", (Throwable)ex);
            throw new CascadingRuntimeException("Problem while starting the service", (Throwable)ex);
        }
    }

    public void stopService() {
        try {
            if (this.m_root_poa != null) {
                this.m_root_poa.the_POAManager().deactivate(false, true);
            }
        }
        catch (AdapterInactive ex) {
            this.getLogger().fatalError("The POAManager is inactive!", (Throwable)ex);
            throw new CascadingRuntimeException("The POAManager is inactive!", (Throwable)ex);
        }
    }

    public String getTransactionFactoryIOR() {
        String result = null;
        try {
            ORB orb = (ORB)this.getContext().get((java.lang.Object)"ORB");
            if (orb != null) {
                result = orb.object_to_string(this.m_trx_factory);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

