/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;

public final class Verbose {
    private static boolean s_verbose = false;
    private static PrintStream s_out = System.out;

    private Verbose() {
    }

    public static void enable(String file_name) {
        if (file_name != null) {
            // empty if block
        }
        s_verbose = true;
    }

    public static void disable() {
        s_verbose = false;
    }

    public static void print(String className, String message) {
        if (s_verbose) {
            s_out.println(className + " : " + message);
        }
    }

    public static void exception(String className, String message, Exception ex) {
        if (s_verbose) {
            s_out.println("==> Exception in " + className + " : " + message);
            ex.printStackTrace(s_out);
            s_out.println("<==");
        }
    }

    public static void fatal(String className, String message) {
        s_out.println("**********************************************************************");
        s_out.println("Fatal error in " + className + " : ");
        s_out.println("\t" + message);
        s_out.println();
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(bos);
            new Error().printStackTrace(pw);
            pw.close();
            BufferedReader reader = new BufferedReader(new StringReader(bos.toString()));
            s_out.println(reader.readLine());
            reader.readLine();
            s_out.println("Stack trace:");
            String line = reader.readLine();
            while (line != null) {
                s_out.println(line);
                line = reader.readLine();
            }
            s_out.println();
        }
        catch (IOException ex) {
            s_out.println(ex);
        }
        System.exit(1);
    }
}

