/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.jta;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.ResourceHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.openorb.ots.jta.XACoordinator;

public class Transaction
implements javax.transaction.Transaction {
    private Current m_current;
    private POA m_poa;
    private ORB m_orb;
    private XACoordinator m_coordinator;
    private Logger m_logger;

    public Transaction(Current curr, POA poa, ORB orb, Logger logger) {
        this.m_logger = logger;
        this.m_current = curr;
        this.m_poa = poa;
        this.m_orb = orb;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            this.m_current.commit(true);
        }
        catch (HeuristicMixed ex) {
            throw new HeuristicMixedException();
        }
        catch (TRANSACTION_ROLLEDBACK ex) {
            throw new RollbackException();
        }
        catch (Exception ex) {
            throw new SystemException();
        }
    }

    public boolean delistResource(XAResource resource, int flag) throws IllegalStateException, SystemException {
        try {
            if (this.m_coordinator == null) {
                throw new IllegalStateException();
            }
            if (flag == 0x4000000) {
                this.m_coordinator.endXAResource(resource, true);
            } else {
                this.m_coordinator.endXAResource(resource, false);
            }
            return true;
        }
        catch (Exception ex) {
            throw new SystemException();
        }
    }

    public boolean enlistResource(XAResource resource) throws RollbackException, IllegalStateException, SystemException {
        try {
            if (this.m_coordinator == null) {
                this.m_coordinator = new XACoordinator(this.m_poa, this.m_current.get_control().get_coordinator().get_txcontext().current.otid, this.getLogger());
                this.m_poa.activate_object((Servant)this.m_coordinator);
                Resource coordinator_ref = ResourceHelper.narrow(this.m_poa.servant_to_reference((Servant)this.m_coordinator));
                this.m_current.get_control().get_coordinator().register_resource(coordinator_ref);
            }
            this.m_coordinator.registerXAResource(resource);
            return true;
        }
        catch (Exception ex) {
            throw new SystemException();
        }
    }

    public int getStatus() throws SystemException {
        try {
            return this.m_current.get_status().value();
        }
        catch (Exception ex) {
            throw new SystemException();
        }
    }

    public void registerSynchronization(Synchronization synchro) throws RollbackException, IllegalStateException, SystemException {
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            this.m_current.rollback();
        }
        catch (Exception ex) {
            throw new SystemException();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        try {
            this.m_current.rollback_only();
        }
        catch (Exception ex) {
            throw new SystemException();
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

