/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.jta;

import java.util.Hashtable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.CurrentHelper;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.PortableServer.POA;
import org.openorb.ots.jta.Transaction;

public class TransactionManager
implements javax.transaction.TransactionManager {
    private Hashtable m_suspended;
    private ORB m_orb;
    private POA m_poa;
    private Logger m_logger;

    public TransactionManager(ORB orb, POA poa, Logger logger) {
        this.m_logger = logger;
        this.m_orb = orb;
        this.m_poa = poa;
        this.m_suspended = new Hashtable();
    }

    public void begin() throws NotSupportedException, SystemException {
        try {
            this.current().begin();
        }
        catch (SubtransactionsUnavailable ex) {
            throw new NotSupportedException();
        }
        catch (Exception ex) {
            throw new SystemException();
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            this.current().commit(true);
        }
        catch (HeuristicMixed ex) {
            throw new HeuristicMixedException();
        }
        catch (TRANSACTION_ROLLEDBACK ex) {
            throw new RollbackException();
        }
        catch (Exception ex) {
            throw new SystemException();
        }
    }

    public int getStatus() throws SystemException {
        try {
            int status = this.current().get_status().value();
            return status;
        }
        catch (org.omg.CORBA.SystemException ex) {
            return 6;
        }
        catch (Exception ex) {
            throw new SystemException();
        }
    }

    public javax.transaction.Transaction getTransaction() throws SystemException {
        try {
            if (this.getStatus() == 6) {
                return null;
            }
            return new Transaction(this.current(), this.m_poa, this.m_orb, this.getLogger());
        }
        catch (Exception ex) {
            throw new SystemException();
        }
    }

    public void resume(javax.transaction.Transaction t) throws InvalidTransactionException, IllegalStateException, SystemException {
        try {
            Control ctrl = (Control)this.m_suspended.get(t);
            if (ctrl == null) {
                throw new IllegalStateException();
            }
            this.current().resume(ctrl);
            this.m_suspended.remove(ctrl);
        }
        catch (Exception ex) {
            throw new SystemException();
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            this.current().rollback();
        }
        catch (Exception ex) {
            throw new SystemException();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        try {
            this.current().rollback_only();
        }
        catch (Exception ex) {
            throw new SystemException();
        }
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        try {
            this.current().set_timeout(seconds);
        }
        catch (Exception ex) {
            throw new SystemException();
        }
    }

    public javax.transaction.Transaction suspend() throws SystemException {
        javax.transaction.Transaction t = this.getTransaction();
        try {
            Control ctrl = this.current().suspend();
            if (ctrl == null) {
                return null;
            }
            this.m_suspended.put(t, ctrl);
        }
        catch (Exception ex) {
            throw new SystemException();
        }
        return t;
    }

    private Current current() {
        try {
            return CurrentHelper.narrow(this.m_orb.resolve_initial_references("TransactionCurrent"));
        }
        catch (InvalidName ex) {
            return null;
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

