/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.jta;

import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.ResourcePOA;
import org.omg.CosTransactions.Vote;
import org.omg.CosTransactions.otid_t;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.openorb.ots.jta.XID;
import org.openorb.util.ExceptionTool;

public class XACoordinator
extends ResourcePOA {
    private POA m_poa;
    private Vector m_xa;
    private Xid m_xid;
    private Vector m_prepared;
    private Vector m_heuristic;
    private boolean m_prepared_transaction;
    private Logger m_logger;

    public XACoordinator(POA poa, otid_t ots_xid, Logger logger) {
        this.m_logger = logger;
        this.m_poa = poa;
        this.m_xa = new Vector();
        this.m_xid = new XID(ots_xid);
        this.m_prepared = new Vector();
        this.m_heuristic = new Vector();
        this.m_prepared_transaction = false;
    }

    public Vote prepare() throws HeuristicMixed, HeuristicHazard {
        XAResource res = null;
        boolean error = false;
        Vote global_vote = Vote.VoteReadOnly;
        this.m_prepared.removeAllElements();
        int i = 0;
        while (i < this.m_xa.size()) {
            res = (XAResource)this.m_xa.elementAt(i);
            if (error) {
                try {
                    res.rollback(this.m_xid);
                }
                catch (XAException ex) {}
            } else {
                try {
                    switch (res.prepare(this.m_xid)) {
                        case 0: {
                            this.m_prepared.addElement(res);
                            global_vote = Vote.VoteCommit;
                            break;
                        }
                    }
                }
                catch (XAException ex) {
                    error = true;
                    global_vote = Vote.VoteRollback;
                }
            }
            ++i;
        }
        this.m_prepared_transaction = true;
        if (global_vote.value() == 1) {
            try {
                this.rollback_after_prepare();
            }
            catch (HeuristicCommit ex) {
                throw new HeuristicMixed();
            }
        }
        return global_vote;
    }

    public void rollback() throws HeuristicCommit, HeuristicMixed, HeuristicHazard {
        XAResource res = null;
        boolean heuristic_commit = false;
        this.m_prepared_transaction = false;
        this.m_heuristic.removeAllElements();
        int i = 0;
        while (i < this.m_xa.size()) {
            block4: {
                res = (XAResource)this.m_xa.elementAt(i);
                try {
                    res.rollback(this.m_xid);
                }
                catch (XAException ex) {
                    if (ex.errorCode != 7) break block4;
                    heuristic_commit = true;
                    this.m_heuristic.addElement(res);
                }
            }
            ++i;
        }
        if (heuristic_commit) {
            throw new HeuristicCommit();
        }
        this.complete();
    }

    public void commit() throws NotPrepared, HeuristicRollback, HeuristicMixed, HeuristicHazard {
        XAResource res = null;
        boolean error = false;
        boolean committed = false;
        boolean rolledback = false;
        if (!this.m_prepared_transaction) {
            throw new NotPrepared();
        }
        int i = 0;
        while (i < this.m_prepared.size()) {
            block11: {
                res = (XAResource)this.m_prepared.elementAt(i);
                if (error && !committed) {
                    try {
                        res.rollback(this.m_xid);
                        rolledback = true;
                    }
                    catch (XAException ex) {
                        this.m_heuristic.addElement(res);
                        if (!rolledback) {
                            committed = true;
                        }
                        break block11;
                    }
                }
                try {
                    res.commit(this.m_xid, false);
                    committed = true;
                }
                catch (XAException ex) {
                    this.m_heuristic.addElement(res);
                    error = true;
                }
            }
            ++i;
        }
        this.m_prepared.removeAllElements();
        if (committed && rolledback) {
            throw new HeuristicMixed();
        }
        if (rolledback) {
            throw new HeuristicRollback();
        }
        if (error) {
            throw new HeuristicHazard();
        }
        this.complete();
    }

    public void commit_one_phase() throws HeuristicHazard {
        this.m_prepared_transaction = false;
        if (this.m_xa.size() > 0) {
            XAResource res = (XAResource)this.m_xa.elementAt(0);
            try {
                res.commit(this.m_xid, true);
            }
            catch (XAException ex) {
                this.m_heuristic.addElement(res);
                throw new HeuristicHazard();
            }
        }
        this.complete();
    }

    public void forget() {
        this.m_prepared_transaction = false;
        XAResource res = null;
        int i = 0;
        while (i < this.m_heuristic.size()) {
            res = (XAResource)this.m_heuristic.elementAt(i);
            try {
                res.rollback(this.m_xid);
            }
            catch (XAException xAException) {
                // empty catch block
            }
            ++i;
        }
        this.m_heuristic.removeAllElements();
        this.complete();
    }

    public void rollback_after_prepare() throws HeuristicCommit, HeuristicMixed, HeuristicHazard {
        XAResource res = null;
        boolean heuristic_commit = false;
        this.m_prepared_transaction = false;
        int i = 0;
        while (i < this.m_prepared.size()) {
            block4: {
                res = (XAResource)this.m_prepared.elementAt(i);
                try {
                    res.rollback(this.m_xid);
                }
                catch (XAException ex) {
                    if (ex.errorCode != 7) break block4;
                    heuristic_commit = true;
                    this.m_heuristic.addElement(res);
                }
            }
            ++i;
        }
        this.m_prepared.removeAllElements();
        if (heuristic_commit) {
            throw new HeuristicCommit();
        }
        this.complete();
    }

    public void registerXAResource(XAResource resource) {
        boolean already = false;
        if (!this.m_xa.contains(resource)) {
            this.m_xa.addElement(resource);
        } else {
            already = true;
        }
        try {
            if (already) {
                resource.start(this.m_xid, 0x200000);
            } else {
                resource.start(this.m_xid, 0);
            }
        }
        catch (XAException ex) {
            this.getLogger().error("unable to register XA resource: " + ex.toString());
            throw ExceptionTool.initCause((SystemException)new INTERNAL(ex.toString()), (Throwable)ex);
        }
    }

    public void endXAResource(XAResource resource, boolean success) {
        try {
            if (success) {
                resource.end(this.m_xid, 0x4000000);
            } else {
                resource.end(this.m_xid, 0x20000000);
            }
        }
        catch (XAException ex) {
            this.getLogger().error("unable to end usage of XA resource: " + ex.toString(), (Throwable)ex);
            throw ExceptionTool.initCause((SystemException)new INTERNAL(ex.toString()), (Throwable)ex);
        }
    }

    private void complete() {
        try {
            byte[] id = this.m_poa.servant_to_id((Servant)this);
            this.m_poa.deactivate_object(id);
        }
        catch (Exception ex) {
            this.getLogger().error("unable to complete transaction: " + ex.toString());
            throw ExceptionTool.initCause((SystemException)new INTERNAL(), (Throwable)ex);
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

