/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.log;

import java.util.GregorianCalendar;
import org.openorb.ots.log.Writer;

public class LogTimer
extends Thread {
    private int m_day;

    public LogTimer(int day) {
        this.m_day = day;
    }

    public void run() {
        boolean time_ok = false;
        while (!time_ok) {
            long wait_in_seconds = this.getWaitUntilMidnight();
            try {
                Thread.sleep(wait_in_seconds * 1000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (this.getCurrentDay() != this.m_day) {
                time_ok = true;
            }
            if (!time_ok) continue;
            Writer.getOut().changeLog();
        }
    }

    private long getWaitUntilMidnight() {
        GregorianCalendar calendar = new GregorianCalendar();
        if (this.m_day != this.getCurrentDay()) {
            return 0L;
        }
        int second = calendar.get(13);
        int minute = calendar.get(12);
        int hour = calendar.get(11);
        long delay_second = 60 - second;
        long delay_minute = (60 - minute) * 60;
        long delay_hour = (24 - hour) * 3600;
        return delay_hour + delay_minute + delay_second;
    }

    public int getCurrentDay() {
        GregorianCalendar calendar = new GregorianCalendar();
        return calendar.get(5);
    }
}

