/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.xa;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.openorb.ots.xa.ConnectionWrapper;
import org.openorb.ots.xa.XAVirtualDataSource;
import org.openorb.ots.xa.XAVirtualResource;

public class XAVirtualConnection
implements XAConnection {
    private Connection m_sql_connection;
    private ConnectionWrapper m_connection;
    private XAResource m_xa_resource;
    private XAVirtualDataSource m_xa_datasource;
    private Vector m_listeners = new Vector();

    public XAVirtualConnection(Connection connection, XAVirtualDataSource xa_datasource) {
        this.m_sql_connection = connection;
        this.m_xa_datasource = xa_datasource;
        this.m_connection = new ConnectionWrapper(connection, this);
        this.m_xa_resource = new XAVirtualResource(connection, this);
    }

    public Connection getConnection() throws SQLException {
        return this.m_connection;
    }

    public void close() throws SQLException {
        this.m_sql_connection.close();
        this.m_sql_connection = null;
        this.m_connection = null;
        this.m_xa_resource = null;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.m_listeners.addElement(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.m_listeners.removeElement(listener);
    }

    public XAResource getXAResource() throws SQLException {
        return this.m_xa_resource;
    }

    public void closeEvent() {
        ConnectionEventListener listener = null;
        int i = 0;
        while (i < this.m_listeners.size()) {
            listener = (ConnectionEventListener)this.m_listeners.elementAt(i);
            listener.connectionClosed(new ConnectionEvent(this));
            ++i;
        }
    }

    public void errorEvent(SQLException ex) {
        ConnectionEventListener listener = null;
        int i = 0;
        while (i < this.m_listeners.size()) {
            listener = (ConnectionEventListener)this.m_listeners.elementAt(i);
            listener.connectionErrorOccurred(new ConnectionEvent(this, ex));
            ++i;
        }
    }

    public String getDataSourceMetaData() {
        return this.m_xa_datasource.getMetaData();
    }
}

