/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.xa;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.ORB;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.config.PropertyNotFoundException;
import org.openorb.ots.xa.XAVirtualConnection;

public class XAVirtualDataSource
implements XADataSource {
    private static final int DEFAULT_TIMEOUT = 60;
    private PrintWriter m_log;
    private int m_timeout;
    private String m_jdbc_url;
    private String m_metadata;
    private ORB m_orb;
    private Logger m_logger;

    public XAVirtualDataSource(ORB orb, Logger logger) {
        this.m_logger = logger;
        this.m_log = null;
        this.m_orb = orb;
        ORBLoader cfg = ((org.openorb.orb.core.ORB)this.m_orb).getLoader();
        String tout = null;
        try {
            tout = cfg.getStringProperty("OTS.Database.LoginTimeout");
        }
        catch (PropertyNotFoundException pnf) {
            this.getLogger().warn("Unable to find OTS.Database.LoginTimeout property, using default: 60", (Throwable)pnf);
        }
        if (tout == null) {
            this.m_timeout = 60;
        } else {
            try {
                this.m_timeout = new Integer(tout);
            }
            catch (NumberFormatException ex) {
                this.getLogger().warn("Cannot interpret OTS.Database.LoginTimeout property value '" + tout + "', using default: " + 60);
                this.m_timeout = 60;
            }
        }
    }

    public int getLoginTimeout() throws SQLException {
        return this.m_timeout;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.m_log;
    }

    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(null, null);
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        ORBLoader cfg = ((org.openorb.orb.core.ORB)this.m_orb).getLoader();
        Connection connection = null;
        String user_name = user;
        String user_password = password;
        try {
            if (user == null) {
                user_name = cfg.getStringProperty("OTS.Database.User");
            }
            if (password == null) {
                user_password = cfg.getStringProperty("OTS.Database.Password");
            }
        }
        catch (PropertyNotFoundException pnf) {
            this.getLogger().warn("Unable to find OTS.Database.User or Password property, trying with empty string");
        }
        if (user == null) {
            user_name = "";
        }
        if (password == null) {
            user_password = "";
        }
        if (user_name.length() == 0 && user_password.length() == 0) {
            connection = DriverManager.getConnection(this.m_jdbc_url);
        } else {
            this.getLogger().debug("getConnection(" + this.m_jdbc_url + ", " + user_name + ", " + user_password + ")");
            connection = DriverManager.getConnection(this.m_jdbc_url, user_name, user_password);
        }
        this.m_metadata = connection.getMetaData().getDatabaseProductName() + ":" + connection.getMetaData().getDatabaseProductVersion();
        XAVirtualConnection xa_connection = new XAVirtualConnection(connection, this);
        return xa_connection;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_timeout = seconds;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_log = out;
    }

    public void set_jdbc_url(String url) {
        this.m_jdbc_url = url;
    }

    public String getMetaData() {
        return this.m_metadata;
    }

    public Logger getLogger() {
        return this.m_logger;
    }
}

