/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.examples.withres;

import java.util.Vector;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.CurrentHelper;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Unavailable;
import org.openorb.ots.examples.withres.AccountPOA;
import org.openorb.ots.examples.withres.AccountResource;
import org.openorb.ots.examples.withres.AccountResourceImpl;

public class AccountImpl
extends AccountPOA {
    private float m_balance = 0.0f;
    private ORB m_orb;
    private Vector m_resources;
    private String m_name;

    public AccountImpl(ORB orb, String name) {
        this.m_orb = orb;
        this.m_resources = new Vector();
        this.m_name = name;
    }

    public float balance() {
        return this.get_resource().balance();
    }

    public void balance(float balance) {
        this.m_balance = balance;
    }

    public void credit(float value) {
        this.get_resource().credit(value);
    }

    public void debit(float value) {
        this.get_resource().debit(value);
    }

    public Vector resources() {
        return this.m_resources;
    }

    public void rollbackOnly() {
        try {
            Object obj = this.m_orb.resolve_initial_references("TransactionCurrent");
            Current current = CurrentHelper.narrow((Object)obj);
            current.rollback_only();
        }
        catch (InvalidName ex) {
            throw new TRANSACTION_REQUIRED();
        }
        catch (NoTransaction ex) {
            throw new TRANSACTION_REQUIRED();
        }
    }

    public AccountResource get_resource() {
        try {
            Object obj = this.m_orb.resolve_initial_references("TransactionCurrent");
            Current current = CurrentHelper.narrow((Object)obj);
            Coordinator coordinator = current.get_control().get_coordinator();
            AccountResourceImpl resource = null;
            int i = 0;
            while (i < this.m_resources.size()) {
                resource = (AccountResourceImpl)this.m_resources.elementAt(i);
                if (coordinator.is_same_transaction(resource.coordinator())) {
                    return resource._this(this.m_orb);
                }
                ++i;
            }
            System.out.println("Create a new resource for " + this.m_name);
            resource = new AccountResourceImpl(this._poa(), coordinator, this, this.m_balance, this.m_name);
            AccountResource res = resource._this(this.m_orb);
            coordinator.register_resource((Resource)res);
            this.m_resources.addElement(resource);
            return res;
        }
        catch (InvalidName ex) {
            throw new TRANSACTION_REQUIRED();
        }
        catch (Unavailable ex) {
            throw new TRANSACTION_REQUIRED();
        }
        catch (Inactive ex) {
            throw new TRANSACTION_REQUIRED();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new TRANSACTION_REQUIRED();
        }
    }
}

