/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.examples.xa;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.CurrentHelper;
import org.omg.CosTransactions.NoTransaction;
import org.openorb.ots.examples.xa.AccountPOA;

public class AccountImpl
extends AccountPOA {
    private String m_name;
    private Connection m_db;
    private ORB m_orb;

    public AccountImpl(ORB orb, String name, Connection db) {
        this.m_orb = orb;
        this.m_name = name;
        this.m_db = db;
    }

    public float balance() {
        ResultSet res = null;
        try {
            PreparedStatement pstmt = this.m_db.prepareStatement("SELECT balance from Accounts where name=?");
            pstmt.setString(1, this.m_name);
            res = pstmt.executeQuery();
            pstmt.close();
        }
        catch (SQLException ex) {
            System.out.println("Unable to get an account from the database.");
            System.exit(0);
        }
        try {
            res.next();
            return res.getFloat(1);
        }
        catch (SQLException ex) {
            System.out.println("Unable to get balance value for : " + this.m_name);
            return -1.0f;
        }
    }

    public void credit(float value) {
        float balance = this.balance();
        this.updateBalance(balance += value);
    }

    public void debit(float value) {
        float balance = this.balance();
        if ((balance -= value) < 0.0f) {
            this.rollbackOnly();
        }
        this.updateBalance(balance);
    }

    public void updateBalance(float balance) {
        try {
            PreparedStatement pstmt = this.m_db.prepareStatement("UPDATE Accounts SET balance=? WHERE name=?");
            pstmt.setFloat(1, balance);
            pstmt.setString(2, this.m_name);
            pstmt.executeUpdate();
            pstmt.close();
        }
        catch (SQLException ex) {
            System.out.println("Unable to update the database for : " + this.m_name);
        }
    }

    public void rollbackOnly() {
        try {
            Object obj = this.m_orb.resolve_initial_references("TransactionCurrent");
            Current current = CurrentHelper.narrow((Object)obj);
            current.rollback_only();
        }
        catch (InvalidName ex) {
            throw new TRANSACTION_REQUIRED();
        }
        catch (NoTransaction ex) {
            throw new TRANSACTION_REQUIRED();
        }
    }
}

