/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.examples.xa;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.openorb.ots.SessionManager;
import org.openorb.ots.SessionManagerHelper;
import org.openorb.ots.examples.xa.Account;
import org.openorb.ots.examples.xa.AccountImpl;
import org.openorb.ots.examples.xa.BankPOA;
import org.openorb.ots.examples.xa.NotExistingAccount;

public class BankImpl
extends BankPOA {
    private ORB m_orb;
    private Connection m_db;
    private Hashtable m_accounts;

    public BankImpl(ORB orb) {
        this.m_orb = orb;
        this.m_accounts = new Hashtable();
        this.connectToDatabase();
    }

    public Account create_account(String name) {
        AccountImpl acc = new AccountImpl(this.m_orb, name, this.m_db);
        this.m_accounts.put(name, acc);
        try {
            PreparedStatement pstmt = this.m_db.prepareStatement("INSERT INTO Accounts VALUES (?,?)");
            pstmt.setString(1, name);
            pstmt.setFloat(2, 0.0f);
            pstmt.executeUpdate();
            pstmt.close();
        }
        catch (SQLException ex) {
            System.out.println("Unable to insert an entry into the database for : " + name);
            System.exit(0);
        }
        return acc._this(this.m_orb);
    }

    public Account get_account(String name) throws NotExistingAccount {
        AccountImpl acc = (AccountImpl)this.m_accounts.get(name);
        if (acc == null) {
            ResultSet res = null;
            try {
                PreparedStatement pstmt = this.m_db.prepareStatement("SELECT balance from Accounts where name=?");
                pstmt.setString(1, name);
                res = pstmt.executeQuery();
                pstmt.close();
            }
            catch (SQLException ex) {
                System.out.println("Unable to get an account from the database.");
                System.exit(0);
            }
            try {
                res.next();
                res.getFloat(1);
                acc = new AccountImpl(this.m_orb, name, this.m_db);
                this.m_accounts.put(name, acc);
            }
            catch (SQLException ex) {
                // empty catch block
            }
        }
        if (acc == null) {
            throw new NotExistingAccount();
        }
        return acc._this(this.m_orb);
    }

    public void connectToDatabase() {
        System.out.println("Get a database connection...");
        try {
            Object obj = this.m_orb.resolve_initial_references("TransactionSessionManager");
            SessionManager session = SessionManagerHelper.narrow((Object)obj);
            this.m_db = session.getConnection(null, null, "HSQLDB");
        }
        catch (Exception ex) {
            System.out.print("Unable to get a databse connection : ");
            ex.printStackTrace();
            System.exit(0);
        }
        System.out.println(" => OK\n");
        if (!this.tableExist()) {
            this.createTable();
        }
    }

    public boolean tableExist() {
        try {
            Statement stmt = this.m_db.createStatement();
            ResultSet res = stmt.executeQuery("SELECT * from Accounts");
            res.close();
        }
        catch (SQLException ex) {
            return false;
        }
        return true;
    }

    public void createTable() {
        System.out.println("Create table...");
        try {
            Statement stmt = this.m_db.createStatement();
            stmt.executeUpdate("CREATE TABLE Accounts ( name char(50) PRIMARY KEY, balance float )");
            stmt.close();
        }
        catch (SQLException ex) {
            System.out.println("Unable to create table...");
            System.exit(0);
        }
        System.out.println(" => OK\n");
    }
}

