/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.BridgeUpdateHandler;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.FocusManager;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.bridge.SVGBridgeExtension;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentViewport;
import org.apache.batik.bridge.Viewport;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.CSSEngineListener;
import org.apache.batik.css.engine.SystemColorSupport;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterPool;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;

public class BridgeContext
implements ErrorConstants,
CSSContext {
    protected Document document;
    protected GVTBuilder gvtBuilder;
    protected Map interpreterMap = new HashMap(7);
    private Map fontFamilyMap;
    protected Map viewportMap = new HashMap();
    protected List viewportStack = new LinkedList();
    protected UserAgent userAgent;
    protected HashMap elementNodeMap;
    protected HashMap nodeElementMap;
    protected HashMap namespaceURIMap;
    protected InterpreterPool interpreterPool;
    protected DocumentLoader documentLoader;
    protected Dimension2D documentSize;
    protected TextPainter textPainter;
    protected boolean dynamic;
    protected UpdateManager updateManager;
    private static InterpreterPool sharedPool = new InterpreterPool();
    protected List eventListenerList = new LinkedList();
    protected EventListener domCharacterDataModifiedListener;
    protected EventListener domAttrModifiedEventListener;
    protected EventListener domNodeInsertedEventListener;
    protected EventListener domNodeRemovedEventListener;
    protected CSSEngineListener cssPropertiesChangedListener;
    protected FocusManager focusManager;
    protected static List extensions = null;
    static /* synthetic */ Class class$org$apache$batik$bridge$BridgeExtension;

    protected BridgeContext() {
    }

    public BridgeContext(UserAgent userAgent) {
        this(userAgent, sharedPool, new DocumentLoader(userAgent));
    }

    public BridgeContext(UserAgent userAgent, DocumentLoader documentLoader) {
        this(userAgent, sharedPool, documentLoader);
    }

    public BridgeContext(UserAgent userAgent, InterpreterPool interpreterPool, DocumentLoader documentLoader) {
        this.userAgent = userAgent;
        this.viewportMap.put(userAgent, new UserAgentViewport(userAgent));
        this.interpreterPool = interpreterPool;
        this.documentLoader = documentLoader;
        documentLoader.setBridgeContext(this);
        BridgeContext.registerSVGBridges(this);
    }

    protected void initializeDocument(Document document) {
        SVGOMDocument sVGOMDocument = (SVGOMDocument)document;
        CSSEngine cSSEngine = sVGOMDocument.getCSSEngine();
        if (cSSEngine == null) {
            SVGDOMImplementation sVGDOMImplementation = (SVGDOMImplementation)sVGOMDocument.getImplementation();
            cSSEngine = sVGDOMImplementation.createCSSEngine(sVGOMDocument, this);
            sVGOMDocument.setCSSEngine(cSSEngine);
            cSSEngine.setMedia(this.userAgent.getMedia());
            String string = this.userAgent.getUserStyleSheetURI();
            if (string != null) {
                try {
                    URL uRL = new URL(string);
                    cSSEngine.setUserAgentStyleSheet(cSSEngine.parseStyleSheet(uRL, "all"));
                }
                catch (MalformedURLException malformedURLException) {
                    this.userAgent.displayError(malformedURLException);
                }
            }
            cSSEngine.setAlternateStyleSheet(this.userAgent.getAlternateStyleSheet());
        }
    }

    public void setTextPainter(TextPainter textPainter) {
        this.textPainter = textPainter;
    }

    public TextPainter getTextPainter() {
        return this.textPainter;
    }

    public Document getDocument() {
        return this.document;
    }

    protected void setDocument(Document document) {
        if (this.document != document) {
            this.fontFamilyMap = null;
        }
        this.document = document;
    }

    public Map getFontFamilyMap() {
        if (this.fontFamilyMap == null) {
            this.fontFamilyMap = new HashMap();
        }
        return this.fontFamilyMap;
    }

    protected void setFontFamilyMap(Map map) {
        this.fontFamilyMap = map;
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    protected void setUserAgent(UserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public GVTBuilder getGVTBuilder() {
        return this.gvtBuilder;
    }

    protected void setGVTBuilder(GVTBuilder gVTBuilder) {
        this.gvtBuilder = gVTBuilder;
    }

    public InterpreterPool getInterpreterPool() {
        return this.interpreterPool;
    }

    public FocusManager getFocusManager() {
        return this.focusManager;
    }

    protected void setInterpreterPool(InterpreterPool interpreterPool) {
        this.interpreterPool = interpreterPool;
    }

    public Interpreter getInterpreter(String string) {
        if (this.document == null) {
            throw new RuntimeException("Unknown document");
        }
        Interpreter interpreter = (Interpreter)this.interpreterMap.get(string);
        if (interpreter == null) {
            interpreter = this.interpreterPool.createInterpreter(this.document, string);
            this.interpreterMap.put(string, interpreter);
        }
        return interpreter;
    }

    public DocumentLoader getDocumentLoader() {
        return this.documentLoader;
    }

    protected void setDocumentLoader(DocumentLoader documentLoader) {
        this.documentLoader = documentLoader;
    }

    public Dimension2D getDocumentSize() {
        return this.documentSize;
    }

    protected void setDocumentSize(Dimension2D dimension2D) {
        this.documentSize = dimension2D;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean bl) {
        this.dynamic = bl;
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    protected void setUpdateManager(UpdateManager updateManager) {
        this.updateManager = updateManager;
    }

    public Element getReferencedElement(Element element, String string) {
        try {
            SVGDocument sVGDocument = (SVGDocument)element.getOwnerDocument();
            URIResolver uRIResolver = new URIResolver(sVGDocument, this.documentLoader);
            Element element2 = uRIResolver.getElement(string, element);
            if (element2 == null) {
                throw new BridgeException(element, "uri.badTarget", new Object[]{string});
            }
            return element2;
        }
        catch (MalformedURLException malformedURLException) {
            throw new BridgeException(element, "uri.malformed", new Object[]{string});
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedBridgeException();
        }
        catch (IOException iOException) {
            throw new BridgeException(element, "uri.io", new Object[]{string});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BridgeException(element, "uri.referenceDocument", new Object[]{string});
        }
        catch (SecurityException securityException) {
            throw new BridgeException(element, "uri.unsecure", new Object[]{string});
        }
    }

    public Viewport getViewport(Element element) {
        if (this.viewportStack != null) {
            if (this.viewportStack.size() == 0) {
                return (Viewport)this.viewportMap.get(this.userAgent);
            }
            return (Viewport)this.viewportStack.get(0);
        }
        element = SVGUtilities.getParentElement(element);
        while (element != null) {
            Viewport viewport = (Viewport)this.viewportMap.get(element);
            if (viewport != null) {
                return viewport;
            }
            element = SVGUtilities.getParentElement(element);
        }
        return (Viewport)this.viewportMap.get(this.userAgent);
    }

    public void openViewport(Element element, Viewport viewport) {
        this.viewportMap.put(element, viewport);
        if (this.viewportStack == null) {
            this.viewportStack = new LinkedList();
        }
        this.viewportStack.add(0, viewport);
    }

    public void closeViewport(Element element) {
        this.viewportStack.remove(0);
        if (this.viewportStack.size() == 0) {
            this.viewportStack = null;
        }
    }

    public void bind(Element element, GraphicsNode graphicsNode) {
        if (this.elementNodeMap == null) {
            this.elementNodeMap = new HashMap();
            this.nodeElementMap = new HashMap();
        }
        this.elementNodeMap.put(element, graphicsNode);
        this.nodeElementMap.put(graphicsNode, element);
    }

    public void unbind(Element element) {
        if (this.elementNodeMap == null) {
            return;
        }
        GraphicsNode graphicsNode = (GraphicsNode)this.elementNodeMap.get(element);
        this.elementNodeMap.remove(element);
        this.nodeElementMap.remove(graphicsNode);
    }

    public GraphicsNode getGraphicsNode(Element element) {
        if (this.elementNodeMap != null) {
            return (GraphicsNode)this.elementNodeMap.get(element);
        }
        return null;
    }

    public Element getElement(GraphicsNode graphicsNode) {
        if (this.nodeElementMap != null) {
            return (Element)this.nodeElementMap.get(graphicsNode);
        }
        return null;
    }

    public Bridge getBridge(Element element) {
        if (this.namespaceURIMap == null || element == null) {
            return null;
        }
        String string = element.getNamespaceURI();
        String string2 = element.getLocalName();
        HashMap hashMap = (HashMap)this.namespaceURIMap.get(string = string == null ? "" : string);
        if (hashMap == null) {
            return null;
        }
        Bridge bridge = (Bridge)hashMap.get(string2);
        if (this.dynamic) {
            return bridge == null ? null : bridge.getInstance();
        }
        return bridge;
    }

    public boolean hasGraphicsNodeBridge(Element element) {
        if (this.namespaceURIMap == null || element == null) {
            return false;
        }
        String string = element.getNamespaceURI();
        String string2 = element.getLocalName();
        HashMap hashMap = (HashMap)this.namespaceURIMap.get(string = string == null ? "" : string);
        if (hashMap == null) {
            return false;
        }
        return hashMap.get(string2) instanceof GraphicsNodeBridge;
    }

    public Bridge getBridge(String string, String string2) {
        HashMap hashMap = (HashMap)this.namespaceURIMap.get(string);
        if (hashMap == null) {
            return null;
        }
        Bridge bridge = (Bridge)hashMap.get(string2);
        if (this.dynamic) {
            return bridge == null ? null : bridge.getInstance();
        }
        return bridge;
    }

    public void putBridge(String string, String string2, Bridge bridge) {
        HashMap<String, Bridge> hashMap;
        if (!string.equals(bridge.getNamespaceURI()) || !string2.equals(bridge.getLocalName())) {
            throw new Error("Invalid Bridge: " + string + "/" + bridge.getNamespaceURI() + " " + string2 + "/" + bridge.getLocalName() + " " + bridge.getClass());
        }
        if (this.namespaceURIMap == null) {
            this.namespaceURIMap = new HashMap();
        }
        if ((hashMap = (HashMap<String, Bridge>)this.namespaceURIMap.get(string = string == null ? "" : string)) == null) {
            hashMap = new HashMap<String, Bridge>();
            this.namespaceURIMap.put(string, hashMap);
        }
        hashMap.put(string2, bridge);
    }

    public void putBridge(Bridge bridge) {
        this.putBridge(bridge.getNamespaceURI(), bridge.getLocalName(), bridge);
    }

    public void removeBridge(String string, String string2) {
        if (this.namespaceURIMap == null) {
            return;
        }
        HashMap hashMap = (HashMap)this.namespaceURIMap.get(string = string == null ? "" : string);
        if (hashMap != null) {
            hashMap.remove(string2);
            if (hashMap.isEmpty()) {
                this.namespaceURIMap.remove(string);
                if (this.namespaceURIMap.isEmpty()) {
                    this.namespaceURIMap = null;
                }
            }
        }
    }

    public void addDOMListeners() {
        EventTarget eventTarget = (EventTarget)((Object)this.document);
        this.domAttrModifiedEventListener = new DOMAttrModifiedEventListener();
        eventTarget.addEventListener("DOMAttrModified", this.domAttrModifiedEventListener, true);
        this.domNodeInsertedEventListener = new DOMNodeInsertedEventListener();
        eventTarget.addEventListener("DOMNodeInserted", this.domNodeInsertedEventListener, true);
        this.domNodeRemovedEventListener = new DOMNodeRemovedEventListener();
        eventTarget.addEventListener("DOMNodeRemoved", this.domNodeRemovedEventListener, true);
        this.domCharacterDataModifiedListener = new DOMCharacterDataModifiedListener();
        eventTarget.addEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, true);
        this.focusManager = new FocusManager(this.document);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)this.document;
        CSSEngine cSSEngine = sVGOMDocument.getCSSEngine();
        this.cssPropertiesChangedListener = new CSSPropertiesChangedListener();
        cSSEngine.addCSSEngineListener(this.cssPropertiesChangedListener);
    }

    protected void storeEventListener(EventTarget eventTarget, String string, EventListener eventListener, boolean bl) {
        this.eventListenerList.add(new EventListenerMememto(eventTarget, string, eventListener, bl));
    }

    public void dispose() {
        Object object;
        Iterator iterator = this.eventListenerList.iterator();
        while (iterator.hasNext()) {
            object = (EventListenerMememto)iterator.next();
            ((EventListenerMememto)object).target.removeEventListener(((EventListenerMememto)object).eventType, ((EventListenerMememto)object).listener, ((EventListenerMememto)object).useCapture);
        }
        object = (EventTarget)((Object)this.document);
        object.removeEventListener("DOMAttrModified", this.domAttrModifiedEventListener, true);
        object.removeEventListener("DOMNodeInserted", this.domNodeInsertedEventListener, true);
        object.removeEventListener("DOMNodeRemoved", this.domNodeRemovedEventListener, true);
        object.removeEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, true);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)this.document;
        CSSEngine cSSEngine = sVGOMDocument.getCSSEngine();
        if (cSSEngine != null) {
            cSSEngine.removeCSSEngineListener(this.cssPropertiesChangedListener);
            cSSEngine.dispose();
        }
        if (this.focusManager != null) {
            this.focusManager.dispose();
        }
    }

    protected static SVGContext getSVGContext(Node node) {
        if (node instanceof SVGOMElement) {
            return ((SVGOMElement)node).getSVGContext();
        }
        return null;
    }

    protected static BridgeUpdateHandler getBridgeUpdateHandler(Node node) {
        SVGContext sVGContext = BridgeContext.getSVGContext(node);
        return sVGContext == null ? null : (BridgeUpdateHandler)((Object)sVGContext);
    }

    public Value getSystemColor(String string) {
        return SystemColorSupport.getSystemColor(string);
    }

    public float getLighterFontWeight(float f) {
        return this.userAgent.getLighterFontWeight(f);
    }

    public float getBolderFontWeight(float f) {
        return this.userAgent.getBolderFontWeight(f);
    }

    public float getPixelUnitToMillimeter() {
        return this.userAgent.getPixelUnitToMillimeter();
    }

    public float getPixelToMillimeter() {
        return this.getPixelUnitToMillimeter();
    }

    public float getMediumFontSize() {
        return this.userAgent.getMediumFontSize();
    }

    public float getBlockWidth(Element element) {
        return this.getViewport(element).getWidth();
    }

    public float getBlockHeight(Element element) {
        return this.getViewport(element).getHeight();
    }

    public void checkLoadExternalResource(ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
        this.userAgent.checkLoadExternalResource(parsedURL, parsedURL2);
    }

    public static void registerSVGBridges(BridgeContext bridgeContext) {
        UserAgent userAgent = bridgeContext.getUserAgent();
        Iterator iterator = BridgeContext.getBridgeExtensions().iterator();
        while (iterator.hasNext()) {
            BridgeExtension bridgeExtension = (BridgeExtension)iterator.next();
            bridgeExtension.registerTags(bridgeContext);
            userAgent.registerExtension(bridgeExtension);
        }
    }

    public static synchronized List getBridgeExtensions() {
        if (extensions != null) {
            return extensions;
        }
        extensions = new LinkedList();
        extensions.add(new SVGBridgeExtension());
        Iterator iterator = Service.providers(class$org$apache$batik$bridge$BridgeExtension == null ? (class$org$apache$batik$bridge$BridgeExtension = BridgeContext.class$("org.apache.batik.bridge.BridgeExtension")) : class$org$apache$batik$bridge$BridgeExtension);
        block0: while (iterator.hasNext()) {
            BridgeExtension bridgeExtension;
            BridgeExtension bridgeExtension2 = (BridgeExtension)iterator.next();
            float f = bridgeExtension2.getPriority();
            ListIterator<BridgeExtension> listIterator = extensions.listIterator();
            do {
                if (listIterator.hasNext()) continue;
                listIterator.add(bridgeExtension2);
                continue block0;
            } while (!((bridgeExtension = (BridgeExtension)listIterator.next()).getPriority() > f));
            listIterator.previous();
            listIterator.add(bridgeExtension2);
        }
        return extensions;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class CSSPropertiesChangedListener
    implements CSSEngineListener {
        protected CSSPropertiesChangedListener() {
        }

        public void propertiesChanged(CSSEngineEvent cSSEngineEvent) {
            SVGContext sVGContext = BridgeContext.getSVGContext(cSSEngineEvent.getElement());
            if (sVGContext != null && sVGContext instanceof BridgeUpdateHandler) {
                ((BridgeUpdateHandler)((Object)sVGContext)).handleCSSEngineEvent(cSSEngineEvent);
            }
        }
    }

    protected class DOMCharacterDataModifiedListener
    implements EventListener {
        protected DOMCharacterDataModifiedListener() {
        }

        public void handleEvent(Event event) {
            Node node = (Node)((Object)event.getTarget());
            while (node != null && !(node instanceof SVGOMElement)) {
                node = node.getParentNode();
            }
            BridgeUpdateHandler bridgeUpdateHandler = BridgeContext.getBridgeUpdateHandler(node);
            if (bridgeUpdateHandler != null) {
                try {
                    bridgeUpdateHandler.handleDOMCharacterDataModified((MutationEvent)event);
                }
                catch (Exception exception) {
                    BridgeContext.this.userAgent.displayError(exception);
                }
            }
        }
    }

    protected class DOMNodeRemovedEventListener
    implements EventListener {
        protected DOMNodeRemovedEventListener() {
        }

        public void handleEvent(Event event) {
            Node node = (Node)((Object)event.getTarget());
            BridgeUpdateHandler bridgeUpdateHandler = BridgeContext.getBridgeUpdateHandler(node);
            if (bridgeUpdateHandler != null) {
                try {
                    bridgeUpdateHandler.handleDOMNodeRemovedEvent((MutationEvent)event);
                }
                catch (Exception exception) {
                    BridgeContext.this.userAgent.displayError(exception);
                }
            }
        }
    }

    protected class DOMNodeInsertedEventListener
    implements EventListener {
        protected DOMNodeInsertedEventListener() {
        }

        public void handleEvent(Event event) {
            MutationEvent mutationEvent = (MutationEvent)event;
            BridgeUpdateHandler bridgeUpdateHandler = BridgeContext.getBridgeUpdateHandler(mutationEvent.getRelatedNode());
            if (bridgeUpdateHandler != null) {
                try {
                    bridgeUpdateHandler.handleDOMNodeInsertedEvent(mutationEvent);
                }
                catch (Exception exception) {
                    BridgeContext.this.userAgent.displayError(exception);
                }
            }
        }
    }

    protected class DOMAttrModifiedEventListener
    implements EventListener {
        protected DOMAttrModifiedEventListener() {
        }

        public void handleEvent(Event event) {
            Node node = (Node)((Object)event.getTarget());
            BridgeUpdateHandler bridgeUpdateHandler = BridgeContext.getBridgeUpdateHandler(node);
            if (bridgeUpdateHandler != null) {
                try {
                    bridgeUpdateHandler.handleDOMAttrModifiedEvent((MutationEvent)event);
                }
                catch (Exception exception) {
                    BridgeContext.this.userAgent.displayError(exception);
                }
            }
        }
    }

    protected static class EventListenerMememto {
        public EventTarget target;
        public EventListener listener;
        public boolean useCapture;
        public String eventType;

        public EventListenerMememto(EventTarget eventTarget, String string, EventListener eventListener, boolean bl) {
            this.target = eventTarget;
            this.eventType = string;
            this.listener = eventListener;
            this.useCapture = bl;
        }
    }
}

