/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public class SVGGElementBridge
extends AbstractGraphicsNodeBridge {
    public String getLocalName() {
        return "g";
    }

    public Bridge getInstance() {
        return new SVGGElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        Rectangle2D rectangle2D;
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)super.createGraphicsNode(bridgeContext, element);
        if (compositeGraphicsNode == null) {
            return null;
        }
        RenderingHints renderingHints = CSSUtilities.convertColorRendering(element, null);
        if (renderingHints != null) {
            compositeGraphicsNode.setRenderingHints(renderingHints);
        }
        if ((rectangle2D = CSSUtilities.convertEnableBackground(element)) != null) {
            compositeGraphicsNode.setBackgroundEnable(rectangle2D);
        }
        return compositeGraphicsNode;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new CompositeGraphicsNode();
    }

    public boolean isComposite() {
        return true;
    }

    public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
        this.handleElementAdded((CompositeGraphicsNode)this.node, this.e, (Element)((Object)mutationEvent.getTarget()));
    }

    public void handleElementAdded(CompositeGraphicsNode compositeGraphicsNode, Node node, Element element) {
        GVTBuilder gVTBuilder = this.ctx.getGVTBuilder();
        GraphicsNode graphicsNode = gVTBuilder.build(this.ctx, element);
        if (graphicsNode == null) {
            return;
        }
        Node node2 = node.getFirstChild();
        Node node3 = node.getLastChild();
        if (node2 == element) {
            compositeGraphicsNode.add(0, graphicsNode);
        } else if (node3 == element) {
            compositeGraphicsNode.add(graphicsNode);
        } else {
            int n = 0;
            while (node2 != node3 && node2 != element) {
                if (node2.getNodeType() == 1 && this.ctx.hasGraphicsNodeBridge((Element)node2)) {
                    ++n;
                }
                node2 = node2.getNextSibling();
            }
            compositeGraphicsNode.add(n, graphicsNode);
        }
    }
}

