/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.AltGlyphHandler;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.font.MultiGlyphVector;
import org.apache.batik.gvt.text.ArabicTextHandler;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.GlyphIterator;
import org.apache.batik.gvt.text.LineInfo;
import org.apache.batik.gvt.text.MarginInfo;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.gvt.text.TextSpanLayout;

public class GlyphLayout
implements TextSpanLayout {
    private GVTGlyphVector gv;
    private GVTFont font;
    private GVTLineMetrics metrics;
    private AttributedCharacterIterator aci;
    private FontRenderContext frc;
    private Point2D advance;
    private Point2D offset;
    private float xScale = 1.0f;
    private float yScale = 1.0f;
    private Point2D prevCharPosition;
    private TextPath textPath;
    private Point2D textPathAdvance;
    private int[] charMap;
    private boolean vertical;
    private boolean adjSpacing = true;
    private boolean layoutApplied = false;
    private boolean spacingApplied = false;
    private boolean pathApplied = false;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_EMPTY_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_EMPTY_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_DELIMITER = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER;
    private static final AttributedCharacterIterator.Attribute X = GVTAttributedCharacterIterator.TextAttribute.X;
    private static final AttributedCharacterIterator.Attribute Y = GVTAttributedCharacterIterator.TextAttribute.Y;
    private static final AttributedCharacterIterator.Attribute DX = GVTAttributedCharacterIterator.TextAttribute.DX;
    private static final AttributedCharacterIterator.Attribute DY = GVTAttributedCharacterIterator.TextAttribute.DY;
    private static final AttributedCharacterIterator.Attribute ROTATION = GVTAttributedCharacterIterator.TextAttribute.ROTATION;
    private static final AttributedCharacterIterator.Attribute BASELINE_SHIFT = GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT;
    private static final AttributedCharacterIterator.Attribute WRITING_MODE = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE;
    private static final Integer WRITING_MODE_TTB = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB;
    static Set runAtts = new HashSet();
    static Set szAtts;
    public static final float eps = 1.0E-5f;

    public GlyphLayout(AttributedCharacterIterator attributedCharacterIterator, int[] nArray, Point2D point2D, FontRenderContext fontRenderContext) {
        this.aci = attributedCharacterIterator;
        this.frc = fontRenderContext;
        this.offset = point2D;
        this.font = this.getFont();
        this.charMap = nArray;
        this.metrics = this.font.getLineMetrics(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), fontRenderContext);
        this.gv = null;
        this.aci.first();
        this.vertical = attributedCharacterIterator.getAttribute(WRITING_MODE) == WRITING_MODE_TTB;
        this.textPath = (TextPath)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH);
        AltGlyphHandler altGlyphHandler = (AltGlyphHandler)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER);
        if (altGlyphHandler != null) {
            this.gv = altGlyphHandler.createGlyphVector(fontRenderContext, this.font.getSize(), this.aci);
        }
        if (this.gv == null) {
            this.gv = this.font.createGlyphVector(fontRenderContext, this.aci);
        }
    }

    GVTGlyphVector getGlyphVector() {
        return this.gv;
    }

    public Point2D getOffset() {
        return this.offset;
    }

    public void setScale(float f, float f2, boolean bl) {
        if (this.vertical) {
            f = 1.0f;
        } else {
            f2 = 1.0f;
        }
        if (f != this.xScale || f2 != this.yScale || bl != this.adjSpacing) {
            this.xScale = f;
            this.yScale = f2;
            this.adjSpacing = bl;
            this.spacingApplied = false;
            this.pathApplied = false;
        }
    }

    public void setOffset(Point2D point2D) {
        if (point2D.getX() != this.offset.getX() || point2D.getY() != this.offset.getY()) {
            if (this.layoutApplied || this.spacingApplied) {
                float f = (float)(point2D.getX() - this.offset.getX());
                float f2 = (float)(point2D.getY() - this.offset.getY());
                int n = this.gv.getNumGlyphs();
                float[] fArray = this.gv.getGlyphPositions(0, n + 1, null);
                int n2 = 0;
                while (n2 <= n) {
                    this.gv.setGlyphPosition(n2, new Point2D.Float(fArray[2 * n2] + f, fArray[2 * n2 + 1] + f2));
                    ++n2;
                }
            }
            this.offset = point2D;
            this.pathApplied = false;
        }
    }

    public GVTGlyphMetrics getGlyphMetrics(int n) {
        return this.gv.getGlyphMetrics(n);
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public boolean isOnATextPath() {
        return this.textPath != null;
    }

    public int getGlyphCount() {
        return this.gv.getNumGlyphs();
    }

    public int getCharacterCount(int n, int n2) {
        return this.gv.getCharacterCount(n, n2);
    }

    public boolean isLeftToRight() {
        this.aci.first();
        int n = (Integer)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL);
        return (n & 1) == 0;
    }

    private final void syncLayout() {
        if (!this.pathApplied) {
            this.doPathLayout();
        }
    }

    public void draw(Graphics2D graphics2D) {
        this.syncLayout();
        this.gv.draw(graphics2D, this.aci);
    }

    public Point2D getAdvance2D() {
        this.adjustTextSpacing();
        return this.advance;
    }

    public Shape getOutline() {
        this.syncLayout();
        return this.gv.getOutline();
    }

    public Shape getDecorationOutline(int n) {
        this.syncLayout();
        GeneralPath generalPath = new GeneralPath();
        if ((n & 1) != 0) {
            generalPath.append(this.getUnderlineShape(), false);
        }
        if ((n & 2) != 0) {
            generalPath.append(this.getStrikethroughShape(), false);
        }
        if ((n & 4) != 0) {
            generalPath.append(this.getOverlineShape(), false);
        }
        return generalPath;
    }

    public Rectangle2D getBounds2D() {
        this.syncLayout();
        return this.gv.getBounds2D(this.aci);
    }

    public Rectangle2D getGeometricBounds() {
        this.syncLayout();
        Rectangle2D rectangle2D = this.gv.getGeometricBounds();
        Rectangle2D rectangle2D2 = this.getDecorationOutline(7).getBounds2D();
        return rectangle2D.createUnion(rectangle2D2);
    }

    public Point2D getTextPathAdvance() {
        this.syncLayout();
        if (this.textPath != null) {
            return this.textPathAdvance;
        }
        return this.getAdvance2D();
    }

    public int getGlyphIndex(int n) {
        int n2 = this.getGlyphCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.getCharacterCount(n4, n4);
            int n6 = 0;
            while (n6 < n5) {
                int n7;
                if (n == (n7 = this.charMap[n3++])) {
                    return n4;
                }
                if (n3 >= this.charMap.length) {
                    return -1;
                }
                ++n6;
            }
            ++n4;
        }
        return -1;
    }

    public Shape getHighlightShape(int n, int n2) {
        this.syncLayout();
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        GeneralPath generalPath = null;
        int n4 = this.aci.getBeginIndex();
        int n5 = this.getGlyphCount();
        boolean bl = this.isGlyphOrientationAuto();
        int n6 = 90;
        if (!bl) {
            n6 = this.getGlyphOrientationAngle();
        }
        Point2D.Float[] floatArray = new Point2D.Float[2 * n5];
        Point2D.Float[] floatArray2 = new Point2D.Float[2 * n5];
        int n7 = 0;
        int n8 = n4;
        int n9 = 0;
        while (n9 < n5) {
            Shape shape;
            char c = this.aci.setIndex(n8);
            int n10 = this.charMap[n8 - n4];
            if (n10 >= n && n10 <= n2 && this.gv.isGlyphVisible(n9) && (shape = this.gv.getGlyphLogicalBounds(n9)) != null) {
                if (generalPath == null) {
                    generalPath = new GeneralPath();
                }
                float[] fArray = new float[6];
                int n11 = 0;
                int n12 = -1;
                PathIterator pathIterator = shape.getPathIterator(null);
                Point2D.Float float_ = null;
                if (this.isVertical() && bl) {
                    n6 = this.isLatinChar(c) ? 90 : 0;
                }
                while (!pathIterator.isDone()) {
                    n12 = pathIterator.currentSegment(fArray);
                    if (n12 == 0 || n12 == 1) {
                        if (n11 > 4) break;
                        if (n11 == 4) {
                            if (float_ == null || float_.x != fArray[0] || float_.y != fArray[1]) {
                                break;
                            }
                        } else {
                            Point2D.Float float_2 = new Point2D.Float(fArray[0], fArray[1]);
                            if (n11 == 0) {
                                float_ = float_2;
                            }
                            switch (n11) {
                                case 0: {
                                    floatArray2[n7] = float_2;
                                    break;
                                }
                                case 1: {
                                    floatArray[n7] = float_2;
                                    break;
                                }
                                case 2: {
                                    floatArray[n7 + 1] = float_2;
                                    break;
                                }
                                case 3: {
                                    floatArray2[n7 + 1] = float_2;
                                }
                            }
                        }
                    } else if (n12 != 4 || n11 < 4 || n11 > 5) break;
                    ++n11;
                    pathIterator.next();
                }
                if (pathIterator.isDone()) {
                    if (floatArray2[n7] != null && (floatArray[n7].x != floatArray[n7 + 1].x || floatArray[n7].y != floatArray[n7 + 1].y)) {
                        n7 += 2;
                    }
                } else {
                    GlyphLayout.addPtsToPath(generalPath, floatArray, floatArray2, n7);
                    n7 = 0;
                    generalPath.append(shape, false);
                }
            }
            n8 += this.getCharacterCount(n9, n9);
            ++n9;
        }
        GlyphLayout.addPtsToPath(generalPath, floatArray, floatArray2, n7);
        return generalPath;
    }

    /*
     * Unable to fully structure code
     */
    public static int makeConvexHull(Point2D.Float[] var0, int var1_1) {
        var3_2 = 1;
        while (var3_2 < var1_1) {
            if (var0[var3_2].x < var0[var3_2 - 1].x || var0[var3_2].x == var0[var3_2 - 1].x && var0[var3_2].y < var0[var3_2 - 1].y) {
                var2_3 = var0[var3_2];
                var0[var3_2] = var0[var3_2 - 1];
                var0[var3_2 - 1] = var2_3;
                var3_2 = 0;
            }
            ++var3_2;
        }
        var4_4 = var0[0];
        var5_5 = var0[var1_1 - 1];
        var6_6 = new Point2D.Float(var5_5.x - var4_4.x, var5_5.y - var4_4.y);
        var8_7 = var6_6.y * var4_4.x - var6_6.x * var4_4.y;
        var9_8 = new Point2D.Float[var1_1];
        var10_9 = new Point2D.Float[var1_1];
        var10_9[0] = var9_8[0] = var0[0];
        var11_10 = 1;
        var12_11 = 1;
        var13_12 = 1;
        while (var13_12 < var1_1 - 1) {
            block13: {
                var14_14 = var0[var13_12];
                var7_13 = var6_6.x * var14_14.y - var6_6.y * var14_14.x + var8_7;
                if (!(var7_13 < 0.0f)) ** GOTO lbl54
                while (var12_11 >= 2) {
                    var4_4 = var10_9[var12_11 - 2];
                    var5_5 = var10_9[var12_11 - 1];
                    var15_15 = var5_5.x - var4_4.x;
                    var16_17 = var5_5.y - var4_4.y;
                    var17_19 = var16_17 * var4_4.x - var15_15 * var4_4.y;
                    var7_13 = var15_15 * var14_14.y - var16_17 * var14_14.x + var17_19;
                    if (var7_13 > 1.0E-5f) break;
                    if (var7_13 > -1.0E-5f) {
                        if (!(var5_5.y < var14_14.y)) break;
                        var14_14 = var5_5;
                        break;
                    }
                    --var12_11;
                }
                v0 = --var12_11;
                ++var12_11;
                var10_9[v0] = var14_14;
                break block13;
lbl-1000:
                // 1 sources

                {
                    var4_4 = var9_8[var11_10 - 2];
                    var5_5 = var9_8[var11_10 - 1];
                    var15_15 = var5_5.x - var4_4.x;
                    var16_17 = var5_5.y - var4_4.y;
                    var17_19 = var16_17 * var4_4.x - var15_15 * var4_4.y;
                    var7_13 = var15_15 * var14_14.y - var16_17 * var14_14.x + var17_19;
                    if (var7_13 < -1.0E-5f) break;
                    if (var7_13 < 1.0E-5f) {
                        if (!(var5_5.y > var14_14.y)) break;
                        var14_14 = var5_5;
                        break;
                    }
                    --var11_10;
lbl54:
                    // 2 sources

                    ** while (var11_10 >= 2)
                }
lbl55:
                // 4 sources

                v1 = --var11_10;
                ++var11_10;
                var9_8[v1] = var14_14;
            }
            ++var13_12;
        }
        var14_14 = var0[var1_1 - 1];
        while (var12_11 >= 2) {
            var4_4 = var10_9[var12_11 - 2];
            var5_5 = var10_9[var12_11 - 1];
            var15_15 = var5_5.x - var4_4.x;
            var16_17 = var5_5.y - var4_4.y;
            var17_19 = var16_17 * var4_4.x - var15_15 * var4_4.y;
            var7_13 = var15_15 * var14_14.y - var16_17 * var14_14.x + var17_19;
            if (var7_13 > 1.0E-5f) break;
            if (var7_13 > -1.0E-5f) {
                if (!(var5_5.y >= var14_14.y)) break;
                --var12_11;
                break;
            }
            --var12_11;
        }
        while (var11_10 >= 2) {
            var4_4 = var9_8[var11_10 - 2];
            var5_5 = var9_8[var11_10 - 1];
            var15_15 = var5_5.x - var4_4.x;
            var16_17 = var5_5.y - var4_4.y;
            var17_19 = var16_17 * var4_4.x - var15_15 * var4_4.y;
            var7_13 = var15_15 * var14_14.y - var16_17 * var14_14.x + var17_19;
            if (var7_13 < -1.0E-5f) break;
            if (var7_13 < 1.0E-5f) {
                if (!(var5_5.y <= var14_14.y)) break;
                --var11_10;
                break;
            }
            --var11_10;
        }
        var15_16 = 0;
        while (var15_16 < var11_10) {
            var0[var15_16] = var9_8[var15_16];
            ++var15_16;
        }
        var0[var15_16++] = var0[var1_1 - 1];
        var16_18 = var12_11 - 1;
        while (var16_18 > 0) {
            var0[var15_16] = var10_9[var16_18];
            --var16_18;
            ++var15_16;
        }
        return var15_16;
    }

    public static void addPtsToPath(GeneralPath generalPath, Point2D.Float[] floatArray, Point2D.Float[] floatArray2, int n) {
        if (n < 2) {
            return;
        }
        if (n == 2) {
            generalPath.moveTo(floatArray[0].x, floatArray[0].y);
            generalPath.lineTo(floatArray[1].x, floatArray[1].y);
            generalPath.lineTo(floatArray2[1].x, floatArray2[1].y);
            generalPath.lineTo(floatArray2[0].x, floatArray2[0].y);
            generalPath.lineTo(floatArray[0].x, floatArray[0].y);
            return;
        }
        Point2D.Float[] floatArray3 = new Point2D.Float[8];
        Point2D.Float[] floatArray4 = new Point2D.Float[8];
        floatArray3[4] = floatArray[0];
        floatArray3[5] = floatArray[1];
        floatArray3[6] = floatArray2[1];
        floatArray3[7] = floatArray2[0];
        Area[] areaArray = new Area[n / 2];
        int n2 = 0;
        int n3 = 2;
        while (n3 < n) {
            floatArray3[0] = floatArray3[4];
            floatArray3[1] = floatArray3[5];
            floatArray3[2] = floatArray3[6];
            floatArray3[3] = floatArray3[7];
            floatArray3[4] = floatArray[n3];
            floatArray3[5] = floatArray[n3 + 1];
            floatArray3[6] = floatArray2[n3 + 1];
            floatArray3[7] = floatArray2[n3];
            float f = floatArray3[2].x - floatArray3[0].x;
            float f2 = f * f;
            f = floatArray3[2].y - floatArray3[0].y;
            float f3 = (float)Math.sqrt(f2 += f * f);
            f = floatArray3[6].x - floatArray3[4].x;
            f2 = f * f;
            f = floatArray3[6].y - floatArray3[4].y;
            f3 += (float)Math.sqrt(f2 += f * f);
            f = (floatArray3[0].x + floatArray3[1].x + floatArray3[2].x + floatArray3[3].x - (floatArray3[4].x + floatArray3[5].x + floatArray3[6].x + floatArray3[7].x)) / 4.0f;
            f2 = f * f;
            f = (floatArray3[0].y + floatArray3[1].y + floatArray3[2].y + floatArray3[3].y - (floatArray3[4].y + floatArray3[5].y + floatArray3[6].y + floatArray3[7].y)) / 4.0f;
            f2 += f * f;
            f2 = (float)Math.sqrt(f2);
            GeneralPath generalPath2 = new GeneralPath();
            if (f2 < f3) {
                System.arraycopy(floatArray3, 0, floatArray4, 0, 8);
                int n4 = GlyphLayout.makeConvexHull(floatArray4, 8);
                generalPath2.moveTo(floatArray4[0].x, floatArray4[0].y);
                int n5 = 1;
                while (n5 < n4) {
                    generalPath2.lineTo(floatArray4[n5].x, floatArray4[n5].y);
                    ++n5;
                }
                generalPath2.closePath();
            } else {
                GlyphLayout.mergeAreas(generalPath, areaArray, n2);
                n2 = 0;
                if (n3 == 2) {
                    generalPath2.moveTo(floatArray3[0].x, floatArray3[0].y);
                    generalPath2.lineTo(floatArray3[1].x, floatArray3[1].y);
                    generalPath2.lineTo(floatArray3[2].x, floatArray3[2].y);
                    generalPath2.lineTo(floatArray3[3].x, floatArray3[3].y);
                    generalPath2.closePath();
                    generalPath.append(generalPath2, false);
                    generalPath2.reset();
                }
                generalPath2.moveTo(floatArray3[4].x, floatArray3[4].y);
                generalPath2.lineTo(floatArray3[5].x, floatArray3[5].y);
                generalPath2.lineTo(floatArray3[6].x, floatArray3[6].y);
                generalPath2.lineTo(floatArray3[7].x, floatArray3[7].y);
                generalPath2.closePath();
            }
            areaArray[n2++] = new Area(generalPath2);
            n3 += 2;
        }
        GlyphLayout.mergeAreas(generalPath, areaArray, n2);
    }

    public static void mergeAreas(GeneralPath generalPath, Area[] areaArray, int n) {
        while (n > 1) {
            int n2 = 0;
            int n3 = 1;
            while (n3 < n) {
                areaArray[n3 - 1].add(areaArray[n3]);
                areaArray[n2++] = areaArray[n3 - 1];
                areaArray[n3] = null;
                n3 += 2;
            }
            if ((n & 1) == 1) {
                areaArray[n2 - 1].add(areaArray[n - 1]);
            }
            n /= 2;
        }
        if (n == 1) {
            generalPath.append(areaArray[0], false);
        }
    }

    public TextHit hitTestChar(float f, float f2) {
        this.syncLayout();
        TextHit textHit = null;
        int n = 0;
        int n2 = 0;
        while (n2 < this.gv.getNumGlyphs()) {
            Shape shape = this.gv.getGlyphLogicalBounds(n2);
            if (shape != null) {
                Rectangle2D rectangle2D = shape.getBounds2D();
                if (shape.contains(f, f2)) {
                    boolean bl = (double)f > rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                    boolean bl2 = !bl;
                    int n3 = this.charMap[n];
                    textHit = new TextHit(n3, bl2);
                    return textHit;
                }
            }
            n += this.getCharacterCount(n2, n2);
            ++n2;
        }
        return textHit;
    }

    protected GVTFont getFont() {
        this.aci.first();
        GVTFont gVTFont = (GVTFont)this.aci.getAttributes().get(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT);
        if (gVTFont != null) {
            return gVTFont;
        }
        return new AWTGVTFont(this.aci.getAttributes());
    }

    protected Shape getOverlineShape() {
        double d = this.metrics.getOverlineOffset();
        float f = this.metrics.getOverlineThickness();
        BasicStroke basicStroke = new BasicStroke(f);
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f / 2.0, this.offset.getY() + (d += (double)f), rectangle2D.getMaxX() - (double)f / 2.0, this.offset.getY() + d));
    }

    protected Shape getUnderlineShape() {
        double d = this.metrics.getUnderlineOffset();
        float f = this.metrics.getUnderlineThickness();
        BasicStroke basicStroke = new BasicStroke(f);
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f / 2.0, this.offset.getY() + (d += (double)f * 1.5), rectangle2D.getMaxX() - (double)f / 2.0, this.offset.getY() + d));
    }

    protected Shape getStrikethroughShape() {
        double d = this.metrics.getStrikethroughOffset();
        float f = this.metrics.getStrikethroughThickness();
        BasicStroke basicStroke = new BasicStroke(f);
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f / 2.0, this.offset.getY() + d, rectangle2D.getMaxX() - (double)f / 2.0, this.offset.getY() + d));
    }

    protected void doExplicitGlyphLayout() {
        this.gv.performDefaultLayout();
        float f = this.vertical ? (float)this.gv.getLogicalBounds().getWidth() : this.metrics.getAscent() + Math.abs(this.metrics.getDescent());
        int n = this.gv.getNumGlyphs();
        float[] fArray = this.gv.getGlyphPositions(0, n + 1, null);
        float f2 = 0.0f;
        boolean bl = this.isGlyphOrientationAuto();
        int n2 = 0;
        if (!bl) {
            n2 = this.getGlyphOrientationAngle();
        }
        int n3 = 0;
        int n4 = this.aci.getBeginIndex();
        char c = this.aci.first();
        int n5 = n4;
        Float f3 = null;
        Float f4 = null;
        Float f5 = null;
        Float f6 = null;
        Float f7 = null;
        Object object = null;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = (float)this.offset.getX();
        float f11 = (float)this.offset.getY();
        while (n3 < n) {
            float f12;
            if (n4 >= n5) {
                n5 = this.aci.getRunLimit(runAtts);
                f3 = (Float)this.aci.getAttribute(X);
                f4 = (Float)this.aci.getAttribute(Y);
                f5 = (Float)this.aci.getAttribute(DX);
                f6 = (Float)this.aci.getAttribute(DY);
                f7 = (Float)this.aci.getAttribute(ROTATION);
                object = this.aci.getAttribute(BASELINE_SHIFT);
            }
            GVTGlyphMetrics gVTGlyphMetrics = this.gv.getGlyphMetrics(n3);
            if (n3 == 0) {
                f2 = bl ? (this.isLatinChar(c) ? 0.0f : (float)gVTGlyphMetrics.getBounds2D().getHeight()) : (n2 == 0 ? (float)gVTGlyphMetrics.getBounds2D().getHeight() : 0.0f);
            } else if (bl && f2 == 0.0f && !this.isLatinChar(c)) {
                f2 = (float)gVTGlyphMetrics.getBounds2D().getHeight();
            }
            float f13 = 0.0f;
            float f14 = 0.0f;
            float f15 = 0.0f;
            float f16 = 0.0f;
            if (c != '\uffff') {
                if (this.vertical) {
                    f15 = bl ? (this.isLatinChar(c) ? 1.5707964f : 0.0f) : (float)Math.toRadians(n2);
                    if (this.textPath != null) {
                        f3 = null;
                    }
                } else if (this.textPath != null) {
                    f4 = null;
                }
                f16 = f7 == null || f7.isNaN() ? f15 : f7.floatValue() + f15;
                if (f3 != null && !f3.isNaN()) {
                    if (n3 == 0) {
                        f8 = (float)((double)f3.floatValue() - this.offset.getX());
                    }
                    f10 = f3.floatValue() - f8;
                }
                if (f5 != null && !f5.isNaN()) {
                    f10 += f5.floatValue();
                }
                if (f4 != null && !f4.isNaN()) {
                    if (n3 == 0) {
                        f9 = (float)((double)f4.floatValue() - this.offset.getY());
                    }
                    f11 = f4.floatValue() - f9;
                }
                if (f6 != null && !f6.isNaN()) {
                    f11 += f6.floatValue();
                } else if (n3 > 0) {
                    f11 += fArray[n3 * 2 + 1] - fArray[n3 * 2 - 1];
                }
                f12 = 0.0f;
                if (object != null) {
                    if (object instanceof Integer) {
                        if (object == TextAttribute.SUPERSCRIPT_SUPER) {
                            f12 = f * 0.5f;
                        } else if (object == TextAttribute.SUPERSCRIPT_SUB) {
                            f12 = -f * 0.5f;
                        }
                    } else if (object instanceof Float) {
                        f12 = ((Float)object).floatValue();
                    }
                    if (this.vertical) {
                        f13 = f12;
                    } else {
                        f14 = -f12;
                    }
                }
                if (this.vertical) {
                    Rectangle2D rectangle2D;
                    f14 += f2;
                    if (bl) {
                        if (this.isLatinChar(c)) {
                            f13 += this.metrics.getStrikethroughOffset();
                        } else {
                            rectangle2D = this.gv.getGlyphVisualBounds(n3).getBounds2D();
                            f13 -= (float)(rectangle2D.getMaxX() - (double)fArray[2 * n3] - rectangle2D.getWidth() / 2.0);
                        }
                    } else {
                        rectangle2D = this.gv.getGlyphVisualBounds(n3).getBounds2D();
                        f13 = n2 == 0 ? (f13 -= (float)(rectangle2D.getMaxX() - (double)fArray[2 * n3] - rectangle2D.getWidth() / 2.0)) : (n2 == 180 ? (f13 += (float)(rectangle2D.getMaxX() - (double)fArray[2 * n3] - rectangle2D.getWidth() / 2.0)) : (n2 == 90 ? (f13 += this.metrics.getStrikethroughOffset()) : (f13 -= this.metrics.getStrikethroughOffset())));
                    }
                }
            }
            this.gv.setGlyphPosition(n3, new Point2D.Float(f10 + f13, f11 + f14));
            if (!ArabicTextHandler.arabicCharTransparent(c)) {
                if (this.vertical) {
                    f12 = 0.0f;
                    if (bl) {
                        f12 = this.isLatinChar(c) ? gVTGlyphMetrics.getHorizontalAdvance() : gVTGlyphMetrics.getVerticalAdvance();
                    } else if (n2 == 0 || n2 == 180) {
                        f12 = gVTGlyphMetrics.getVerticalAdvance();
                    } else if (n2 == 90) {
                        f12 = gVTGlyphMetrics.getHorizontalAdvance();
                    } else {
                        f12 = gVTGlyphMetrics.getHorizontalAdvance();
                        this.gv.setGlyphTransform(n3, AffineTransform.getTranslateInstance(0.0, f12));
                    }
                    f11 += f12;
                } else {
                    f10 += gVTGlyphMetrics.getHorizontalAdvance();
                }
            }
            if (f16 != 0.0f) {
                AffineTransform affineTransform = this.gv.getGlyphTransform(n3);
                if (affineTransform == null) {
                    affineTransform = new AffineTransform();
                }
                affineTransform.rotate(f16);
                this.gv.setGlyphTransform(n3, affineTransform);
            }
            c = this.aci.setIndex(n4 += this.gv.getCharacterCount(n3, n3));
            ++n3;
        }
        this.gv.setGlyphPosition(n3, new Point2D.Float(f10, f11));
        this.advance = new Point2D.Float((float)((double)f10 - this.offset.getX()), (float)((double)f11 - this.offset.getY()));
        this.layoutApplied = true;
        this.spacingApplied = false;
        this.pathApplied = false;
    }

    protected void adjustTextSpacing() {
        if (this.spacingApplied) {
            return;
        }
        if (!this.layoutApplied) {
            this.doExplicitGlyphLayout();
        }
        this.aci.first();
        Boolean bl = (Boolean)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING);
        if (bl != null && bl.booleanValue()) {
            this.advance = this.doSpacing((Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.KERNING), (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING), (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING));
            this.layoutApplied = false;
        }
        this.applyStretchTransform(!this.adjSpacing);
        this.spacingApplied = true;
        this.pathApplied = false;
    }

    protected Point2D doSpacing(Float f, Float f2, Float f3) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (f instanceof Float && !f.isNaN()) {
            f4 = f.floatValue();
            bl = false;
        }
        if (f2 instanceof Float && !f2.isNaN()) {
            f5 = f2.floatValue();
            bl3 = true;
        }
        if (f3 instanceof Float && !f3.isNaN()) {
            f6 = f3.floatValue();
            bl2 = true;
        }
        int n = this.gv.getNumGlyphs();
        float f7 = 0.0f;
        float f8 = 0.0f;
        Point2D[] point2DArray = new Point2D[n + 1];
        Point2D point2D = this.gv.getGlyphPosition(0);
        float f9 = (float)point2D.getX();
        float f10 = (float)point2D.getY();
        Point2D.Double double_ = new Point2D.Double(this.advance.getX() - (this.gv.getGlyphPosition(n - 1).getX() - (double)f9), this.advance.getY() - (this.gv.getGlyphPosition(n - 1).getY() - (double)f10));
        try {
            int n2;
            if (n > 1 && (bl3 || !bl)) {
                n2 = 1;
                while (n2 <= n) {
                    Point2D point2D2 = this.gv.getGlyphPosition(n2);
                    f7 = (float)point2D2.getX() - (float)point2D.getX();
                    f8 = (float)point2D2.getY() - (float)point2D.getY();
                    if (bl) {
                        if (this.vertical) {
                            f8 += f5;
                        } else {
                            f7 += f5;
                        }
                    } else if (this.vertical) {
                        f8 = (float)this.gv.getGlyphMetrics(n2 - 1).getBounds2D().getHeight() + f4 + f5;
                    } else {
                        f7 = (float)this.gv.getGlyphMetrics(n2 - 1).getBounds2D().getWidth() + f4 + f5;
                    }
                    point2DArray[n2] = new Point2D.Float(f9 += f7, f10 += f8);
                    point2D = point2D2;
                    ++n2;
                }
                int n3 = 1;
                while (n3 <= n) {
                    if (point2DArray[n3] != null) {
                        this.gv.setGlyphPosition(n3, point2DArray[n3]);
                    }
                    ++n3;
                }
            }
            if (bl) {
                if (this.vertical) {
                    ((Point2D)double_).setLocation(((Point2D)double_).getX(), ((Point2D)double_).getY() + (double)f5);
                } else {
                    ((Point2D)double_).setLocation(((Point2D)double_).getX() + (double)f5, ((Point2D)double_).getY());
                }
            } else if (this.vertical) {
                ((Point2D)double_).setLocation(((Point2D)double_).getX(), this.gv.getGlyphMetrics(n - 2).getBounds2D().getHeight() + (double)f4 + (double)f5);
            } else {
                ((Point2D)double_).setLocation(this.gv.getGlyphMetrics(n - 2).getBounds2D().getWidth() + (double)f4 + (double)f5, ((Point2D)double_).getY());
            }
            f7 = 0.0f;
            f8 = 0.0f;
            point2D = this.gv.getGlyphPosition(0);
            f9 = (float)point2D.getX();
            f10 = (float)point2D.getY();
            if (n > 1 && bl2) {
                int n4;
                n2 = 1;
                while (n2 < n) {
                    Point2D point2D3 = this.gv.getGlyphPosition(n2);
                    f7 = (float)point2D3.getX() - (float)point2D.getX();
                    f8 = (float)point2D3.getY() - (float)point2D.getY();
                    n4 = 0;
                    int n5 = n2;
                    int n6 = n2;
                    GVTGlyphMetrics gVTGlyphMetrics = this.gv.getGlyphMetrics(n2);
                    while (gVTGlyphMetrics.getBounds2D().getWidth() < 0.01 || gVTGlyphMetrics.isWhitespace()) {
                        if (n4 == 0) {
                            n4 = 1;
                        }
                        if (n2 == n - 1) break;
                        ++n6;
                        point2D3 = this.gv.getGlyphPosition(++n2);
                        gVTGlyphMetrics = this.gv.getGlyphMetrics(n2);
                    }
                    if (n4 != 0) {
                        int n7 = n6 - n5;
                        float f11 = (float)point2D.getX();
                        float f12 = (float)point2D.getY();
                        f7 = (float)(point2D3.getX() - (double)f11) / (float)(n7 + 1);
                        f8 = (float)(point2D3.getY() - (double)f12) / (float)(n7 + 1);
                        if (this.vertical) {
                            f8 += f3.floatValue() / (float)(n7 + 1);
                        } else {
                            f7 += f3.floatValue() / (float)(n7 + 1);
                        }
                        int n8 = n5;
                        while (n8 <= n6) {
                            point2DArray[n8] = new Point2D.Float(f9 += f7, f10 += f8);
                            ++n8;
                        }
                    } else {
                        f7 = (float)(point2D3.getX() - point2D.getX());
                        f8 = (float)(point2D3.getY() - point2D.getY());
                        point2DArray[n2] = new Point2D.Float(f9 += f7, f10 += f8);
                    }
                    point2D = point2D3;
                    ++n2;
                }
                Point2D point2D4 = this.gv.getGlyphPosition(n);
                point2DArray[n] = new Point2D.Float(f9 += (float)(point2D4.getX() - point2D.getX()), f10 += (float)(point2D4.getY() - point2D.getY()));
                n4 = 1;
                while (n4 <= n) {
                    if (point2DArray[n4] != null) {
                        this.gv.setGlyphPosition(n4, point2DArray[n4]);
                    }
                    ++n4;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        double d = this.gv.getGlyphPosition(n - 1).getX() - this.gv.getGlyphPosition(0).getX();
        double d2 = this.gv.getGlyphPosition(n - 1).getY() - this.gv.getGlyphPosition(0).getY();
        Point2D.Double double_2 = new Point2D.Double(d + ((Point2D)double_).getX(), d2 + ((Point2D)double_).getY());
        return double_2;
    }

    protected void applyStretchTransform(boolean bl) {
        if (this.xScale == 1.0f && this.yScale == 1.0f) {
            return;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(this.xScale, this.yScale);
        int n = this.gv.getNumGlyphs();
        float[] fArray = this.gv.getGlyphPositions(0, n + 1, null);
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n2 = 0;
        while (n2 <= n) {
            f3 = fArray[2 * n2] - f;
            f4 = fArray[2 * n2 + 1] - f2;
            this.gv.setGlyphPosition(n2, new Point2D.Float(f + f3 * this.xScale, f2 + f4 * this.yScale));
            if (bl && n2 != n) {
                AffineTransform affineTransform2 = this.gv.getGlyphTransform(n2);
                if (affineTransform2 != null) {
                    affineTransform2.preConcatenate(affineTransform);
                    this.gv.setGlyphTransform(n2, affineTransform2);
                } else {
                    this.gv.setGlyphTransform(n2, affineTransform);
                }
            }
            ++n2;
        }
        this.advance = new Point2D.Float((float)(this.advance.getX() * (double)this.xScale), (float)(this.advance.getY() * (double)this.yScale));
        this.layoutApplied = false;
    }

    protected void doPathLayout() {
        Point2D point2D;
        if (this.pathApplied) {
            return;
        }
        if (!this.spacingApplied) {
            this.adjustTextSpacing();
        }
        if (this.textPath == null) {
            this.pathApplied = true;
            return;
        }
        boolean bl = !this.isVertical();
        boolean bl2 = this.isGlyphOrientationAuto();
        int n = 0;
        if (!bl2) {
            n = this.getGlyphOrientationAngle();
        }
        float f = this.textPath.lengthOfPath();
        float f2 = this.textPath.getStartOffset();
        int n2 = this.gv.getNumGlyphs();
        int n3 = 0;
        while (n3 < n2) {
            this.gv.setGlyphVisible(n3, true);
            ++n3;
        }
        float f3 = bl ? (float)this.gv.getLogicalBounds().getWidth() : (float)this.gv.getLogicalBounds().getHeight();
        if (f == 0.0f || f3 == 0.0f) {
            this.pathApplied = true;
            this.textPathAdvance = this.advance;
            return;
        }
        float f4 = bl ? (float)this.offset.getX() + f2 : (float)this.offset.getY() + f2;
        Point2D point2D2 = this.gv.getGlyphPosition(0);
        float f5 = 0.0f;
        f5 = bl ? (float)point2D2.getY() : (float)point2D2.getX();
        char c = this.aci.first();
        int n4 = this.aci.getBeginIndex();
        int n5 = -1;
        float f6 = 0.0f;
        int n6 = 0;
        while (n6 < n2) {
            Object object;
            point2D = this.gv.getGlyphPosition(n6);
            float f7 = 0.0f;
            float f8 = 0.0f;
            if (n6 < this.gv.getNumGlyphs() - 1) {
                object = this.gv.getGlyphPosition(n6 + 1);
                if (bl) {
                    f7 = (float)(((Point2D)object).getX() - point2D.getX());
                    f8 = (float)(((Point2D)object).getY() - point2D.getY());
                } else {
                    f7 = (float)(((Point2D)object).getY() - point2D.getY());
                    f8 = (float)(((Point2D)object).getX() - point2D.getX());
                }
            } else {
                object = this.gv.getGlyphMetrics(n6);
                f7 = bl ? ((GVTGlyphMetrics)object).getHorizontalAdvance() : (bl2 ? (this.isLatinChar(c) ? ((GVTGlyphMetrics)object).getHorizontalAdvance() : ((GVTGlyphMetrics)object).getVerticalAdvance()) : (n == 0 || n == 180 ? ((GVTGlyphMetrics)object).getVerticalAdvance() : ((GVTGlyphMetrics)object).getHorizontalAdvance()));
            }
            object = this.gv.getGlyphOutline(n6).getBounds2D();
            float f9 = (float)((RectangularShape)object).getWidth();
            float f10 = (float)((RectangularShape)object).getHeight();
            float f11 = bl ? f4 + f9 / 2.0f : f4 + f10 / 2.0f;
            Point2D point2D3 = this.textPath.pointAtLength(f11);
            if (point2D3 != null) {
                float f12 = this.textPath.angleAtLength(f11);
                AffineTransform affineTransform = new AffineTransform();
                if (bl) {
                    affineTransform.rotate(f12);
                } else {
                    affineTransform.rotate((double)f12 - 1.5707963267948966);
                }
                if (bl) {
                    affineTransform.translate(0.0, f5);
                } else {
                    affineTransform.translate(f5, 0.0);
                }
                if (bl) {
                    affineTransform.translate(f9 / -2.0f, 0.0);
                } else if (bl2) {
                    if (this.isLatinChar(c)) {
                        affineTransform.translate(0.0, -f10 / 2.0f);
                    } else {
                        affineTransform.translate(0.0, f10 / 2.0f);
                    }
                } else if (n == 0) {
                    affineTransform.translate(0.0, f10 / 2.0f);
                } else {
                    affineTransform.translate(0.0, -f10 / 2.0f);
                }
                AffineTransform affineTransform2 = this.gv.getGlyphTransform(n6);
                if (affineTransform2 != null) {
                    affineTransform.concatenate(affineTransform2);
                }
                this.gv.setGlyphTransform(n6, affineTransform);
                this.gv.setGlyphPosition(n6, new Point2D.Double(point2D3.getX(), point2D3.getY()));
                n5 = n6;
                f6 = f7;
            } else {
                this.gv.setGlyphVisible(n6, false);
            }
            f4 += f7;
            f5 += f8;
            n4 += this.gv.getCharacterCount(n6, n6);
            c = this.aci.setIndex(this.aci.getBeginIndex() + n6 + this.gv.getCharacterCount(n6, n6));
            ++n6;
        }
        if (n5 > -1) {
            point2D = this.gv.getGlyphPosition(n5);
            this.textPathAdvance = bl ? new Point2D.Double(point2D.getX() + (double)f6, point2D.getY()) : new Point2D.Double(point2D.getX(), point2D.getY() + (double)f6);
        } else {
            this.textPathAdvance = new Point2D.Double(0.0, 0.0);
        }
        this.layoutApplied = false;
        this.spacingApplied = false;
        this.pathApplied = true;
    }

    protected boolean isLatinChar(char c) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        return unicodeBlock == Character.UnicodeBlock.BASIC_LATIN || unicodeBlock == Character.UnicodeBlock.LATIN_1_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_A || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_B;
    }

    protected boolean isGlyphOrientationAuto() {
        boolean bl = true;
        this.aci.first();
        if (this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION) != null) {
            bl = this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION) == GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_AUTO;
        }
        return bl;
    }

    protected int getGlyphOrientationAngle() {
        int n = 0;
        this.aci.first();
        Float f = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE);
        if (f != null) {
            n = (int)f.floatValue();
        }
        if (n != 0 || n != 90 || n != 180 || n != 270) {
            while (n < 0) {
                n += 360;
            }
            while (n >= 360) {
                n -= 360;
            }
            n = n <= 45 || n > 315 ? 0 : (n > 45 && n <= 135 ? 90 : (n > 135 && n <= 225 ? 180 : 270));
        }
        return n;
    }

    public static void textWrapTextChunk(AttributedCharacterIterator[] attributedCharacterIteratorArray, List list, List list2) {
        int n = attributedCharacterIteratorArray.length;
        GVTGlyphVector[] gVTGlyphVectorArray = new GVTGlyphVector[attributedCharacterIteratorArray.length];
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        Rectangle2D rectangle2D = (Rectangle2D)iterator2.next();
        float f = (float)rectangle2D.getHeight();
        boolean bl = true;
        float f2 = 1.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n2 = 0;
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            AttributedCharacterIterator attributedCharacterIterator = attributedCharacterIteratorArray[n2];
            LinkedList<GVTGlyphVector> linkedList = (LinkedList<GVTGlyphVector>)attributedCharacterIterator.getAttribute(FLOW_EMPTY_PARAGRAPH);
            if (linkedList != null) {
                object2 = linkedList.iterator();
                while (object2.hasNext()) {
                    float f6;
                    object = (MarginInfo)object2.next();
                    float f7 = f6 = f5 > ((MarginInfo)object).getTopMargin() ? f5 : ((MarginInfo)object).getTopMargin();
                    if (f4 + f6 <= f && !((MarginInfo)object).isFlowRegionBreak()) {
                        f4 += f6;
                    } else {
                        if (!iterator2.hasNext()) {
                            rectangle2D = null;
                            break;
                        }
                        rectangle2D = (Rectangle2D)iterator2.next();
                        f = (float)rectangle2D.getHeight();
                        f4 = ((MarginInfo)object).getTopMargin();
                    }
                    f5 = ((MarginInfo)object).getBottomMargin();
                }
                if (rectangle2D == null) break;
            }
            linkedList = new LinkedList<GVTGlyphVector>();
            object2 = (List)iterator.next();
            object = object2.iterator();
            while (object.hasNext()) {
                GlyphLayout glyphLayout = (GlyphLayout)object.next();
                linkedList.add(glyphLayout.getGlyphVector());
            }
            MultiGlyphVector multiGlyphVector = new MultiGlyphVector(linkedList);
            gVTGlyphVectorArray[n2] = multiGlyphVector;
            int n3 = multiGlyphVector.getNumGlyphs();
            attributedCharacterIterator.first();
            MarginInfo marginInfo = (MarginInfo)attributedCharacterIterator.getAttribute(FLOW_PARAGRAPH);
            if (marginInfo != null) {
                int n4 = marginInfo.getJustification();
                if (rectangle2D == null) {
                    int n5 = 0;
                    while (n5 < n3) {
                        multiGlyphVector.setGlyphVisible(n5, false);
                        ++n5;
                    }
                } else {
                    int n6;
                    float f8;
                    float f9 = f8 = f5 > marginInfo.getTopMargin() ? f5 : marginInfo.getTopMargin();
                    if (f4 + f8 <= f) {
                        f4 += f8;
                    } else {
                        if (!iterator2.hasNext()) {
                            rectangle2D = null;
                            break;
                        }
                        rectangle2D = (Rectangle2D)iterator2.next();
                        f = (float)rectangle2D.getHeight();
                        f4 = marginInfo.getTopMargin();
                    }
                    f5 = marginInfo.getBottomMargin();
                    float f10 = marginInfo.getFirstLineLeftMargin();
                    float f11 = marginInfo.getFirstLineRightMargin();
                    float f12 = (float)rectangle2D.getX() + f10;
                    float f13 = (float)rectangle2D.getY();
                    float f14 = (float)(rectangle2D.getWidth() - (double)(f10 + f11));
                    f = (float)rectangle2D.getHeight();
                    LinkedList<LineInfo> linkedList2 = new LinkedList<LineInfo>();
                    float f15 = 0.0f;
                    GlyphIterator glyphIterator = new GlyphIterator(attributedCharacterIterator, multiGlyphVector);
                    GlyphIterator glyphIterator2 = null;
                    GlyphIterator glyphIterator3 = null;
                    if (!glyphIterator.done() && !glyphIterator.isPrinting()) {
                        linkedList2.add(glyphIterator.newLine(new Point2D.Float(f12, f13 + f4), f14, true));
                    }
                    GlyphIterator glyphIterator4 = glyphIterator.copy();
                    boolean bl2 = true;
                    while (!glyphIterator.done()) {
                        n6 = 0;
                        boolean bl3 = false;
                        if (glyphIterator.isPrinting() && glyphIterator.getAdv() > f14) {
                            if (glyphIterator2 == null) {
                                if (!iterator2.hasNext()) {
                                    rectangle2D = null;
                                    glyphIterator = glyphIterator4.copy(glyphIterator);
                                    break;
                                }
                                rectangle2D = (Rectangle2D)iterator2.next();
                                f12 = (float)rectangle2D.getX() + f10;
                                f13 = (float)rectangle2D.getY();
                                f14 = (float)(rectangle2D.getWidth() - (double)(f10 + f11));
                                f = (float)rectangle2D.getHeight();
                                f4 = bl2 ? marginInfo.getTopMargin() : 0.0f;
                                f15 = 0.0f;
                                glyphIterator = glyphIterator4.copy(glyphIterator);
                                continue;
                            }
                            glyphIterator = glyphIterator2.copy(glyphIterator);
                            f3 = 1.0f;
                            n6 = 1;
                            bl3 = false;
                        } else if (glyphIterator.isLastChar()) {
                            f3 = 1.0f;
                            n6 = 1;
                            bl3 = true;
                        }
                        int n7 = glyphIterator.getLineBreaks();
                        if (n7 != 0) {
                            if (n6 != 0) {
                                f3 -= 1.0f;
                            }
                            f3 += (float)n7;
                            n6 = 1;
                            bl3 = true;
                        }
                        if (n6 == 0) {
                            if (glyphIterator.isBreakChar() || glyphIterator2 == null || !glyphIterator2.isBreakChar()) {
                                glyphIterator3 = glyphIterator.copy(glyphIterator3);
                                glyphIterator.nextChar();
                                if (glyphIterator.getChar() == '\u200d') continue;
                                GlyphIterator glyphIterator5 = glyphIterator2;
                                glyphIterator2 = glyphIterator3;
                                glyphIterator3 = glyphIterator5;
                                continue;
                            }
                            glyphIterator.nextChar();
                            continue;
                        }
                        float f16 = glyphIterator.getMaxAscent() + glyphIterator.getMaxDescent();
                        float f17 = bl ? glyphIterator.getMaxFontSize() * f2 : f2;
                        float f18 = (f17 - f16) / 2.0f;
                        float f19 = f15 + f18 + glyphIterator.getMaxAscent();
                        float f20 = f18 + glyphIterator.getMaxDescent();
                        f4 += f19;
                        float f21 = f20;
                        if (f20 < glyphIterator.getMaxDescent()) {
                            f21 = glyphIterator.getMaxDescent();
                        }
                        if (f4 + f21 > f) {
                            if (!iterator2.hasNext()) {
                                rectangle2D = null;
                                glyphIterator = glyphIterator4.copy(glyphIterator);
                                break;
                            }
                            float f22 = f14;
                            rectangle2D = (Rectangle2D)iterator2.next();
                            f12 = (float)rectangle2D.getX() + f10;
                            f13 = (float)rectangle2D.getY();
                            f14 = (float)(rectangle2D.getWidth() - (double)(f10 + f11));
                            f = (float)rectangle2D.getHeight();
                            f4 = bl2 ? marginInfo.getTopMargin() : 0.0f;
                            f15 = 0.0f;
                            if (!(glyphIterator.getAdv() > f22)) continue;
                            glyphIterator = glyphIterator4.copy(glyphIterator);
                            continue;
                        }
                        f15 = f20 + (f3 - 1.0f) * f17;
                        f3 = 0.0f;
                        linkedList2.add(glyphIterator.newLine(new Point2D.Float(f12, f13 + f4), f14, bl3));
                        f12 -= f10;
                        f14 += f10 + f11;
                        f10 = marginInfo.getLeftMargin();
                        f11 = marginInfo.getRightMargin();
                        f12 += f10;
                        f14 -= f10 + f11;
                        bl2 = false;
                        glyphIterator4 = glyphIterator.copy(glyphIterator4);
                        glyphIterator2 = null;
                    }
                    f4 += f15;
                    n6 = glyphIterator.getGlyphIndex();
                    while (n6 < n3) {
                        multiGlyphVector.setGlyphVisible(n6++, false);
                    }
                    GlyphLayout.layoutChunk(attributedCharacterIterator, multiGlyphVector, glyphIterator.getOrigin(), n4, linkedList2);
                    if (marginInfo.isFlowRegionBreak()) {
                        rectangle2D = null;
                        if (iterator2.hasNext()) {
                            rectangle2D = (Rectangle2D)iterator2.next();
                            f = (float)rectangle2D.getHeight();
                            f4 = marginInfo.getTopMargin();
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public static void layoutChunk(AttributedCharacterIterator attributedCharacterIterator, GVTGlyphVector gVTGlyphVector, Point2D point2D, int n, List list) {
        float f;
        float f2;
        Iterator iterator = list.iterator();
        int n2 = gVTGlyphVector.getNumGlyphs();
        float[] fArray = gVTGlyphVector.getGlyphPositions(0, n2 + 1, null);
        Point2D.Float float_ = null;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = (float)point2D.getX();
        float f6 = (float)point2D.getY();
        float f7 = 1.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (n4 == n3) {
                f5 += f3;
                if (!iterator.hasNext()) break;
                LineInfo lineInfo = (LineInfo)iterator.next();
                n3 = lineInfo.getEndIdx();
                float_ = lineInfo.getLocation();
                f3 = lineInfo.getAdvance();
                f4 = lineInfo.getVisualAdvance();
                f9 = lineInfo.getLastCharWidth();
                f10 = lineInfo.getLineWidth();
                bl = lineInfo.isPartialLine();
                f8 = 0.0f;
                f7 = 1.0f;
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        f8 = (f10 - f4) / 2.0f;
                        break;
                    }
                    case 2: {
                        f8 = f10 - f4;
                        break;
                    }
                    case 3: {
                        if (bl || n3 == n4 + 1) break;
                        f7 = (f10 - f9) / (f4 - f9);
                    }
                }
            }
            f2 = float_.x + (fArray[2 * n4] - f5) * f7 + f8;
            f = float_.y + (fArray[2 * n4 + 1] - f6);
            gVTGlyphVector.setGlyphPosition(n4, new Point2D.Float(f2, f));
            ++n4;
        }
        f2 = f5;
        f = f6;
        if (float_ != null) {
            f2 = float_.x + (fArray[2 * n4] - f5) * f7 + f8;
            f = float_.y + (fArray[2 * n4 + 1] - f6);
        }
        gVTGlyphVector.setGlyphPosition(n4, new Point2D.Float(f2, f));
    }

    static {
        runAtts.add(X);
        runAtts.add(Y);
        runAtts.add(DX);
        runAtts.add(DY);
        runAtts.add(ROTATION);
        runAtts.add(BASELINE_SHIFT);
        szAtts = new HashSet();
        szAtts.add(TextAttribute.SIZE);
    }
}

