/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import org.xml.sax.SAXException;

public class FOPException
extends Exception {
    private static final String EXCEPTION_SEPARATOR = "\n---------\n";
    private Throwable exception;

    public FOPException(String message) {
        super(message);
    }

    public FOPException(Throwable e) {
        super(e.getMessage());
        this.setException(e);
    }

    public FOPException(String message, Throwable e) {
        super(message);
        this.setException(e);
    }

    protected void setException(Throwable t) {
        this.exception = t;
    }

    public Throwable getException() {
        return this.exception;
    }

    protected Throwable getRootException() {
        Throwable result = this.exception;
        if (result instanceof SAXException) {
            result = ((SAXException)result).getException();
        }
        if (result instanceof InvocationTargetException) {
            result = ((InvocationTargetException)result).getTargetException();
        }
        if (result != this.exception) {
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            super.printStackTrace();
            if (this.exception != null) {
                System.err.println(EXCEPTION_SEPARATOR);
                this.exception.printStackTrace();
            }
            if (this.getRootException() != null) {
                System.err.println(EXCEPTION_SEPARATOR);
                this.getRootException().printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream stream) {
        PrintStream printStream = stream;
        synchronized (printStream) {
            super.printStackTrace(stream);
            if (this.exception != null) {
                stream.println(EXCEPTION_SEPARATOR);
                this.exception.printStackTrace(stream);
            }
            if (this.getRootException() != null) {
                stream.println(EXCEPTION_SEPARATOR);
                this.getRootException().printStackTrace(stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter writer) {
        PrintWriter printWriter = writer;
        synchronized (printWriter) {
            super.printStackTrace(writer);
            if (this.exception != null) {
                writer.println(EXCEPTION_SEPARATOR);
                this.exception.printStackTrace(writer);
            }
            if (this.getRootException() != null) {
                writer.println(EXCEPTION_SEPARATOR);
                this.getRootException().printStackTrace(writer);
            }
        }
    }
}

