/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.fop.apps.CommandLineOptions;
import org.apache.fop.apps.CommandLineStarter;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Version;
import org.apache.fop.render.awt.AWTRenderer;
import org.xml.sax.XMLReader;

public class PrintStarter
extends CommandLineStarter {
    public PrintStarter(CommandLineOptions options) throws FOPException {
        super(options);
    }

    public void run() throws FOPException {
        Driver driver = new Driver();
        String version = Version.getVersion();
        XMLReader parser = this.inputHandler.getParser();
        this.setParserFeatures(parser);
        PrinterJob pj = PrinterJob.getPrinterJob();
        if (System.getProperty("dialog") != null && !pj.printDialog()) {
            throw new FOPException("Printing cancelled by operator");
        }
        PrintRenderer renderer = new PrintRenderer(pj);
        int copies = this.getIntProperty("copies", 1);
        pj.setCopies(copies);
        try {
            driver.setRenderer(renderer);
            driver.render(parser, this.inputHandler.getInputSource());
        }
        catch (Exception e) {
            if (e instanceof FOPException) {
                throw (FOPException)e;
            }
            throw new FOPException(e);
        }
        System.exit(0);
    }

    int getIntProperty(String name, int def) {
        String propValue = System.getProperty(name);
        if (propValue != null) {
            try {
                return Integer.parseInt(propValue);
            }
            catch (Exception e) {
                return def;
            }
        }
        return def;
    }

    class PrintRenderer
    extends AWTRenderer {
        private final int EVEN_AND_ALL = 0;
        private final int EVEN = 1;
        private final int ODD = 2;
        private int startNumber;
        private int endNumber;
        private int mode = 0;
        private int copies = 1;
        private PrinterJob printerJob;

        PrintRenderer(PrinterJob printerJob) {
            super(null);
            this.printerJob = printerJob;
            this.startNumber = PrintStarter.this.getIntProperty("start", 1) - 1;
            this.endNumber = PrintStarter.this.getIntProperty("end", -1);
            printerJob.setPageable(this);
            this.mode = 0;
            String str = System.getProperty("even");
            if (str != null) {
                this.mode = Boolean.valueOf(str) != false ? 1 : 2;
            }
        }

        public void stopRenderer(OutputStream outputStream) throws IOException {
            super.stopRenderer();
            if (this.endNumber == -1) {
                this.endNumber = this.getPageCount();
            }
            Vector numbers = this.getInvalidPageNumbers();
            int i = numbers.size() - 1;
            while (i > -1) {
                --i;
            }
            try {
                this.printerJob.print();
            }
            catch (PrinterException e) {
                e.printStackTrace();
                throw new IOException("Unable to print: " + e.getClass().getName() + ": " + e.getMessage());
            }
        }

        private Vector getInvalidPageNumbers() {
            Vector<String> vec = new Vector<String>();
            int max = this.getPageCount();
            int i = 0;
            while (i < max) {
                boolean isValid = true;
                if (i < this.startNumber || i > this.endNumber) {
                    isValid = false;
                } else if (this.mode != 0) {
                    if (this.mode == 1 && (i + 1) % 2 != 0) {
                        isValid = false;
                    } else if (this.mode == 2 && (i + 1) % 2 != 1) {
                        isValid = false;
                    }
                }
                if (!isValid) {
                    vec.add(i + "");
                }
                ++i;
            }
            return vec;
        }
    }
}

