/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.InputHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class TraxInputHandler
extends InputHandler {
    private File xmlfile;
    private File xsltfile;

    public TraxInputHandler(File xmlfile, File xsltfile) {
        this.xmlfile = xmlfile;
        this.xsltfile = xsltfile;
    }

    public InputSource getInputSource() {
        return InputHandler.fileInputSource(this.xmlfile);
    }

    public XMLReader getParser() throws FOPException {
        return TraxInputHandler.getXMLFilter(this.xmlfile, this.xsltfile);
    }

    public static XMLFilter getXMLFilter(File xmlfile, File xsltfile) throws FOPException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            if (tFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") && tFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
                SAXTransformerFactory saxTFactory = (SAXTransformerFactory)tFactory;
                XMLFilter xmlfilter = saxTFactory.newXMLFilter(new StreamSource(xsltfile));
                XMLReader parser = InputHandler.createParser();
                if (parser == null) {
                    throw new FOPException("Unable to create SAX parser");
                }
                xmlfilter.setParent(parser);
                return xmlfilter;
            }
            throw new FOPException("Your parser doesn't support the features SAXSource and SAXResult.\nMake sure you are using an XSLT engine which supports TrAX");
        }
        catch (FOPException fe) {
            throw fe;
        }
        catch (Exception ex) {
            throw new FOPException(ex);
        }
    }
}

