/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.StorePagesModel;
import org.apache.fop.area.Title;
import org.apache.fop.area.TreeExt;
import org.apache.fop.render.Renderer;

public class RenderPagesModel
extends StorePagesModel {
    protected Renderer renderer;
    protected List prepared = new ArrayList();
    private List pendingExt = new ArrayList();
    private List endDocExt = new ArrayList();

    public RenderPagesModel(Renderer rend) {
        this.renderer = rend;
    }

    public void startPageSequence(Title title) {
        super.startPageSequence(title);
        this.renderer.startPageSequence(title);
    }

    public void addPage(PageViewport page) {
        boolean done;
        super.addPage(page);
        boolean bl = done = this.renderer.supportsOutOfOrder() && page.isResolved();
        if (done) {
            try {
                this.renderer.renderPage(page);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            page.clear();
        } else {
            this.preparePage(page);
        }
        boolean cont = this.checkPreparedPages(page);
        if (cont) {
            this.renderExtensions(this.pendingExt);
            this.pendingExt.clear();
        }
    }

    protected boolean checkPreparedPages(PageViewport newpage) {
        Iterator iter = this.prepared.iterator();
        while (iter.hasNext()) {
            PageViewport p = (PageViewport)iter.next();
            if (p.isResolved()) {
                try {
                    this.renderer.renderPage(p);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                p.clear();
                iter.remove();
                continue;
            }
            if (!this.renderer.supportsOutOfOrder()) break;
        }
        return this.renderer.supportsOutOfOrder() || this.prepared.isEmpty();
    }

    protected void preparePage(PageViewport page) {
        if (this.renderer.supportsOutOfOrder()) {
            this.renderer.preparePage(page);
        }
        this.prepared.add(page);
    }

    public void addExtension(TreeExt ext, int when) {
        switch (when) {
            case 0: {
                this.renderer.renderExtension(ext);
                break;
            }
            case 1: {
                this.pendingExt.add(ext);
                break;
            }
            case 2: {
                this.endDocExt.add(ext);
            }
        }
    }

    private void renderExtensions(List list) {
        int count = 0;
        while (count < list.size()) {
            TreeExt ext = (TreeExt)list.get(count);
            this.renderer.renderExtension(ext);
            ++count;
        }
    }

    public void endDocument() {
        this.checkPreparedPages(null);
        this.renderExtensions(this.pendingExt);
        this.pendingExt.clear();
        this.renderExtensions(this.endDocExt);
    }
}

