/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.fop.area.AreaTree;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolveable;
import org.apache.fop.area.TreeExt;

public class BookmarkData
implements Resolveable,
TreeExt {
    private ArrayList subData = new ArrayList();
    private HashMap idRefs = new HashMap();
    private AreaTree areaTree = null;
    private String idRef;
    private PageViewport pageRef = null;
    private String label = null;

    public BookmarkData() {
        this.idRef = null;
    }

    public BookmarkData(String id) {
        this.idRef = id;
        this.idRefs.put(this.idRef, this);
    }

    public void setAreaTree(AreaTree at) {
        this.areaTree = at;
    }

    public String getID() {
        return this.idRef;
    }

    public void addSubData(BookmarkData sub) {
        this.subData.add(sub);
        this.idRefs.put(sub.getID(), sub);
        String[] ids = sub.getIDs();
        int count = 0;
        while (count < ids.length) {
            this.idRefs.put(ids[count], sub);
            ++count;
        }
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public String getLabel() {
        return this.label;
    }

    public int getCount() {
        return this.subData.size();
    }

    public BookmarkData getSubData(int count) {
        return (BookmarkData)this.subData.get(count);
    }

    public PageViewport getPage() {
        return this.pageRef;
    }

    public boolean isResolveable() {
        return true;
    }

    public String getMimeType() {
        return "application/pdf";
    }

    public String getName() {
        return "Bookmark";
    }

    public boolean isResolved() {
        return this.idRefs == null;
    }

    public String[] getIDs() {
        return this.idRefs.keySet().toArray(new String[0]);
    }

    public void resolve(String id, List pages) {
        if (!id.equals(this.idRef)) {
            BookmarkData bd = (BookmarkData)this.idRefs.get(id);
            this.idRefs.remove(id);
            if (bd != null) {
                bd.resolve(id, pages);
                if (bd.isResolved()) {
                    this.checkFinish();
                }
            } else if (this.idRef == null) {
                this.checkFinish();
            }
        } else {
            if (pages != null) {
                this.pageRef = (PageViewport)pages.get(0);
            }
            this.idRefs.remove(this.idRef);
            this.checkFinish();
        }
    }

    private void checkFinish() {
        if (this.idRefs.size() == 0) {
            this.idRefs = null;
            if (this.areaTree != null) {
                this.areaTree.handleTreeExtension(this, 1);
            }
        }
    }
}

