/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.StructureHandler;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOUserAgent;
import org.apache.fop.fo.Unknown;
import org.apache.fop.fo.UnknownXMLObj;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FOTreeBuilder
extends DefaultHandler {
    protected Map fobjTable = new HashMap();
    protected Set namespaces = new HashSet();
    protected FONode currentFObj = null;
    protected FONode rootFObj = null;
    private StructureHandler structHandler;
    private FOUserAgent userAgent;

    private Logger getLogger() {
        return this.userAgent.getLogger();
    }

    public void setUserAgent(FOUserAgent ua) {
        this.userAgent = ua;
    }

    private FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    public void setStructHandler(StructureHandler sh) {
        this.structHandler = sh;
    }

    public void addMapping(String namespaceURI, HashMap table) {
        this.fobjTable.put(namespaceURI, table);
        this.namespaces.add(namespaceURI.intern());
    }

    public void characters(char[] data, int start, int length) {
        if (this.currentFObj != null) {
            this.currentFObj.addCharacters(data, start, start + length);
        }
    }

    public void endElement(String uri, String localName, String rawName) throws SAXException {
        this.currentFObj.end();
        this.currentFObj = this.currentFObj.getParent();
    }

    public void startDocument() throws SAXException {
        this.rootFObj = null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Building formatting object tree");
        }
        this.structHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.rootFObj = null;
        this.currentFObj = null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Parsing of document complete");
        }
        this.structHandler.endDocument();
    }

    public void startElement(String uri, String localName, String rawName, Attributes attlist) throws SAXException {
        FONode fobj;
        ElementMapping.Maker fobjMaker = null;
        Map table = (Map)this.fobjTable.get(uri);
        if (table != null && (fobjMaker = (ElementMapping.Maker)table.get(localName)) == null) {
            fobjMaker = (ElementMapping.Maker)table.get("<default>");
        }
        if (fobjMaker == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Unknown formatting object " + uri + "^" + localName);
            }
            fobjMaker = this.namespaces.contains(uri.intern()) ? new Unknown.Maker() : new UnknownXMLObj.Maker(uri);
        }
        try {
            fobj = fobjMaker.make(this.currentFObj);
            fobj.setName(localName);
            fobj.setUserAgent(this.userAgent);
            fobj.setStructHandler(this.structHandler);
            fobj.handleAttrs(attlist);
        }
        catch (FOPException e) {
            throw new SAXException(e);
        }
        if (this.rootFObj == null) {
            if (!fobj.getName().equals("fo:root")) {
                throw new SAXException(new FOPException("Root element must be fo:root, not " + fobj.getName()));
            }
            this.rootFObj = fobj;
        } else {
            this.currentFObj.addChild(fobj);
        }
        this.currentFObj = fobj;
    }

    public void reset() {
        this.currentFObj = null;
        this.rootFObj = null;
        this.structHandler = null;
    }

    public boolean hasData() {
        return this.rootFObj != null;
    }
}

