/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.XMLHandler;
import org.w3c.dom.Document;

public class FOUserAgent
implements LogEnabled {
    private Logger log;
    private Map defaults = new HashMap();
    private Map handlers = new HashMap();
    private String baseURL;

    public void enableLogging(Logger log) {
        this.log = log;
    }

    public Logger getLogger() {
        return this.log;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getBaseURL() {
        if (this.baseURL == null || this.baseURL.trim().equals("")) {
            return "file:.";
        }
        return this.baseURL;
    }

    public InputStream getStream(String uri) throws IOException {
        return null;
    }

    public float getPixelUnitToMillimeter() {
        return 0.35277778f;
    }

    public boolean linkToFootnotes() {
        return true;
    }

    public void setDefaultXMLHandler(String mime, XMLHandler handler) {
        this.defaults.put(mime, handler);
    }

    public void addXMLHandler(String mime, String ns, XMLHandler handler) {
        HashMap<String, XMLHandler> mh = (HashMap<String, XMLHandler>)this.handlers.get(mime);
        if (mh == null) {
            mh = new HashMap<String, XMLHandler>();
            this.handlers.put(mime, mh);
        }
        mh.put(ns, handler);
    }

    public void renderXML(RendererContext ctx, Document doc, String namespace) {
        String mime = ctx.getMimeType();
        Map mh = (Map)this.handlers.get(mime);
        XMLHandler handler = null;
        if (mh != null) {
            handler = (XMLHandler)mh.get(namespace);
        }
        if (handler == null) {
            handler = (XMLHandler)this.defaults.get(mime);
        }
        if (handler != null) {
            try {
                handler.handleXML(ctx, doc, namespace);
            }
            catch (Throwable t) {
                this.getLogger().error("Some XML content will be ignored. Could not render XML", t);
            }
        } else {
            this.getLogger().warn("Some XML content will be ignored. No handler defined for XML: " + namespace);
        }
    }
}

