/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.HashMap;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyListBuilder;

public class PropertyList
extends HashMap {
    private byte[] wmtable = null;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    public static final int HEIGHT = 4;
    public static final int WIDTH = 5;
    public static final int START = 0;
    public static final int END = 1;
    public static final int BEFORE = 2;
    public static final int AFTER = 3;
    public static final int BLOCKPROGDIM = 4;
    public static final int INLINEPROGDIM = 5;
    private static final String[] ABS_NAMES = new String[]{"left", "right", "top", "bottom", "height", "width"};
    private static final String[] REL_NAMES = new String[]{"start", "end", "before", "after", "block-progression-dimension", "inline-progression-dimension"};
    private static final HashMap WRITING_MODE_TABLES = new HashMap(4);
    private PropertyListBuilder builder;
    private PropertyList parentPropertyList;
    private String namespace;
    private String element;
    private FObj fobj;

    public PropertyList(PropertyList parentPropertyList, String space, String el) {
        WRITING_MODE_TABLES.put(new Integer(47), new byte[]{0, 1, 2, 3, 4, 5});
        WRITING_MODE_TABLES.put(new Integer(79), new byte[]{1, 0, 2, 3, 4, 5});
        WRITING_MODE_TABLES.put(new Integer(91), new byte[]{3, 2, 0, 1, 5, 4});
        this.parentPropertyList = null;
        this.namespace = "";
        this.element = "";
        this.fobj = null;
        this.parentPropertyList = parentPropertyList;
        this.namespace = space;
        this.element = el;
    }

    public void setFObj(FObj fobj) {
        this.fobj = fobj;
    }

    public FObj getFObj() {
        return this.fobj;
    }

    public FObj getParentFObj() {
        if (this.parentPropertyList != null) {
            return this.parentPropertyList.getFObj();
        }
        return null;
    }

    public Property getExplicitOrShorthand(String propertyName) {
        int sepchar = propertyName.indexOf(46);
        String baseName = sepchar > -1 ? propertyName.substring(0, sepchar) : propertyName;
        Property p = this.getExplicitBaseProp(baseName);
        if (p == null) {
            p = this.builder.getShorthand(this, this.namespace, this.element, baseName);
        }
        if (p != null && sepchar > -1) {
            return this.builder.getSubpropValue(this.namespace, this.element, baseName, p, propertyName.substring(sepchar + 1));
        }
        return p;
    }

    public Property getExplicit(String propertyName) {
        int sepchar = propertyName.indexOf(46);
        if (sepchar > -1) {
            String baseName = propertyName.substring(0, sepchar);
            Property p = this.getExplicitBaseProp(baseName);
            if (p != null) {
                return this.builder.getSubpropValue(this.namespace, this.element, baseName, p, propertyName.substring(sepchar + 1));
            }
            return null;
        }
        return (Property)super.get(propertyName);
    }

    public Property getExplicitBaseProp(String propertyName) {
        return (Property)super.get(propertyName);
    }

    public Property getInherited(String propertyName) {
        if (this.builder != null) {
            if (this.parentPropertyList != null && this.builder.isInherited(this.namespace, this.element, propertyName)) {
                return this.parentPropertyList.get(propertyName);
            }
            try {
                return this.builder.makeProperty(this, this.namespace, this.element, propertyName);
            }
            catch (FOPException e) {
            }
        }
        return null;
    }

    private Property findProperty(String propertyName, boolean bTryInherit) {
        Property p = null;
        if (this.builder.isCorrespondingForced(this, this.namespace, this.element, propertyName)) {
            p = this.builder.computeProperty(this, this.namespace, this.element, propertyName);
        } else {
            p = this.getExplicitBaseProp(propertyName);
            if (p == null) {
                p = this.builder.computeProperty(this, this.namespace, this.element, propertyName);
            }
            if (p == null) {
                p = this.builder.getShorthand(this, this.namespace, this.element, propertyName);
            }
            if (p == null && bTryInherit && this.parentPropertyList != null && this.builder.isInherited(this.namespace, this.element, propertyName)) {
                p = this.parentPropertyList.findProperty(propertyName, true);
            }
        }
        return p;
    }

    public Property getSpecified(String propertyName) {
        return this.get(propertyName, false, false);
    }

    public Property get(String propertyName) {
        return this.get(propertyName, true, true);
    }

    private Property get(String propertyName, boolean bTryInherit, boolean bTryDefault) {
        Property p;
        if (this.builder == null) {
            // empty if block
        }
        int sepchar = propertyName.indexOf(46);
        String subpropName = null;
        if (sepchar > -1) {
            subpropName = propertyName.substring(sepchar + 1);
            propertyName = propertyName.substring(0, sepchar);
        }
        if ((p = this.findProperty(propertyName, bTryInherit)) == null && bTryDefault) {
            try {
                p = this.builder.makeProperty(this, this.namespace, this.element, propertyName);
            }
            catch (FOPException e) {
                // empty catch block
            }
        }
        if (p != null && "inherit".equals(p.getSpecifiedValue()) && this.parentPropertyList != null) {
            p = this.parentPropertyList.get(propertyName, true, false);
        }
        if (subpropName != null && p != null) {
            return this.builder.getSubpropValue(this.namespace, this.element, propertyName, p, subpropName);
        }
        return p;
    }

    public void setBuilder(PropertyListBuilder builder) {
        this.builder = builder;
    }

    public String getNameSpace() {
        return this.namespace;
    }

    public String getElement() {
        return this.element;
    }

    public Property getNearestSpecified(String propertyName) {
        Property p;
        block3: {
            p = null;
            PropertyList plist = this;
            while (p == null && plist != null) {
                p = plist.getExplicit(propertyName);
                plist = plist.parentPropertyList;
            }
            if (p != null) break block3;
            try {
                p = this.builder.makeProperty(this, this.namespace, this.element, propertyName);
            }
            catch (FOPException e) {}
        }
        return p;
    }

    public Property getFromParent(String propertyName) {
        if (this.parentPropertyList != null) {
            return this.parentPropertyList.get(propertyName);
        }
        if (this.builder != null) {
            try {
                return this.builder.makeProperty(this, this.namespace, this.element, propertyName);
            }
            catch (FOPException e) {
            }
        }
        return null;
    }

    public String wmAbsToRel(int absdir) {
        if (this.wmtable != null) {
            return REL_NAMES[this.wmtable[absdir]];
        }
        return "";
    }

    public String wmRelToAbs(int reldir) {
        if (this.wmtable != null) {
            int i = 0;
            while (i < this.wmtable.length) {
                if (this.wmtable[i] == reldir) {
                    return ABS_NAMES[i];
                }
                ++i;
            }
        }
        return "";
    }

    public void setWritingMode(int writingMode) {
        this.wmtable = (byte[])WRITING_MODE_TABLES.get(new Integer(writingMode));
    }
}

