/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import org.apache.fop.area.CTM;
import org.apache.fop.datatypes.FODimension;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.TextInfo;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.layout.AbsolutePositionProps;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.HyphenationProps;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.traits.BlockProps;
import org.apache.fop.traits.InlineProps;
import org.apache.fop.traits.LayoutProps;
import org.apache.fop.traits.SpaceVal;

public class PropertyManager {
    private PropertyList properties;
    private FontInfo fontInfo = null;
    private FontState fontState = null;
    private BorderAndPadding borderAndPadding = null;
    private HyphenationProps hyphProps = null;
    private TextInfo textInfo = null;
    private static final String[] SA_BEFORE = new String[]{"before"};
    private static final String[] SA_AFTER = new String[]{"after"};
    private static final String[] SA_START = new String[]{"start"};
    private static final String[] SA_END = new String[]{"end"};
    private static final MessageFormat MSGFMT_COLOR = new MessageFormat("border-{0}-color");
    private static final MessageFormat MSGFMT_STYLE = new MessageFormat("border-{0}-style");
    private static final MessageFormat MSGFMT_WIDTH = new MessageFormat("border-{0}-width");
    private static final MessageFormat MSGFMT_PADDING = new MessageFormat("padding-{0}");
    private static final String NONE = "none";

    public PropertyManager(PropertyList pList) {
        this.properties = pList;
    }

    public PropertyList getProperties() {
        return this.properties;
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public FontState getFontState(FontInfo fontInfo) {
        if (this.fontState == null) {
            if (fontInfo == null) {
                fontInfo = this.fontInfo;
            } else if (this.fontInfo == null) {
                this.fontInfo = fontInfo;
            }
            String fontFamily = this.properties.get("font-family").getString();
            String fontStyle = this.properties.get("font-style").getString();
            String fw = this.properties.get("font-weight").getString();
            int fontWeight = 400;
            if (!fw.equals("bolder") && !fw.equals("lighter")) {
                try {
                    fontWeight = Integer.parseInt(fw);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if ((fontWeight = fontWeight / 100 * 100) < 100) {
                fontWeight = 100;
            } else if (fontWeight > 900) {
                fontWeight = 900;
            }
            int fontSize = this.properties.get("font-size").getLength().getValue();
            String fname = fontInfo.fontLookup(fontFamily, fontStyle, fontWeight);
            FontMetrics metrics = fontInfo.getMetricsFor(fname);
            this.fontState = new FontState(fname, metrics, fontSize);
        }
        return this.fontState;
    }

    public BorderAndPadding getBorderAndPadding() {
        if (this.borderAndPadding == null) {
            this.borderAndPadding = new BorderAndPadding();
            this.initBorderInfo(0, SA_BEFORE);
            this.initBorderInfo(1, SA_AFTER);
            this.initBorderInfo(2, SA_START);
            this.initBorderInfo(3, SA_END);
        }
        return this.borderAndPadding;
    }

    private void initBorderInfo(int whichSide, String[] saSide) {
        this.borderAndPadding.setPadding(whichSide, this.properties.get(MSGFMT_PADDING.format(saSide)).getCondLength());
        int style = this.properties.get(MSGFMT_STYLE.format(saSide)).getEnum();
        if (style != 57) {
            this.borderAndPadding.setBorder(whichSide, style, this.properties.get(MSGFMT_WIDTH.format(saSide)).getCondLength(), this.properties.get(MSGFMT_COLOR.format(saSide)).getColorType());
        }
    }

    public HyphenationProps getHyphenationProps() {
        if (this.hyphProps == null) {
            this.hyphProps = new HyphenationProps();
            this.hyphProps.hyphenate = this.properties.get("hyphenate").getEnum();
            this.hyphProps.hyphenationChar = this.properties.get("hyphenation-character").getCharacter();
            this.hyphProps.hyphenationPushCharacterCount = this.properties.get("hyphenation-push-character-count").getNumber().intValue();
            this.hyphProps.hyphenationRemainCharacterCount = this.properties.get("hyphenation-remain-character-count").getNumber().intValue();
            this.hyphProps.language = this.properties.get("language").getString();
            this.hyphProps.country = this.properties.get("country").getString();
        }
        return this.hyphProps;
    }

    public MarginProps getMarginProps() {
        MarginProps props = new MarginProps();
        props.marginTop = this.properties.get("margin-top").getLength().getValue();
        props.marginBottom = this.properties.get("margin-bottom").getLength().getValue();
        props.marginLeft = this.properties.get("margin-left").getLength().getValue();
        props.marginRight = this.properties.get("margin-right").getLength().getValue();
        props.spaceBefore = this.properties.get("space-before").getSpace().getOptimum().getLength().getValue();
        props.spaceAfter = this.properties.get("space-after").getSpace().getOptimum().getLength().getValue();
        props.startIndent = this.properties.get("start-indent").getLength().getValue();
        props.endIndent = this.properties.get("end-indent").getLength().getValue();
        return props;
    }

    public BackgroundProps getBackgroundProps() {
        BackgroundProps bp = new BackgroundProps();
        bp.backAttachment = this.properties.get("background-attachment").getEnum();
        bp.backColor = this.properties.get("background-color").getColorType();
        if (bp.backColor.alpha() == 1.0f) {
            bp.backColor = null;
        }
        bp.backImage = this.properties.get("background-image").getString();
        if (bp.backImage == null || NONE.equals(bp.backImage)) {
            bp.backImage = null;
        } else {
            bp.backRepeat = this.properties.get("background-repeat").getEnum();
            Property prop = this.properties.get("background-position-horizontal");
            if (prop != null) {
                bp.backPosHorizontal = prop.getLength();
            }
            if ((prop = this.properties.get("background-position-vertical")) != null) {
                bp.backPosVertical = prop.getLength();
            }
        }
        return bp;
    }

    public MarginInlineProps getMarginInlineProps() {
        MarginInlineProps props = new MarginInlineProps();
        return props;
    }

    public InlineProps getInlineProps() {
        InlineProps props = new InlineProps();
        props.spaceStart = new SpaceVal(this.properties.get("space-start").getSpace());
        props.spaceEnd = new SpaceVal(this.properties.get("space-end").getSpace());
        return props;
    }

    public AccessibilityProps getAccessibilityProps() {
        AccessibilityProps props = new AccessibilityProps();
        String str = this.properties.get("source-document").getString();
        if (!NONE.equals(str)) {
            props.sourceDoc = str;
        }
        if (!NONE.equals(str = this.properties.get("role").getString())) {
            props.role = str;
        }
        return props;
    }

    public AuralProps getAuralProps() {
        AuralProps props = new AuralProps();
        return props;
    }

    public RelativePositionProps getRelativePositionProps() {
        RelativePositionProps props = new RelativePositionProps();
        return props;
    }

    public AbsolutePositionProps getAbsolutePositionProps() {
        AbsolutePositionProps props = new AbsolutePositionProps();
        props.absolutePosition = this.properties.get("absolute-position").getEnum();
        props.top = this.properties.get("top").getLength().getValue();
        props.bottom = this.properties.get("bottom").getLength().getValue();
        props.left = this.properties.get("left").getLength().getValue();
        props.right = this.properties.get("right").getLength().getValue();
        return props;
    }

    public BlockProps getBlockProps() {
        BlockProps props = new BlockProps();
        props.firstIndent = this.properties.get("text-indent").getLength().getValue();
        props.lastIndent = 0;
        props.textAlign = this.properties.get("text-align").getEnum();
        props.textAlignLast = this.properties.get("text-align-last").getEnum();
        props.lineStackType = this.properties.get("line-stacking-strategy").getEnum();
        return props;
    }

    public LayoutProps getLayoutProps() {
        LayoutProps props = new LayoutProps();
        props.breakBefore = this.properties.get("break-before").getEnum();
        props.breakAfter = this.properties.get("break-after").getEnum();
        props.bIsSpan = this.properties.get("span").getEnum() == 4;
        props.spaceBefore = new SpaceVal(this.properties.get("space-before").getSpace());
        props.spaceAfter = new SpaceVal(this.properties.get("space-after").getSpace());
        return props;
    }

    public TextInfo getTextLayoutProps(FontInfo fontInfo) {
        if (this.textInfo == null) {
            this.textInfo = new TextInfo();
            this.textInfo.fs = this.getFontState(fontInfo);
            this.textInfo.color = this.properties.get("color").getColorType();
            this.textInfo.verticalAlign = this.properties.get("vertical-align").getEnum();
            this.textInfo.wrapOption = this.properties.get("wrap-option").getEnum();
            this.textInfo.bWrap = this.textInfo.wrapOption == 103;
            this.textInfo.wordSpacing = new SpaceVal(this.properties.get("word-spacing").getSpace());
            this.textInfo.whiteSpaceCollapse = this.properties.get("white-space-collapse").getEnum();
            this.textInfo.lineHeight = this.properties.get("line-height").getLength().getValue();
        }
        return this.textInfo;
    }

    public CTM getCTMandRelDims(Rectangle2D absVPrect, FODimension reldims) {
        int wm;
        int height;
        int width;
        int absRefOrient = this.getAbsRefOrient(this.properties.get("reference-orientation").getNumber().intValue());
        if (absRefOrient % 180 == 0) {
            width = (int)absVPrect.getWidth();
            height = (int)absVPrect.getHeight();
        } else {
            height = (int)absVPrect.getWidth();
            width = (int)absVPrect.getHeight();
        }
        CTM ctm = new CTM(absVPrect.getX(), absVPrect.getY());
        if (absRefOrient != 0) {
            switch (absRefOrient) {
                case 90: {
                    ctm = ctm.translate(0.0, width);
                    break;
                }
                case 180: {
                    ctm = ctm.translate(width, height);
                    break;
                }
                case 270: {
                    ctm = ctm.translate(height, 0.0);
                }
            }
            ctm = ctm.rotate(absRefOrient);
        }
        if ((wm = this.properties.get("writing-mode").getEnum()) == 47 || wm == 79) {
            reldims.ipd = width;
            reldims.bpd = height;
        } else {
            reldims.ipd = height;
            reldims.bpd = width;
        }
        return ctm.multiply(CTM.getWMctm(wm, reldims.ipd, reldims.bpd));
    }

    private int getAbsRefOrient(int myRefOrient) {
        return myRefOrient;
    }
}

