/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.RecursiveCharIterator;
import org.apache.fop.fo.TextInfo;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.HyphenationProps;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layoutmgr.BlockLayoutManager;
import org.apache.fop.util.CharUtilities;
import org.xml.sax.Attributes;

public class Block
extends FObjMixed {
    private int align;
    private int alignLast;
    private int breakAfter;
    private int lineHeight;
    private int startIndent;
    private int endIndent;
    private int spaceBefore;
    private int spaceAfter;
    private int textIndent;
    private int keepWithNext;
    private ColorType backgroundColor;
    private int blockWidows;
    private int blockOrphans;
    private String id;
    private int span;
    private int wsTreatment;
    private int lfTreatment;
    private boolean bWScollapse;
    private boolean anythingLaidOut = false;
    private FONode firstInlineChild = null;

    public Block(FONode parent) {
        super(parent);
    }

    public void handleAttrs(Attributes attlist) throws FOPException {
        super.handleAttrs(attlist);
        this.span = this.properties.get("span").getEnum();
        this.wsTreatment = this.properties.get("white-space-treatment").getEnum();
        this.bWScollapse = this.properties.get("white-space-collapse").getEnum() == 98;
        this.lfTreatment = this.properties.get("linefeed-treatment").getEnum();
        this.setupID();
        this.structHandler.startBlock(this);
    }

    public void setup() {
        AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
        AuralProps mAurProps = this.propMgr.getAuralProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        HyphenationProps mHyphProps = this.propMgr.getHyphenationProps();
        MarginProps mProps = this.propMgr.getMarginProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
        this.setupID();
        this.align = this.properties.get("text-align").getEnum();
        this.alignLast = this.properties.get("text-align-last").getEnum();
        this.breakAfter = this.properties.get("break-after").getEnum();
        this.lineHeight = this.properties.get("line-height").getLength().getValue();
        this.startIndent = this.properties.get("start-indent").getLength().getValue();
        this.endIndent = this.properties.get("end-indent").getLength().getValue();
        this.spaceBefore = this.properties.get("space-before.optimum").getLength().getValue();
        this.spaceAfter = this.properties.get("space-after.optimum").getLength().getValue();
        this.textIndent = this.properties.get("text-indent").getLength().getValue();
        this.keepWithNext = this.properties.get("keep-with-next").getEnum();
        this.blockWidows = this.properties.get("widows").getNumber().intValue();
        this.blockOrphans = this.properties.get("orphans").getNumber().intValue();
    }

    protected boolean containsMarkers() {
        return true;
    }

    public int getSpan() {
        return this.span;
    }

    public void addLayoutManager(List list) {
        BlockLayoutManager blm = new BlockLayoutManager();
        blm.setUserAgent(this.getUserAgent());
        blm.setFObj(this);
        TextInfo ti = this.propMgr.getTextLayoutProps(this.fontInfo);
        blm.setBlockTextInfo(ti);
        list.add(blm);
    }

    public boolean generatesInlineAreas() {
        return false;
    }

    public void addChild(FONode child) {
        if (child instanceof FObj && ((FObj)child).generatesInlineAreas()) {
            if (this.firstInlineChild == null) {
                this.firstInlineChild = child;
            }
        } else {
            this.handleWhiteSpace();
        }
        super.addChild(child);
    }

    public void end() {
        this.handleWhiteSpace();
        this.structHandler.endBlock(this);
    }

    private void handleWhiteSpace() {
        if (this.firstInlineChild != null) {
            boolean bInWS = false;
            boolean bPrevWasLF = false;
            RecursiveCharIterator charIter = new RecursiveCharIterator(this, this.firstInlineChild);
            LFchecker lfCheck = new LFchecker(charIter);
            block17: while (charIter.hasNext()) {
                switch (CharUtilities.classOf(charIter.nextChar())) {
                    case 4: {
                        boolean bIgnore = false;
                        switch (this.wsTreatment) {
                            case 37: {
                                bIgnore = true;
                                break;
                            }
                            case 39: {
                                bIgnore = lfCheck.nextIsLF();
                                break;
                            }
                            case 40: {
                                bIgnore = bPrevWasLF || lfCheck.nextIsLF();
                                break;
                            }
                            case 38: {
                                bIgnore = bPrevWasLF;
                            }
                        }
                        if (bIgnore) {
                            charIter.remove();
                            break;
                        }
                        if (!this.bWScollapse) break;
                        if (bInWS || this.lfTreatment == 68 && (bPrevWasLF || lfCheck.nextIsLF())) {
                            charIter.remove();
                            break;
                        }
                        bInWS = true;
                        break;
                    }
                    case 1: {
                        lfCheck.reset();
                        bPrevWasLF = true;
                        switch (this.lfTreatment) {
                            case 37: {
                                charIter.remove();
                                break;
                            }
                            case 96: {
                                if (bInWS) {
                                    charIter.remove();
                                    break;
                                }
                                if (this.bWScollapse) {
                                    bInWS = true;
                                }
                                charIter.replaceChar(' ');
                                break;
                            }
                            case 97: {
                                charIter.replaceChar('\u200b');
                            }
                            case 68: {
                                bInWS = false;
                            }
                        }
                        continue block17;
                    }
                    case 0: 
                    case 2: 
                    case 3: {
                        bPrevWasLF = false;
                        bInWS = false;
                        lfCheck.reset();
                    }
                }
            }
            this.firstInlineChild = null;
        }
    }

    private static class LFchecker {
        private boolean bNextIsLF = false;
        private RecursiveCharIterator charIter;

        LFchecker(RecursiveCharIterator charIter) {
            this.charIter = charIter;
        }

        boolean nextIsLF() {
            if (!this.bNextIsLF) {
                CharIterator lfIter = this.charIter.mark();
                while (lfIter.hasNext()) {
                    char c = lfIter.nextChar();
                    if (c == '\n') {
                        this.bNextIsLF = true;
                        break;
                    }
                    if (CharUtilities.classOf(c) != 4) break;
                }
            }
            return this.bNextIsLF;
        }

        void reset() {
            this.bNextIsLF = false;
        }
    }
}

