/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.awt.geom.Rectangle2D;
import java.util.List;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layoutmgr.LeafNodeLayoutManager;
import org.apache.fop.layoutmgr.TraitSetter;

public class ExternalGraphic
extends FObj {
    private String url;
    private int breakAfter;
    private int breakBefore;
    private int align;
    private int startIndent;
    private int endIndent;
    private int spaceBefore;
    private int spaceAfter;
    private int viewWidth = -1;
    private int viewHeight = -1;
    private boolean clip = false;
    private Rectangle2D placement = null;

    public ExternalGraphic(FONode parent) {
        super(parent);
    }

    public void addLayoutManager(List list) {
        InlineArea area = this.getInlineArea();
        if (area != null) {
            this.setupID();
            LeafNodeLayoutManager lm = new LeafNodeLayoutManager();
            lm.setUserAgent(this.getUserAgent());
            lm.setFObj(this);
            lm.setCurrentArea(area);
            lm.setAlignment(this.properties.get("vertical-align").getEnum());
            lm.setLead(this.viewHeight);
            list.add(lm);
        }
    }

    protected InlineArea getInlineArea() {
        this.setup();
        if (this.url == null) {
            return null;
        }
        Image imArea = new Image(this.url);
        Viewport vp = new Viewport(imArea);
        vp.setWidth(this.viewWidth);
        vp.setHeight(this.viewHeight);
        vp.setClip(this.clip);
        vp.setContentPosition(this.placement);
        vp.setOffset(0);
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        TraitSetter.addBorders(vp, bap);
        TraitSetter.addBackground(vp, bProps);
        return vp;
    }

    public void setup() {
        int scaling;
        Length cw;
        this.url = this.properties.get("src").getString();
        if (this.url == null) {
            return;
        }
        this.url = ImageFactory.getURL(this.url);
        Length ipd = this.properties.get("inline-progression-dimension.optimum").getLength();
        if (!ipd.isAuto()) {
            this.viewWidth = ipd.getValue();
        } else {
            ipd = this.properties.get("width").getLength();
            if (!ipd.isAuto()) {
                this.viewWidth = ipd.getValue();
            }
        }
        Length bpd = this.properties.get("block-progression-dimension.optimum").getLength();
        if (!bpd.isAuto()) {
            this.viewHeight = bpd.getValue();
        } else {
            bpd = this.properties.get("height").getLength();
            if (!bpd.isAuto()) {
                this.viewHeight = bpd.getValue();
            }
        }
        FopImage fopimage = null;
        int cwidth = -1;
        int cheight = -1;
        Length ch = this.properties.get("content-height").getLength();
        if (!ch.isAuto()) {
            cheight = ch.getValue();
        }
        if (!(cw = this.properties.get("content-width").getLength()).isAuto()) {
            cwidth = cw.getValue();
        }
        if ((scaling = this.properties.get("scaling").getEnum()) == 100 || cwidth == -1 || cheight == -1) {
            ImageFactory fact = ImageFactory.getInstance();
            fopimage = fact.getImage(this.url, this.userAgent);
            if (fopimage == null) {
                this.url = null;
                return;
            }
            if (!fopimage.load(1, this.userAgent)) {
                this.url = null;
                return;
            }
            if (cwidth == -1) {
                cwidth = fopimage.getWidth() * 1000;
            }
            if (cheight == -1) {
                cheight = fopimage.getHeight() * 1000;
            }
            if (scaling == 100) {
                double rat2;
                double rat1 = (float)cwidth / ((float)fopimage.getWidth() * 1000.0f);
                if (rat1 < (rat2 = (double)((float)cheight / ((float)fopimage.getHeight() * 1000.0f)))) {
                    cheight = (int)(rat1 * (double)fopimage.getHeight() * 1000.0);
                } else {
                    cwidth = (int)(rat2 * (double)fopimage.getWidth() * 1000.0);
                }
            }
        }
        if (this.viewWidth == -1) {
            this.viewWidth = cwidth;
        }
        if (this.viewHeight == -1) {
            this.viewHeight = cheight;
        }
        if (cwidth > this.viewWidth || cheight > this.viewHeight) {
            int overflow = this.properties.get("overflow").getEnum();
            if (overflow == 36) {
                this.clip = true;
            } else if (overflow == 26) {
                this.getLogger().error("Image: " + this.url + " overflows the viewport, clipping to viewport");
                this.clip = true;
            }
        }
        int xoffset = 0;
        int yoffset = 0;
        int da = this.properties.get("display-align").getEnum();
        switch (da) {
            case 10: {
                break;
            }
            case 3: {
                yoffset = this.viewHeight - cheight;
                break;
            }
            case 14: {
                yoffset = (this.viewHeight - cheight) / 2;
                break;
            }
        }
        int ta = this.properties.get("text-align").getEnum();
        switch (ta) {
            case 14: {
                xoffset = (this.viewWidth - cwidth) / 2;
                break;
            }
            case 23: {
                xoffset = this.viewWidth - cwidth;
                break;
            }
            case 87: {
                break;
            }
        }
        this.placement = new Rectangle2D.Float(xoffset, yoffset, cwidth, cheight);
        AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
        AuralProps mAurProps = this.propMgr.getAuralProps();
        MarginInlineProps mProps = this.propMgr.getMarginInlineProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
    }
}

