/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.XMLObj;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layoutmgr.LeafNodeLayoutManager;
import org.w3c.dom.Document;

public class InstreamForeignObject
extends FObj {
    private Viewport areaCurrent;

    public InstreamForeignObject(FONode parent) {
        super(parent);
    }

    public void addLayoutManager(List list) {
        this.areaCurrent = this.getInlineArea();
        if (this.areaCurrent != null) {
            LeafNodeLayoutManager lm = new LeafNodeLayoutManager();
            lm.setUserAgent(this.getUserAgent());
            lm.setFObj(this);
            lm.setCurrentArea(this.areaCurrent);
            lm.setAlignment(this.properties.get("vertical-align").getEnum());
            lm.setLead(this.areaCurrent.getHeight());
            list.add(lm);
        }
    }

    protected Viewport getInlineArea() {
        int scaling;
        Point2D.Float csize;
        Point2D size;
        Length len;
        if (this.children == null) {
            return this.areaCurrent;
        }
        if (this.children.size() != 1) {
            return null;
        }
        FONode fo = (FONode)this.children.get(0);
        if (!(fo instanceof XMLObj)) {
            return null;
        }
        XMLObj child = (XMLObj)fo;
        AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
        AuralProps mAurProps = this.propMgr.getAuralProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        MarginInlineProps mProps = this.propMgr.getMarginInlineProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
        boolean hasLH = false;
        int bpd = -1;
        int ipd = -1;
        boolean bpdauto = false;
        if (hasLH) {
            bpd = this.properties.get("line-height").getLength().getValue();
        } else {
            len = this.properties.get("block-progression-dimension.optimum").getLength();
            if (!len.isAuto()) {
                bpd = len.getValue();
            } else {
                len = this.properties.get("height").getLength();
                if (!len.isAuto()) {
                    bpd = len.getValue();
                }
            }
        }
        len = this.properties.get("inline-progression-dimension.optimum").getLength();
        if (!len.isAuto()) {
            ipd = len.getValue();
        } else {
            len = this.properties.get("width").getLength();
            if (!len.isAuto()) {
                ipd = len.getValue();
            }
        }
        int cwidth = -1;
        int cheight = -1;
        len = this.properties.get("content-width").getLength();
        if (!len.isAuto()) {
            cwidth = len.getValue();
        }
        if (!(len = this.properties.get("content-height").getLength()).isAuto()) {
            cheight = len.getValue();
        }
        if ((size = child.getDimension(csize = new Point2D.Float(cwidth == -1 ? -1.0f : (float)cwidth / 1000.0f, cheight == -1 ? -1.0f : (float)cheight / 1000.0f))) == null) {
            return null;
        }
        if (cwidth == -1) {
            cwidth = (int)size.getX() * 1000;
        }
        if (cheight == -1) {
            cheight = (int)size.getY() * 1000;
        }
        if ((scaling = this.properties.get("scaling").getEnum()) == 100) {
            double rat2;
            double rat1 = (double)cwidth / (size.getX() * 1000.0);
            if (rat1 < (rat2 = (double)cheight / (size.getY() * 1000.0))) {
                cheight = (int)(rat1 * size.getY() * 1000.0);
            } else {
                cwidth = (int)(rat2 * size.getX() * 1000.0);
            }
        }
        if (ipd == -1) {
            ipd = cwidth;
        }
        if (bpd == -1) {
            bpd = cheight;
        }
        boolean clip = false;
        if (cwidth > ipd || cheight > bpd) {
            int overflow = this.properties.get("overflow").getEnum();
            if (overflow == 36) {
                clip = true;
            } else if (overflow == 26) {
                this.getLogger().error("Instream foreign object overflows the viewport: clipping");
                clip = true;
            }
        }
        int xoffset = 0;
        int yoffset = 0;
        int da = this.properties.get("display-align").getEnum();
        switch (da) {
            case 10: {
                break;
            }
            case 3: {
                yoffset = bpd - cheight;
                break;
            }
            case 14: {
                yoffset = (bpd - cheight) / 2;
                break;
            }
        }
        int ta = this.properties.get("text-align").getEnum();
        switch (ta) {
            case 14: {
                xoffset = (ipd - cwidth) / 2;
                break;
            }
            case 23: {
                xoffset = ipd - cwidth;
                break;
            }
            case 87: {
                break;
            }
        }
        Rectangle2D.Float placement = new Rectangle2D.Float(xoffset, yoffset, cwidth, cheight);
        Document doc = child.getDocument();
        String ns = child.getDocumentNamespace();
        this.children = null;
        ForeignObject foreign = new ForeignObject(doc, ns);
        this.areaCurrent = new Viewport(foreign);
        this.areaCurrent.setWidth(ipd);
        this.areaCurrent.setHeight(bpd);
        this.areaCurrent.setContentPosition(placement);
        this.areaCurrent.setClip(clip);
        this.areaCurrent.setOffset(0);
        return this.areaCurrent;
    }

    public boolean generatesInlineAreas() {
        return true;
    }
}

