/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layoutmgr.list.ListBlockLayoutManager;

public class ListBlock
extends FObj {
    private int align;
    private int alignLast;
    private int breakBefore;
    private int breakAfter;
    private int lineHeight;
    private int startIndent;
    private int endIndent;
    private int spaceBefore;
    private int spaceAfter;
    private int spaceBetweenListRows = 0;
    private ColorType backgroundColor;

    public ListBlock(FONode parent) {
        super(parent);
    }

    public void addLayoutManager(List list) {
        ListBlockLayoutManager blm = new ListBlockLayoutManager();
        blm.setUserAgent(this.getUserAgent());
        blm.setFObj(this);
        list.add(blm);
    }

    public void setup() throws FOPException {
        AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
        AuralProps mAurProps = this.propMgr.getAuralProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        MarginProps mProps = this.propMgr.getMarginProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
        this.setupID();
        this.align = this.properties.get("text-align").getEnum();
        this.alignLast = this.properties.get("text-align-last").getEnum();
        this.lineHeight = this.properties.get("line-height").getLength().getValue();
        this.startIndent = this.properties.get("start-indent").getLength().getValue();
        this.endIndent = this.properties.get("end-indent").getLength().getValue();
        this.spaceBefore = this.properties.get("space-before.optimum").getLength().getValue();
        this.spaceAfter = this.properties.get("space-after.optimum").getLength().getValue();
        this.spaceBetweenListRows = 0;
        this.backgroundColor = this.properties.get("background-color").getColorType();
    }

    public boolean generatesInlineAreas() {
        return false;
    }

    protected boolean containsMarkers() {
        return true;
    }
}

